/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.amp.escape.view;

import java.io.IOException;
import java.util.HashMap;
import java.util.TooManyListenersException;
import org.ascape.model.event.ScapeEvent;
import org.eclipse.amp.amf.adata.Catalog;
import org.eclipse.amp.amf.adata.impl.DataFactoryImpl;
import org.eclipse.amp.escape.view.EMFSimDataCollector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.BinaryResourceImpl;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.metaabm.SContext;

public class FileEMFSimDataCollector
extends EMFSimDataCollector {
    private static final long serialVersionUID = 1L;
    private ResourceSet resourceSet;
    private URI dataFileURI;
    private Resource dataResource;
    public static final IPath RESULTS_FOLDER = new Path("output");

    public FileEMFSimDataCollector(IResource resource, SContext model) {
        super(model);
        assert (resource != null);
        IProject project = resource.getProject();
        IPath projectPath = RESULTS_FOLDER.append(resource.getProjectRelativePath().removeFirstSegments(1).removeLastSegments(1)).append(String.valueOf(this.getFileName(resource)) + ".adata");
        this.dataFileURI = URI.createPlatformResourceURI((String)(String.valueOf(project.getName()) + "/" + projectPath), (boolean)true);
    }

    private String getFileName(IResource resource) {
        String name = ((IFile)resource).getProjectRelativePath().removeFileExtension().lastSegment();
        return name;
    }

    @Override
    public void scapeAdded(ScapeEvent scapeEvent) throws TooManyListenersException {
        super.scapeAdded(scapeEvent);
        Resource.Factory binResourceFactory = new Resource.Factory(){

            public Resource createResource(URI uri) {
                return new BinaryResourceImpl(uri);
            }
        };
        this.resourceSet = new ResourceSetImpl();
        this.resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("adata", binResourceFactory);
        boolean exists = this.resourceSet.getURIConverter().exists(this.dataFileURI, null);
        if (exists) {
            this.dataResource = this.resourceSet.getResource(this.dataFileURI, true);
            this.setCatalog((Catalog)this.dataResource.getContents().get(0));
        } else {
            this.dataResource = this.resourceSet.createResource(this.dataFileURI);
            this.setCatalog(DataFactoryImpl.eINSTANCE.createCatalog());
            this.dataResource.getContents().add((Object)this.getCatalog());
        }
        this.saveResults();
    }

    @Override
    public void scapeStopped(ScapeEvent scapeEvent) {
        super.scapeStopped(scapeEvent);
        this.saveResults();
    }

    public void scapeRemoved(ScapeEvent scapeEvent) {
        super.scapeRemoved(scapeEvent);
        if (this.dataResource != null) {
            this.dataResource.unload();
            this.resourceSet.getResources().remove((Object)this.dataResource);
        }
    }

    private synchronized void saveResults() {
        HashMap<String, Object> saveOptions = new HashMap<String, Object>();
        try {
            saveOptions.put("SAVE_ONLY_IF_CHANGED", null);
            this.dataResource.save(saveOptions);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

