/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw3d.offscreen;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import org.eclipse.draw3d.graphics3d.Graphics3D;
import org.eclipse.draw3d.graphics3d.Graphics3DMetaData;
import org.eclipse.draw3d.graphics3d.Graphics3DOffscreenBufferConfig;
import org.eclipse.draw3d.graphics3d.Graphics3DOffscreenBuffers;
import org.eclipse.draw3d.util.BufferUtils;

public class OffscreenRenderer {
    private Graphics3DOffscreenBufferConfig m_bufferConfig;
    private ByteBuffer m_colorBuffer;
    private FloatBuffer m_depthBuffer;
    private int m_height;
    private Graphics3DOffscreenBuffers m_offscreenBuffers;
    private State m_state = State.UNINITIALZED;
    private int m_width;

    public OffscreenRenderer(Graphics3DOffscreenBufferConfig i_bufferConfig) {
        this.setBufferConfig(i_bufferConfig);
    }

    private void checkState(boolean i_valid, State ... i_states) {
        State[] stateArray = i_states;
        int n = i_states.length;
        int n2 = 0;
        while (n2 < n) {
            State state = stateArray[n2];
            if (!i_valid && this.m_state == state) {
                throw new IllegalStateException("offscreen renderer is " + (Object)((Object)this.m_state));
            }
            if (i_valid && this.m_state != state) {
                throw new IllegalStateException("offscreen renderer must be " + (Object)((Object)this.m_state));
            }
            ++n2;
        }
    }

    public void dispose() {
        this.checkState(false, State.DISPOSED);
        this.m_colorBuffer = null;
        this.m_depthBuffer = null;
        this.m_offscreenBuffers.dispose();
        this.m_state = State.DISPOSED;
    }

    public Graphics3DOffscreenBufferConfig getBufferConfig() {
        return this.m_bufferConfig;
    }

    public ByteBuffer getColorBuffer() {
        this.checkState(true, State.RENDERED);
        if (!this.m_bufferConfig.isEnabled(16384)) {
            throw new IllegalStateException("color buffer is disabled");
        }
        return this.m_colorBuffer;
    }

    public FloatBuffer getDepthBuffer() {
        this.checkState(true, State.RENDERED);
        if (!this.m_bufferConfig.isEnabled(256)) {
            throw new IllegalStateException("depth buffer is disabled");
        }
        return this.m_depthBuffer;
    }

    public int getHeight() {
        this.checkState(false, State.UNINITIALZED, State.DISPOSED);
        return this.m_height;
    }

    public int getWidth() {
        this.checkState(false, State.UNINITIALZED, State.DISPOSED);
        return this.m_width;
    }

    private void initBuffers() {
        this.m_colorBuffer = null;
        this.m_depthBuffer = null;
        int size = this.m_width * this.m_height;
        if (this.m_bufferConfig.isEnabled(16384)) {
            this.m_colorBuffer = BufferUtils.createByteBuffer(size * this.m_bufferConfig.getColorBpp());
        }
        if (this.m_bufferConfig.isEnabled(256)) {
            this.m_depthBuffer = BufferUtils.createFloatBuffer(size);
        }
    }

    public boolean isBackBufferEnabled() {
        this.checkState(false, State.UNINITIALZED, State.DISPOSED);
        return Graphics3DMetaData.isBackBuffer((Graphics3DOffscreenBuffers)this.m_offscreenBuffers);
    }

    public void render(Runnable i_renderOperation) {
        if (i_renderOperation == null) {
            throw new NullPointerException("i_renderOperation must not be null");
        }
        this.checkState(false, State.UNINITIALZED, State.DISPOSED);
        if (this.m_state == State.INVALID) {
            this.initBuffers();
            this.m_offscreenBuffers.initBuffers();
            this.m_state = State.VALID;
        }
        this.m_offscreenBuffers.preRender();
        i_renderOperation.run();
        this.m_offscreenBuffers.postRender(this.m_colorBuffer, this.m_depthBuffer);
        this.m_state = State.RENDERED;
    }

    public void setBufferConfig(Graphics3DOffscreenBufferConfig i_bufferConfig) {
        this.checkState(false, State.DISPOSED);
        if (i_bufferConfig == null) {
            throw new NullPointerException("i_bufferConfig must not be null");
        }
        this.m_bufferConfig = i_bufferConfig;
        if (this.m_offscreenBuffers != null) {
            this.m_offscreenBuffers.dispose();
            this.m_offscreenBuffers = null;
        }
        Graphics3D g3d = i_bufferConfig.getGraphics3D();
        this.m_offscreenBuffers = g3d.getGraphics3DOffscreenBuffer(this.m_height, this.m_width, this.m_bufferConfig);
        this.m_offscreenBuffers.init();
        this.m_state = State.INVALID;
    }

    public void setDimensions(int i_width, int i_height) {
        this.checkState(false, State.UNINITIALZED, State.DISPOSED);
        if (i_width < 1 || i_height < 1) {
            throw new IllegalArgumentException("width and height must be positive");
        }
        if (i_width == this.m_width && i_height == this.m_height) {
            return;
        }
        this.m_width = i_width;
        this.m_height = i_height;
        if (this.m_offscreenBuffers != null) {
            this.m_offscreenBuffers.setHeight(i_height);
            this.m_offscreenBuffers.setWidth(i_width);
        }
        this.m_state = State.INVALID;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        DISPOSED,
        INVALID,
        RENDERED,
        UNINITIALZED,
        VALID;

    }
}

