/*
 * Decompiled with CFR 0.152.
 */
package org.ascape.view.nonvis;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.TooManyListenersException;
import org.ascape.model.Agent;
import org.ascape.model.Scape;
import org.ascape.model.event.ScapeEvent;
import org.ascape.util.PropertyAccessor;
import org.ascape.view.nonvis.NonGraphicView;

public class ScapeFromFileView
extends NonGraphicView {
    private static final long serialVersionUID = 1L;
    public static final int UNDEFINED_MODE = 0;
    public static final int SIZE_BY_FILE_SEQUENTIAL_MODE = 1;
    public static final int SIZE_BY_SCAPE_SEQUENTIAL_MODE = 2;
    public static final int SIZE_BY_SCAPE_RANDOM_SAMPLE_MODE = 3;
    public static final int UNDEFINED_ORDER = 0;
    public static final int ASSIGN_RANDOM_ORDER = 1;
    public static final int ASSIGN_SEQUENTIAL_ORDER = 2;
    private transient BufferedReader reader;
    private int mode = 0;
    private int order = 0;
    private ArrayList randomLines;
    private int currentLine;
    private String lastLineRead;
    private File file;
    public static final Comparator BACKWARD_COMPARE = new Comparator(){

        public int compare(Object o1, Object o2) {
            return -((Comparable)o1).compareTo(o2);
        }
    };

    public void setFile(String filename) throws IOException {
        this.file = new File(filename);
        this.reader = new BufferedReader(new FileReader(this.file));
        this.reader.mark(4000000);
    }

    public void setInputStream(InputStream inputStream) throws IOException {
        this.reader = new BufferedReader(new InputStreamReader(inputStream));
        this.reader.mark(400000);
    }

    private String retrieveNextLine() throws IOException {
        if (this.mode == 2 || this.mode == 1) {
            ++this.currentLine;
            return this.reader.readLine();
        }
        if (this.mode == 3) {
            if (this.randomLines.size() > 0) {
                int targetLine = (Integer)this.randomLines.remove(this.randomLines.size() - 1);
                while (this.currentLine <= targetLine) {
                    this.lastLineRead = this.reader.readLine();
                    ++this.currentLine;
                }
                return this.lastLineRead;
            }
            return null;
        }
        throw new RuntimeException("Bad Mode in file control view: " + this.mode);
    }

    private void resetReader() throws IOException {
        if (this.reader != null) {
            if (this.file != null) {
                this.reader.close();
                this.reader = new BufferedReader(new FileReader(this.file));
            } else {
                this.reader.reset();
            }
        } else {
            this.reader = new BufferedReader(new FileReader(this.file));
        }
    }

    public void scapeInitialized(ScapeEvent scapeEvent) {
        if (this.mode == 1) {
            this.getScape().clear();
        }
        try {
            PropertyDescriptor[] candidateDescriptors;
            if (this.mode == 3) {
                this.resetReader();
                int numLines = 0;
                this.reader.readLine();
                while (this.reader.readLine() != null) {
                    ++numLines;
                }
                this.randomLines = new ArrayList();
                int i = 0;
                while (i < this.getScape().getSize()) {
                    this.randomLines.add(new Integer(this.getScape().randomToLimit(numLines) + 1));
                    ++i;
                }
                Collections.sort(this.randomLines, BACKWARD_COMPARE);
            }
            this.currentLine = 1;
            this.resetReader();
            String nextLine = this.reader.readLine();
            ArrayList<PropertyDescriptor> descriptors = new ArrayList<PropertyDescriptor>();
            try {
                candidateDescriptors = Introspector.getBeanInfo(this.getScape().getPrototypeAgent().getClass(), Agent.class).getPropertyDescriptors();
            }
            catch (IntrospectionException e) {
                throw new RuntimeException("While reading prototype agent descriptors: " + e);
            }
            StringTokenizer st = new StringTokenizer(nextLine, "\t");
            while (st.hasMoreTokens()) {
                boolean paramFound = false;
                String parameterName = st.nextToken();
                int i = 0;
                while (i < candidateDescriptors.length) {
                    if (candidateDescriptors[i].getName().equalsIgnoreCase(parameterName)) {
                        descriptors.add(candidateDescriptors[i]);
                        paramFound = true;
                    }
                    ++i;
                }
                if (paramFound) continue;
                throw new RuntimeException("Property defined in ScapeFile file " + this.reader + " not found in prototype agent class: " + parameterName);
            }
            Iterator scapeIterator = null;
            if (this.getMode() != 1) {
                if (this.order == 2) {
                    scapeIterator = this.getScape().iterator();
                } else if (this.order == 1) {
                    scapeIterator = this.getScape().getSpace().safeRandomIterator();
                } else {
                    throw new RuntimeException("Undefined or unknown order value.");
                }
            }
            nextLine = this.retrieveNextLine();
            while (nextLine != null) {
                Agent currentAgent;
                st = new StringTokenizer(nextLine, "\t");
                if (scapeIterator != null) {
                    if (!scapeIterator.hasNext()) break;
                    currentAgent = (Agent)scapeIterator.next();
                } else if (this.order == 2) {
                    currentAgent = (Agent)((Object)this.getScape().getSpace().newLocation(false));
                } else if (this.order == 1) {
                    currentAgent = (Agent)((Object)this.getScape().getSpace().newLocation(true));
                } else {
                    throw new RuntimeException("Undefined or unknown order value.");
                }
                Iterator descIter = descriptors.iterator();
                while (descIter.hasNext()) {
                    String token = st.nextToken();
                    PropertyDescriptor desc = (PropertyDescriptor)descIter.next();
                    Object[] args = new Object[1];
                    try {
                        args[0] = PropertyAccessor.stringAsClass(desc.getPropertyType(), token);
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException("Error at data line " + this.currentLine + ": " + token + " can not be converted to (" + desc.getPropertyType() + ") " + desc.getDisplayName());
                    }
                    try {
                        desc.getWriteMethod().invoke((Object)currentAgent, args);
                    }
                    catch (IllegalAccessException e) {
                        this.getScape().getEnvironment().getConsole().println("Error in dynamic method write: " + e);
                    }
                    catch (IllegalArgumentException e) {
                        this.getScape().getEnvironment().getConsole().println("Error in dynamic method write: " + e);
                    }
                    catch (InvocationTargetException e) {
                        this.getScape().getEnvironment().getConsole().println("Error in dynamic method write: " + e);
                    }
                    catch (NullPointerException e) {
                        throw new RuntimeException("Bad Property Descriptor: " + desc.getName());
                    }
                }
                nextLine = this.retrieveNextLine();
            }
            if (scapeIterator != null && scapeIterator.hasNext()) {
                this.getScape().getEnvironment().getConsole().println("Warning: ScapeFile contains less data than there are agents in the target scape: " + this.getScape());
            }
            if (nextLine != null && scapeIterator != null && !scapeIterator.hasNext()) {
                this.getScape().getEnvironment().getConsole().println("Warning: ScapeFile contains more data than there are agents in the target scape: " + this.getScape());
            }
        }
        catch (IOException e) {
            throw new RuntimeException("An IO Exception happend while reading ScapeFile file data: " + e);
        }
    }

    private void onModeOrScapeSelection() {
        if (this.mode == 1) {
            if (this.getScape() != null && !this.getScape().isMutable()) {
                throw new RuntimeException("Population size can not be defined by file for immutable (fixed size) scapes. Set PopulationSizeDefinedByFile to false or use a mutable scape.");
            }
            this.scape.setPopulateOnCreate(false);
        }
    }

    public void scapeAdded(ScapeEvent scapeEvent) throws TooManyListenersException {
        super.scapeAdded(scapeEvent);
        if (this.mode == 0) {
            if (((Scape)scapeEvent.getSource()).isMutable()) {
                this.setMode(1);
            } else {
                this.setMode(2);
            }
        } else {
            this.onModeOrScapeSelection();
        }
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
        if (order != 2 && order != 1) {
            throw new RuntimeException("Undefined or unknown order value.");
        }
    }

    public int getMode() {
        return this.mode;
    }

    public void setMode(int mode) {
        this.mode = mode;
        if (mode != 2 && mode != 1 && mode != 3) {
            throw new RuntimeException("Bad Mode in file control view: " + mode);
        }
        if (this.order == 0) {
            if (mode == 3) {
                this.setOrder(1);
            } else {
                this.setOrder(2);
            }
        }
        this.onModeOrScapeSelection();
    }

    public void scapeDeserialized(ScapeEvent event) {
        super.scapeDeserialized(event);
        try {
            this.resetReader();
        }
        catch (IOException e) {
            this.getScape().getEnvironment().getConsole().println(e.toString());
        }
    }
}

