/*
 * Decompiled with CFR 0.152.
 */
package org.metaabm.commands;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.metaabm.act.AInput;
import org.metaabm.act.ASink;
import org.metaabm.act.MetaABMActFactory;
import org.metaabm.act.MetaABMActPackage;
import org.metaabm.commands.MultiValueCommand;
import org.metaabm.function.FFunction;
import org.metaabm.function.FGeneric;
import org.metaabm.function.FOperator;

public class SetSinkFunctionCommand
extends MultiValueCommand {
    private FFunction oldFunction;

    public SetSinkFunctionCommand(EditingDomain domain, ASink sink, FFunction newFunction) {
        super(domain, sink, newFunction);
        this.oldFunction = sink.getFunction();
    }

    protected boolean prepare() {
        int newCount = 0;
        if (this.function instanceof FGeneric) {
            newCount = ((FGeneric)this.function).getInputPrototypes().size();
        } else if (this.function instanceof FOperator) {
            newCount = ((FOperator)this.function).getArity();
        }
        int oldCount = this.sink.getInputs().size();
        Object commonInputs = null;
        List orphanedInputs = Collections.emptyList();
        if (newCount < oldCount) {
            orphanedInputs = this.sink.getInputs().subList(newCount, oldCount);
            this.append(RemoveCommand.create((EditingDomain)this.domain, (Object)this.sink, (Object)MetaABMActPackage.Literals.ASINK__INPUTS, (Collection)orphanedInputs));
            commonInputs = this.sink.getInputs().subList(0, newCount);
        } else if (newCount > oldCount) {
            commonInputs = new ArrayList();
            commonInputs.addAll(this.sink.getInputs());
            ArrayList<AInput> newInputs = new ArrayList<AInput>();
            int i = 0;
            while (i < newCount - oldCount) {
                AInput newInput = MetaABMActFactory.eINSTANCE.createAInput();
                newInputs.add(newInput);
                commonInputs.add(newInput);
                ++i;
            }
            this.append(AddCommand.create((EditingDomain)this.domain, (Object)this.sink, (Object)MetaABMActPackage.Literals.ASINK__INPUTS, newInputs, (int)oldCount));
        } else {
            commonInputs = this.sink.getInputs();
        }
        if (this.function != null && this.function.isMultiValue()) {
            this.createMultiFunction((List<AInput>)commonInputs);
            if (this.oldFunction != null && this.oldFunction.isMultiValue()) {
                this.removeMultiFunction(orphanedInputs);
            }
        } else if (this.oldFunction != null && this.oldFunction.isMultiValue()) {
            this.removeMultiFunction((List<AInput>)this.sink.getInputs());
        }
        return super.prepare();
    }
}

