/*
 * Decompiled with CFR 0.152.
 */
package org.ascape.model.space;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.ascape.model.space.Array2D;
import org.ascape.model.space.Array2DSmallWorld;
import org.ascape.model.space.BFSWithinIterator;
import org.ascape.model.space.CollectionSpace;
import org.ascape.model.space.Discrete;
import org.ascape.model.space.Location;
import org.ascape.model.space.Node;
import org.ascape.util.Conditional;

public class BFSWithinIterator2DSmallWorld
extends BFSWithinIterator {
    List origins;
    Conditional containsSW = new Conditional(){
        private static final long serialVersionUID = 1L;

        @Override
        public boolean meetsCondition(Object object) {
            return ((Array2DSmallWorld)BFSWithinIterator2DSmallWorld.this.getSpace()).getSmallWorldCells().contains(object);
        }
    };

    public BFSWithinIterator2DSmallWorld(Discrete space, Location origin, Conditional condition, boolean includeSelf, double distance) {
        super(space, origin, condition, includeSelf, distance);
    }

    @Override
    protected void initialize() {
        this.origins = new ArrayList();
        ArrayList<Location> originDepthList = new ArrayList<Location>();
        originDepthList.add(this.getOrigin());
        this.origins.add(originDepthList);
        if (this.includeSelf) {
            this.setDepth(0);
            this.setLastDepth(0);
        } else {
            this.setDepth(1);
            this.setLastDepth(1);
        }
        this.setSearchIterator(this.nextDepth());
    }

    @Override
    public void visit(Node candidate) {
    }

    @Override
    public Iterator nextDepth() {
        List originDepthList;
        this.nextSearch = new ArrayList();
        int originDepth = 0;
        while (originDepth <= this.getInternalDepth() + 2) {
            if (this.origins.size() <= originDepth) {
                originDepthList = new ArrayList();
                this.origins.add(originDepth, originDepthList);
            }
            ++originDepth;
        }
        originDepth = 0;
        while (originDepth <= this.getInternalDepth() && this.visited.size() <= this.getSpace().getSize()) {
            originDepthList = (List)this.origins.get(originDepth);
            for (Node node : originDepthList) {
                boolean includeOrigin = originDepth > 0 || this.includeSelf;
                ArrayList neighborsMoore = new ArrayList(((Array2DSmallWorld)this.getSpace()).findWithinMoore(node.getCoordinate(), includeOrigin, this.getInternalDepth() - originDepth));
                neighborsMoore.removeAll(this.getVisited());
                List neighborsSW = CollectionSpace.filter(neighborsMoore, this.containsSW);
                block3: for (Node swNode : neighborsSW) {
                    for (Node neighborNode : swNode.findNeighbors()) {
                        if (!(((Array2D)this.getSpace()).calculateDistanceMoore(swNode.getCoordinate(), neighborNode.getCoordinate()) > 1.0)) continue;
                        ((List)this.origins.get(originDepth + 2)).add(neighborNode);
                        continue block3;
                    }
                }
                this.getVisited().addAll(neighborsMoore);
                this.nextSearch.addAll(neighborsMoore);
            }
            ++originDepth;
        }
        return this.nextSearch.iterator();
    }

    class InList
    implements Conditional {
        private static final long serialVersionUID = 1L;
        Collection list;

        public InList(Collection list) {
            this.list = list;
        }

        @Override
        public boolean meetsCondition(Object object) {
            return this.list.contains(object);
        }
    }
}

