/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.amp.agf3d;

import java.util.List;
import org.eclipse.amp.agf.gef.GEFUtils;
import org.eclipse.amp.agf.gef.ScapeEditPart;
import org.eclipse.amp.agf3d.ScapeEdit3DPart;
import org.eclipse.amp.axf.core.ICompositionProvider;
import org.eclipse.amp.axf.space.ILocation;
import org.eclipse.amp.axf.space.ILocation2D;
import org.eclipse.amp.axf.space.ILocationProvider;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw3d.Figure3D;
import org.eclipse.draw3d.FigureSurface;
import org.eclipse.draw3d.IFigure3D;
import org.eclipse.draw3d.ISurface;
import org.eclipse.gef.EditPart;
import org.eclipse.jface.viewers.IFilter;

public class ScapeEditRoot3DPart
extends ScapeEdit3DPart {
    public static final int DEFAULT_ANIMATION_STEP_COUNT = 5;
    private int animationStep;
    private int animationStepCount = 5;

    public ScapeEditRoot3DPart(ICompositionProvider memberProvider, ILocationProvider locationProvider, IFilter filter) {
        super(memberProvider, locationProvider, filter);
    }

    @Override
    protected IFigure createFigure() {
        this.figure = new Figure3D(){
            private ISurface m_surface = new FigureSurface((IFigure3D)this);

            public ISurface getSurface() {
                return this.m_surface;
            }
        };
        this.figure.setLayoutManager((LayoutManager)new XYLayout());
        Rectangle bounds = new Rectangle(new Point(0, 0), this.calculateDimension());
        this.figure.setBounds(bounds);
        return this.figure;
    }

    public Dimension calculateDimension() {
        ILocation extent = this.getLocationProvider().getExtent(this.getModelRoot());
        if (extent instanceof ILocation2D) {
            return GEFUtils.toScaledDimension((ILocation2D)((ILocation2D)extent));
        }
        return null;
    }

    protected List getModelChildren() {
        return this.getMemberProvider().getList(this.getModel());
    }

    @Override
    protected void addChild(EditPart child, int index) {
        super.addChild(child, index);
    }

    public ScapeEditPart getRootScapeEditPart() {
        return this;
    }

    public int getAnimationStep() {
        return this.animationStep;
    }

    public int getAnimationStepCount() {
        return this.animationStepCount;
    }

    public int setAnimationStep(int animationStep) {
        this.animationStep = animationStep;
        return animationStep;
    }

    public void setAnimationStepCount(int animationStepCount) {
        this.animationStepCount = animationStepCount;
        this.animationStep = 0;
    }
}

