/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw3d.camera;

import org.eclipse.draw3d.camera.ICamera;
import org.eclipse.draw3d.geometry.IVector2f;
import org.eclipse.draw3d.geometry.IVector3f;
import org.eclipse.draw3d.geometry.Math3D;
import org.eclipse.draw3d.geometry.Vector3f;
import org.eclipse.draw3d.graphics3d.ILodHelper;
import org.eclipse.draw3d.util.Draw3DCache;

public class CameraLodHelper
implements ILodHelper {
    private ICamera m_camera;

    public CameraLodHelper(ICamera i_camera) {
        this.m_camera = i_camera;
    }

    public float getNormalizedArea(IVector3f i_position, IVector2f i_size, IVector3f i_normal) {
        float f;
        Vector3f cPos = Draw3DCache.getVector3f();
        Vector3f v = Draw3DCache.getVector3f();
        Vector3f vDir = Draw3DCache.getVector3f();
        try {
            this.m_camera.getViewDirection(vDir);
            this.m_camera.getPosition(cPos);
            Math3D.sub((IVector3f)i_position, (IVector3f)cPos, (Vector3f)v);
            float d2 = v.lengthSquared();
            float sa = i_size.getX() * i_size.getY() / d2;
            float cosa = Math3D.dot((IVector3f)vDir, (IVector3f)i_normal);
            f = sa * Math.abs(cosa);
        }
        catch (Throwable throwable) {
            Draw3DCache.returnVector3f((Vector3f[])new Vector3f[]{cPos, v, vDir});
            throw throwable;
        }
        Draw3DCache.returnVector3f((Vector3f[])new Vector3f[]{cPos, v, vDir});
        return f;
    }

    public float getNormalizedDistance(IVector3f i_position, IVector2f i_size, IVector3f i_normal) {
        float cosa;
        float d;
        Vector3f vDir;
        Vector3f v;
        Vector3f cPos;
        block3: {
            cPos = Draw3DCache.getVector3f();
            v = Draw3DCache.getVector3f();
            vDir = Draw3DCache.getVector3f();
            try {
                v.setX(i_position.getX() + i_size.getX() / 2.0f);
                v.setY(i_position.getY() + i_size.getY() / 2.0f);
                v.setZ(i_position.getZ());
                this.m_camera.getViewDirection(vDir);
                this.m_camera.getPosition(cPos);
                Math3D.sub((IVector3f)v, (IVector3f)cPos, (Vector3f)v);
                d = v.length();
                cosa = Math3D.dot((IVector3f)vDir, (IVector3f)i_normal);
                if (cosa != 0.0f) break block3;
            }
            catch (Throwable throwable) {
                Draw3DCache.returnVector3f((Vector3f[])new Vector3f[]{cPos, v, vDir});
                throw throwable;
            }
            Draw3DCache.returnVector3f((Vector3f[])new Vector3f[]{cPos, v, vDir});
            return Float.MAX_VALUE;
        }
        float f = d / Math.abs(cosa);
        Draw3DCache.returnVector3f((Vector3f[])new Vector3f[]{cPos, v, vDir});
        return f;
    }
}

