/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.amp.agf.zest;

import org.eclipse.amp.agf.IGraphicsAdapter;
import org.eclipse.amp.agf.gef.AGFViewPart;
import org.eclipse.amp.agf.zest.SpringPartitionLayoutAlgorithm;
import org.eclipse.amp.agf.zest.ZestContentProvider;
import org.eclipse.amp.agf.zest.ZestStyleProvider;
import org.eclipse.amp.axf.core.ICompositionProvider;
import org.eclipse.amp.axf.core.ILifeCycleListener;
import org.eclipse.amp.axf.core.IModel;
import org.eclipse.amp.axf.space.IGraphProvider;
import org.eclipse.amp.axf.view.ModelInput;
import org.eclipse.amp.axf.view.SWTAsyncModelListener;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.Platform;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.zest.core.viewers.GraphViewer;
import org.eclipse.zest.layouts.LayoutAlgorithm;

public class GraphViewPart
extends AGFViewPart {
    static int INTIIAL_ITERATIONS = 10000;
    static int RUNNING_ITERATIONS = 1000;
    private GraphViewer viewer;
    private SpringPartitionLayoutAlgorithm springs;
    IAction springCustomizer;
    double gravity = 0.18;
    double strain = 0.03;
    double springLength = 0.8;
    double springMove = 0.5;

    public void createPartControl(Composite parent) {
        this.viewer = new GraphViewer(parent, 0);
        this.viewer.getControl().setBackground(parent.getDisplay().getSystemColor(1));
        this.setLayoutAlgorithm((LayoutAlgorithm)new SpringPartitionLayoutAlgorithm());
        super.createPartControl(parent);
    }

    public SpringPartitionLayoutAlgorithm createSpringLayout() {
        if (this.springs == null) {
            this.springs = new SpringPartitionLayoutAlgorithm();
        }
        this.springs.setSpringGravitation(this.gravity);
        this.springs.setSpringStrain(this.strain);
        this.springs.setSpringLength(this.springLength);
        this.springs.setSpringMove(this.springMove);
        this.springs.setSpringTimeout(1000L);
        return this.springs;
    }

    public void setInput(IEditorInput input) {
        super.setInput(input);
        ModelInput modelInput = (ModelInput)input;
        this.setModel(modelInput.getModel());
        if (this.getModel() != null) {
            IGraphProvider graphProvider = (IGraphProvider)Platform.getAdapterManager().getAdapter((Object)this.getModel(), IGraphProvider.class);
            ICompositionProvider compProvider = (ICompositionProvider)Platform.getAdapterManager().getAdapter((Object)this.getModel(), ICompositionProvider.class);
            ZestContentProvider contentProvider = new ZestContentProvider(graphProvider, compProvider);
            Assert.isNotNull((Object)graphProvider);
            Assert.isNotNull((Object)compProvider);
            Assert.isNotNull((Object)contentProvider);
            this.viewer.setContentProvider((IContentProvider)contentProvider);
            IGraphicsAdapter graphicsAdapter = (IGraphicsAdapter)Platform.getAdapterManager().getAdapter(this.getModel().getRoot(), IGraphicsAdapter.class);
            this.viewer.setLabelProvider((IBaseLabelProvider)new ZestStyleProvider(this.getViewer(), this.getModel().getRoot(), compProvider, graphicsAdapter));
            Object contents = null;
            contents = modelInput.getSelection() instanceof IStructuredSelection ? ((StructuredSelection)modelInput.getSelection()).getFirstElement() : this.getModel();
            this.viewer.getGraphControl().setScrollBarVisibility(FigureCanvas.NEVER);
            this.viewer.setInput(contents);
        }
    }

    public void createModelListeners() {
        super.createModelListeners();
        SWTAsyncModelListener refreshListener = new SWTAsyncModelListener(this.viewer.getControl(), "Refresh Graph"){

            public void update(IModel model) {
                GraphViewPart.this.viewer.refresh();
                GraphViewPart.this.viewer.applyLayout();
            }
        };
        this.addModelListener((ILifeCycleListener)refreshListener);
    }

    public void setFocus() {
        this.getViewer().getControl().setFocus();
    }

    public void setLayoutAlgorithm(LayoutAlgorithm layout) {
        this.viewer.setLayoutAlgorithm(layout, true);
        if (this.springCustomizer != null) {
            this.springCustomizer.setEnabled(layout instanceof SpringPartitionLayoutAlgorithm);
        }
    }

    public Object getAdapter(Class type) {
        if (type == ISelectionProvider.class) {
            return this.viewer;
        }
        return super.getAdapter(type);
    }

    public GraphViewer getViewer() {
        return this.viewer;
    }

    public double getStrain() {
        return this.strain;
    }

    public void setStrain(double strain) {
        this.strain = strain;
        this.setLayoutAlgorithm((LayoutAlgorithm)this.createSpringLayout());
    }

    public double getSpringLength() {
        return this.springLength;
    }

    public void setSpringLength(double length) {
        this.springLength = length;
        this.setLayoutAlgorithm((LayoutAlgorithm)this.createSpringLayout());
    }

    public double getGravity() {
        return this.gravity;
    }

    public void setGravity(double gravity) {
        this.gravity = gravity;
        this.setLayoutAlgorithm((LayoutAlgorithm)this.createSpringLayout());
    }

    public double getSpringMove() {
        return this.springMove;
    }

    public void setSpringMove(double springMove) {
        this.springMove = springMove;
        this.setLayoutAlgorithm((LayoutAlgorithm)this.createSpringLayout());
    }

    public SpringPartitionLayoutAlgorithm getSpringLayout() {
        return this.springs;
    }

    public IAction getSpringCustomizer() {
        return this.springCustomizer;
    }

    public void setSpringCustomizer(IAction springCustomizer) {
        this.springCustomizer = springCustomizer;
        springCustomizer.setEnabled(this.viewer.getGraphControl().getLayoutAlgorithm() instanceof SpringPartitionLayoutAlgorithm);
    }

    protected ISelectionProvider getSelectionProvider() {
        return this.viewer;
    }
}

