/*
 * Decompiled with CFR 0.152.
 */
package org.metaabm.commands;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.metaabm.IValue;
import org.metaabm.MetaABMFactory;
import org.metaabm.MetaABMPackage;
import org.metaabm.SAttribute;
import org.metaabm.SAttributeType;
import org.metaabm.SState;
import org.metaabm.SStateValue;
import org.metaabm.act.AInput;
import org.metaabm.act.AMultiValue;
import org.metaabm.act.ASink;
import org.metaabm.act.MetaABMActFactory;
import org.metaabm.act.MetaABMActPackage;
import org.metaabm.commands.SetLabelCommand;
import org.metaabm.function.FArgumentPrototype;
import org.metaabm.function.FFunction;

public class MultiValueCommand
extends CompoundCommand {
    protected EditingDomain domain;
    protected ASink sink;
    protected FFunction function;

    public MultiValueCommand(EditingDomain domain, ASink sink, FFunction newFunction) {
        this.domain = domain;
        this.sink = sink;
        this.function = newFunction;
    }

    public void addAttributesCross(List<AInput> inputs, Collection<SState> states, Collection<SStateValue> optionsPath) {
        Iterator<SState> iterator = states.iterator();
        if (iterator.hasNext()) {
            SState currentState = iterator.next();
            LinkedList<SState> remainingStates = new LinkedList<SState>();
            while (iterator.hasNext()) {
                remainingStates.add(iterator.next());
            }
            for (SStateValue option : currentState.getOptions()) {
                LinkedList<SStateValue> nextOptions = new LinkedList<SStateValue>(optionsPath);
                nextOptions.add(option);
                this.addAttributesCross(inputs, remainingStates, nextOptions);
            }
        } else {
            this.addAttributes(inputs, optionsPath);
        }
    }

    public void addAttributesSingle(List<AInput> inputs, Collection<SState> states, Collection<SStateValue> optionsPath) {
        Iterator<AInput> inputIter = inputs.iterator();
        inputIter.next();
        while (inputIter.hasNext()) {
            AMultiValue value = (AMultiValue)inputIter.next().getValue();
            this.addAtrributeCommand(value, String.valueOf(value.getLabel()) + " Base");
        }
        for (SState state : states) {
            for (SStateValue stateValue : state.getOptions()) {
                this.addAttributes(inputs, Collections.singleton(stateValue));
            }
        }
    }

    protected void addAttributes(List<AInput> inputs, Collection<SStateValue> processedOptions) {
        Iterator<AInput> inputIter = inputs.iterator();
        inputIter.next();
        int index = 1;
        while (inputIter.hasNext()) {
            this.addAttribute((AMultiValue)inputIter.next().getValue(), processedOptions, index);
            ++index;
        }
    }

    public void addAttribute(AMultiValue multiValue, Collection<SStateValue> processedOptions, int paramIndex) {
        String attrLabel = this.sink.getLabel();
        for (SStateValue stateValue : processedOptions) {
            attrLabel = String.valueOf(attrLabel) + " " + stateValue.getLabel();
        }
        attrLabel = String.valueOf(attrLabel) + " " + this.getInputLabel(paramIndex);
        this.addAtrributeCommand(multiValue, attrLabel);
    }

    private void addAtrributeCommand(AMultiValue multiValue, String attrLabel) {
        SAttribute multiAttr = MetaABMFactory.eINSTANCE.createSAttribute();
        this.append(AddCommand.create((EditingDomain)this.domain, (Object)multiValue, (Object)MetaABMActPackage.Literals.AMULTI_VALUE__VALUES, (Object)multiAttr));
        this.append(AddCommand.create((EditingDomain)this.domain, (Object)this.sink.getReference().getOwner(), (Object)MetaABMPackage.Literals.SATTRIBUTED__ATTRIBUTES, (Object)multiAttr));
        this.append(SetCommand.create((EditingDomain)this.domain, (Object)multiAttr, (Object)MetaABMPackage.Literals.ITYPED__STYPE, (Object)SAttributeType.REAL_LITERAL));
        this.append(SetCommand.create((EditingDomain)this.domain, (Object)multiAttr, (Object)MetaABMPackage.Literals.IID__LABEL, (Object)attrLabel));
    }

    protected EList<IValue> getMultiValues(AInput input) {
        return ((AMultiValue)input.getValue()).getValues();
    }

    protected void removeAttribute(IValue value) {
        if (value instanceof AMultiValue) {
            for (IValue multiValue : ((AMultiValue)value).getValues()) {
                this.removeAttribute(multiValue);
            }
        } else if (value instanceof SAttribute) {
            this.append(RemoveCommand.create((EditingDomain)this.domain, (Object)this.sink.getReference().getOwner(), (Object)MetaABMPackage.Literals.SATTRIBUTED__ATTRIBUTES, (Object)value));
        }
    }

    protected void createMultiValue(AInput input, int index) {
        AMultiValue multiValue = MetaABMActFactory.eINSTANCE.createAMultiValue();
        this.append(SetCommand.create((EditingDomain)this.domain, (Object)input, (Object)MetaABMActPackage.Literals.AINPUT__VALUE, (Object)multiValue));
        this.setValueName(multiValue, index);
        if (index > 0) {
            this.addAttribute(multiValue, Collections.<SStateValue>emptyList(), index);
        }
    }

    protected void clearMultiValues(IValue value) {
        if (value instanceof AMultiValue) {
            this.append(RemoveCommand.create((EditingDomain)this.domain, (Object)value, (Object)MetaABMActPackage.Literals.AMULTI_VALUE__VALUES, (Collection)((AMultiValue)value).getValues()));
        }
        this.removeAttribute(value);
    }

    protected void clearMultiFunction(List<AInput> inputs) {
        Iterator<AInput> inputIter = inputs.iterator();
        inputIter.next();
        while (inputIter.hasNext()) {
            this.clearMultiValues(inputIter.next().getValue());
        }
    }

    protected void createMultiFunction(List<AInput> inputs) {
        int index = 0;
        for (AInput input : inputs) {
            this.createMultiValue(input, index);
            ++index;
        }
    }

    public void removeMultiFunction(List<AInput> inputs) {
        for (AInput input : inputs) {
            this.removeAttribute(input.getValue());
            this.append(SetCommand.create((EditingDomain)this.domain, (Object)input, (Object)MetaABMActPackage.Literals.AINPUT__VALUE, null));
        }
    }

    protected void setValueName(AMultiValue value, int index) {
        String name = String.valueOf(this.sink.getLabel()) + " " + this.getInputLabel(index);
        this.append((Command)new SetLabelCommand(this.domain, (EObject)value, (EStructuralFeature)MetaABMPackage.Literals.IID__LABEL, name, 0));
    }

    private String getInputLabel(int inputIndex) {
        return ((FArgumentPrototype)this.function.getInputPrototypes().get(inputIndex)).getLabel();
    }
}

