/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.amp.escape.ascape.chart;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import org.ascape.model.Scape;
import org.ascape.util.data.DataSelection;
import org.ascape.util.data.DataSeriesStore;
import org.eclipse.amp.agf.chart.IDataProvider;
import org.eclipse.amp.agf.chart.IDataSelectionListener;
import org.eclipse.amp.escape.ascape.wrap.ScapeWrapperModel;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.graphics.Image;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AscapeDataProvider
implements IDataProvider,
ILabelProvider {
    Map<Scape, DataSelection> dataSelectionForScape = new HashMap<Scape, DataSelection>();
    Map<IDataSelectionListener, Observer> observerForListener = new HashMap<IDataSelectionListener, Observer>();

    public Object getDataSource(Object model) {
        Scape scape = ((ScapeWrapperModel)model).getScape();
        DataSelection dataSelection = this.dataSelectionForScape.get(scape);
        if (dataSelection == null) {
            dataSelection = new DataSelection();
            dataSelection.setData(scape.getData());
            this.dataSelectionForScape.put(scape, dataSelection);
        }
        return dataSelection;
    }

    public List<String> getCategoryLabels(Object dataSource) {
        return ((DataSelection)dataSource).getData().getPeriods();
    }

    public Object getValues(Object valueSource) {
        return ((DataSeriesStore)valueSource).toList();
    }

    public List getValueSets(Object valueSelection) {
        return ((DataSelection)valueSelection).getSelectedSeries();
    }

    public void addListener(final Object dataSource, final IDataSelectionListener listener) {
        DataSelection selection = (DataSelection)dataSource;
        Observer observer = new Observer(){

            public void update(Observable arg0, Object arg1) {
                listener.selectionChanged(dataSource);
            }
        };
        this.observerForListener.put(listener, observer);
        selection.addObserver(observer);
    }

    public void removeListener(Object dataSource, IDataSelectionListener listener) {
        DataSelection selection = (DataSelection)dataSource;
        Observer observer = this.observerForListener.get(listener);
        selection.deleteObserver(observer);
    }

    public Image getImage(Object element) {
        return null;
    }

    public String getText(Object valueSource) {
        return ((DataSeriesStore)valueSource).getName();
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }
}

