/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw3d;

import java.util.List;
import org.eclipse.draw2d.AbstractLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw3d.IFigure3D;
import org.eclipse.draw3d.geometry.IVector3f;
import org.eclipse.draw3d.geometry.Vector3f;
import org.eclipse.draw3d.util.Draw3DCache;

public class StackLayout3D
extends AbstractLayout {
    protected float m_distance;

    public StackLayout3D() {
        this(1000.0f);
    }

    public StackLayout3D(float i_distance) {
        this.m_distance = i_distance;
    }

    public float getDistance() {
        return this.m_distance;
    }

    public void setDistance(float i_distance) {
        this.m_distance = i_distance;
    }

    protected Dimension calculatePreferredSize(IFigure i_container, int i_wHint, int i_hHint) {
        return i_container.getPreferredSize(i_wHint, i_hHint);
    }

    public void layout(IFigure i_container) {
        Vector3f location = Draw3DCache.getVector3f();
        try {
            location.set(0.0f, 0.0f, 0.0f);
            List children = i_container.getChildren();
            for (Object child : children) {
                if (!(child instanceof IFigure3D) || !this.layoutChild(child)) continue;
                IFigure3D child3D = (IFigure3D)child;
                child3D.getPosition3D().setLocation3D((IVector3f)location);
                location.translate(0.0f, 0.0f, this.m_distance);
            }
        }
        catch (Throwable throwable) {
            Draw3DCache.returnVector3f((Vector3f[])new Vector3f[]{location});
            throw throwable;
        }
        Draw3DCache.returnVector3f((Vector3f[])new Vector3f[]{location});
    }

    protected boolean layoutChild(Object i_child) {
        if (i_child instanceof IFigure3D) {
            return ((IFigure3D)i_child).getSurface() != null;
        }
        return false;
    }
}

