/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.amp.escape.ide;

import java.net.MalformedURLException;
import java.net.URL;
import org.ascape.model.Scape;
import org.eclipse.amp.axf.core.IModel;
import org.eclipse.amp.axf.ide.view.ActiveModelViewPart;
import org.eclipse.amp.escape.ascape.wrap.ScapeWrapperModel;
import org.eclipse.amp.escape.ide.EclipseEscapeRunner;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.widgets.Composite;

public class InfoView
extends ActiveModelViewPart {
    private Browser browser;

    public void createPartControl(Composite parent) {
        this.browser = new Browser(parent, 0);
        super.createPartControl(parent);
    }

    protected void modelChanged(IModel model) {
        if (model instanceof ScapeWrapperModel) {
            Scape scape = ((ScapeWrapperModel)model).getScape();
            EclipseEscapeRunner runner = (EclipseEscapeRunner)scape.getRunner();
            Path path = new Path("res/" + scape.getClass().getName().replace('.', '/'));
            path = path.removeLastSegments(1).append("About" + path.lastSegment()).addFileExtension("html");
            final IFile file = runner.getExecutingProject().getFile((IPath)path);
            this.browser.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    if (file.exists()) {
                        try {
                            URL url = file.getLocationURI().toURL();
                            InfoView.this.browser.setUrl(url.getFile());
                            InfoView.this.browser.setBackground(InfoView.this.browser.getDisplay().getSystemColor(1));
                        }
                        catch (MalformedURLException e) {
                            InfoView.this.browser.setText("<b>[Bad URL:" + e + "]");
                            InfoView.this.browser.setBackground(InfoView.this.browser.getDisplay().getSystemColor(15));
                        }
                    } else {
                        InfoView.this.browser.setBackground(InfoView.this.browser.getDisplay().getSystemColor(15));
                        InfoView.this.browser.setText("<b>[Empty]");
                    }
                }
            });
        }
    }

    public void dispose() {
        this.browser.dispose();
        super.dispose();
    }
}

