/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.amp.amf.testing.ares;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Issue implements Enumerator
{
    BELOW_RANGE(10, "BelowRange", "BELOW_RANGE"),
    ABOVE_RANGE(15, "AboveRange", "ABOVE_RANGE"),
    NONE(1, "None", "NONE"),
    NOT_FOUND(-1, "NotFound", "NOT_FOUND");

    public static final int BELOW_RANGE_VALUE = 10;
    public static final int ABOVE_RANGE_VALUE = 15;
    public static final int NONE_VALUE = 1;
    public static final int NOT_FOUND_VALUE = -1;
    private static final Issue[] VALUES_ARRAY;
    public static final List<Issue> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new Issue[]{BELOW_RANGE, ABOVE_RANGE, NONE, NOT_FOUND};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static Issue get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Issue result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Issue getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Issue result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Issue get(int value) {
        switch (value) {
            case 10: {
                return BELOW_RANGE;
            }
            case 15: {
                return ABOVE_RANGE;
            }
            case 1: {
                return NONE;
            }
            case -1: {
                return NOT_FOUND;
            }
        }
        return null;
    }

    private Issue(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

