/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.amp.agf3d;

import org.eclipse.amp.agf.gef.EditPartViewPart;
import org.eclipse.amp.agf3d.IModel3DFactoryProvider;
import org.eclipse.amp.agf3d.ScapeEditRoot3DPart;
import org.eclipse.amp.axf.core.ILifeCycleListener;
import org.eclipse.amp.axf.core.IModel;
import org.eclipse.amp.axf.space.ILocation2D;
import org.eclipse.amp.axf.space.ILocationProvider;
import org.eclipse.amp.axf.view.IModelPart;
import org.eclipse.amp.axf.view.SWTAsyncModelListener;
import org.eclipse.core.runtime.Platform;
import org.eclipse.draw3d.IScene;
import org.eclipse.draw3d.ISceneListener;
import org.eclipse.draw3d.LightweightSystem3D;
import org.eclipse.draw3d.RenderContext;
import org.eclipse.draw3d.camera.ICamera;
import org.eclipse.draw3d.geometry.IVector3f;
import org.eclipse.draw3d.geometry.Math3DVector3f;
import org.eclipse.draw3d.geometry.Vector3f;
import org.eclipse.draw3d.geometry.Vector3fImpl;
import org.eclipse.draw3d.ui.preferences.ScenePreferenceDistributor;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.Tool;
import org.eclipse.gef3d.editparts.ScalableFreeformRootEditPart3D;
import org.eclipse.gef3d.tools.CameraTool;
import org.eclipse.gef3d.ui.parts.GraphicalViewer3D;
import org.eclipse.gef3d.ui.parts.GraphicalViewer3DImpl;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;

public class GEF3DViewPart
extends EditPartViewPart {
    public static Vector3fImpl UP_VECTOR = new Vector3fImpl(0.0f, 0.0f, -1.0f);
    ILocationProvider locationProvider;
    boolean animateCamera = true;
    boolean cancelCamera;
    private CameraTool cameraTool;
    private RenderUpdateListener renderListener;

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        parent.addDisposeListener((DisposeListener)((GraphicalViewer3DImpl)this.viewer).getLightweightSystem3D());
        ScenePreferenceDistributor scenePreferenceDistributor = new ScenePreferenceDistributor((IScene)this.get3DViewer().getLightweightSystem3D());
        scenePreferenceDistributor.start();
        ((GraphicalViewer3D)this.getViewer()).getLightweightSystem3D().addSceneListener((ISceneListener)new SceneListener());
    }

    protected EditPartViewer createViewer() {
        return new GraphicalViewer3DImpl();
    }

    public EditPartFactory createFactory(Object contents) {
        return this.getFactory3DProvider(contents).getEditPart3DFactory(contents);
    }

    public void setInput(IEditorInput input) {
        super.setInput(input);
        this.locationProvider = (ILocationProvider)Platform.getAdapterManager().getAdapter((Object)this.getModel(), ILocationProvider.class);
    }

    public void createModelListeners() {
        if (this.viewer.getContents() instanceof IModelPart) {
            ((IModelPart)this.viewer.getContents()).createModelListeners();
        }
        this.renderListener = new RenderUpdateListener("Update Root Figure");
        this.renderListener.setWaitForUpdate(true);
        this.getModel().addModelListener((ILifeCycleListener)this.renderListener);
    }

    public IModel3DFactoryProvider getFactory3DProvider(Object contents) {
        IModel3DFactoryProvider adapter = (IModel3DFactoryProvider)Platform.getAdapterManager().getAdapter(contents, IModel3DFactoryProvider.class);
        if (adapter == null) {
            throw new RuntimeException("No I3DModelFactoryProvider adapter defined for: " + this.getModel());
        }
        return adapter;
    }

    GraphicalViewer3D get3DViewer() {
        return (GraphicalViewer3D)this.getViewer();
    }

    public RootEditPart createRoot() {
        ScalableFreeformRootEditPart3D scalableFreeformRootEditPart3D = new ScalableFreeformRootEditPart3D();
        return scalableFreeformRootEditPart3D;
    }

    protected void createZoomer(RootEditPart rootEditPart) {
        this.cameraTool = new CameraTool();
        this.getEditDomain().setActiveTool((Tool)this.cameraTool);
    }

    public void dispose() {
        this.cancelCamera = true;
        if (this.viewer.getContents() instanceof IModelPart) {
            for (ILifeCycleListener listener : ((IModelPart)this.viewer.getContents()).getModelListeners()) {
                ((IModelPart)this.viewer.getContents()).removeModelListener(listener);
            }
        }
        super.dispose();
    }

    public ICamera getCamera() {
        ICamera camera = ((GraphicalViewer3D)this.getViewer()).getLightweightSystem3D().getCamera();
        return camera;
    }

    public void moveCameraHelicopter() {
        this.moveCameraScaled(0.5f, 1.5f, -0.2f, 0.5f, 0.5f, 0.0f);
    }

    public void moveCameraFirstPerson() {
        this.moveCameraScaled(0.5f, 1.0f, -0.01f, 0.5f, 0.5f, 0.0f);
    }

    public void moveCameraOverhead() {
        this.moveCameraScaled(0.5f, 0.5f, -2.0f, 0.5f, 0.5f, 0.0f);
    }

    private void moveCameraScaled(float locX, float locY, float locZ, float targetX, float targetY, float targetZ) {
        ILocation2D extent = (ILocation2D)this.locationProvider.getExtent(this.getModel().getRoot());
        float ex = (float)(extent.getXDouble() * 20.0);
        float ey = (float)(extent.getYDouble() * 20.0);
        this.moveCamera((IVector3f)new Vector3fImpl(ex * locX, ey * locY, Math.min(ex, ey) * locZ), (IVector3f)new Vector3fImpl(ex * targetX, ey * targetY, Math.min(ex, ey) * targetZ));
    }

    private void moveCamera(final IVector3f endPoint, final IVector3f endLookPoint) {
        if (this.animateCamera) {
            new Thread(){

                public void run() {
                    GEF3DViewPart.this.cancelCamera = true;
                    GEF3DViewPart.this.moveCameraAnimate(endPoint, endLookPoint);
                }
            }.start();
        } else {
            ICamera camera = this.getCamera();
            camera.moveTo(endPoint.getX(), endPoint.getY(), endPoint.getZ());
            camera.lookAt(endLookPoint, (IVector3f)UP_VECTOR);
        }
    }

    public static void calculateDelta(IVector3f startPoint, IVector3f endPoint, Vector3f addPoint, int steps) {
        Math3DVector3f.sub((IVector3f)endPoint, (IVector3f)startPoint, (Vector3f)addPoint);
        Math3DVector3f.scale((float)(1.0f / (float)steps), (IVector3f)addPoint, (Vector3f)addPoint);
    }

    private void moveCameraAnimate(IVector3f endPoint, IVector3f endLookPoint) {
        final ICamera camera = this.getCamera();
        this.cancelCamera = false;
        int moveCount = 50;
        Vector3fImpl startPoint = new Vector3fImpl();
        camera.getPosition((Vector3f)startPoint);
        Vector3fImpl addPoint = new Vector3fImpl();
        GEF3DViewPart.calculateDelta((IVector3f)startPoint, endPoint, (Vector3f)addPoint, moveCount);
        if (!this.cancelCamera) {
            int i = 0;
            while (i < moveCount - 1) {
                Math3DVector3f.add((IVector3f)startPoint, (IVector3f)addPoint, (Vector3f)startPoint);
                this.moveToNow((Vector3f)startPoint);
                if (this.cancelCamera) {
                    return;
                }
                ++i;
            }
        }
        Vector3fImpl currentLookPoint = new Vector3fImpl();
        camera.getViewDirection((Vector3f)currentLookPoint);
        Math3DVector3f.add((IVector3f)currentLookPoint, (IVector3f)endPoint, (Vector3f)currentLookPoint);
        Vector3fImpl addLookPoint = new Vector3fImpl();
        GEF3DViewPart.calculateDelta((IVector3f)currentLookPoint, endLookPoint, (Vector3f)addLookPoint, moveCount);
        if (!this.cancelCamera) {
            int i = 0;
            while (i < moveCount - 1) {
                Math3DVector3f.add((IVector3f)currentLookPoint, (IVector3f)addLookPoint, (Vector3f)currentLookPoint);
                Display.getDefault().syncExec(new Runnable((Vector3f)currentLookPoint){
                    private final /* synthetic */ Vector3f val$currentLookPoint;
                    {
                        this.val$currentLookPoint = vector3f;
                    }

                    public void run() {
                        camera.lookAt((IVector3f)this.val$currentLookPoint, (IVector3f)UP_VECTOR);
                    }
                });
                if (this.cancelCamera) {
                    return;
                }
                ++i;
            }
        }
    }

    private void moveToNow(final Vector3f movePoint) {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                GEF3DViewPart.this.getCamera().moveTo(movePoint.getX(), movePoint.getY(), movePoint.getZ());
            }
        });
    }

    public boolean isAnimateCamera() {
        return this.animateCamera;
    }

    public void setAnimateCamera(boolean animateCamera) {
        this.animateCamera = animateCamera;
    }

    public int getAnimationStep() {
        return ((ScapeEditRoot3DPart)this.getEditPart()).getAnimationStep();
    }

    public int getAnimationStepCount() {
        return ((ScapeEditRoot3DPart)this.getEditPart()).getAnimationStepCount();
    }

    public void setAnimationStepCount(int animationStepCount) {
        ((ScapeEditRoot3DPart)this.getEditPart()).setAnimationStepCount(animationStepCount);
    }

    public CameraTool getCameraTool() {
        return this.cameraTool;
    }

    private final class RenderUpdateListener
    extends SWTAsyncModelListener {
        private boolean firstTime;

        private RenderUpdateListener(String name) {
            super(GEF3DViewPart.this.getViewer().getControl(), name);
            this.firstTime = true;
        }

        public synchronized void update(IModel model) {
            this.beginPainting();
            LightweightSystem3D lws = ((GraphicalViewer3D)GEF3DViewPart.this.getViewer()).getLightweightSystem3D();
            while (lws.getUpdateManager3D().getCanvas() == null) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {}
            }
            if (this.firstTime) {
                GEF3DViewPart.this.animateCamera = false;
                GEF3DViewPart.this.moveCameraHelicopter();
                GEF3DViewPart.this.animateCamera = true;
                this.firstTime = false;
            }
            ScapeEditRoot3DPart editPart = (ScapeEditRoot3DPart)GEF3DViewPart.this.getEditPart();
            editPart.setAnimationStep(0);
            while (editPart.getAnimationStep() < editPart.getAnimationStepCount()) {
                GEF3DViewPart.this.getEditPart().refresh();
                ((GraphicalViewer3D)GEF3DViewPart.this.getViewer()).getLightweightSystem3D().render(true);
                editPart.setAnimationStep(editPart.getAnimationStep() + 1);
            }
        }
    }

    private final class SceneListener
    implements ISceneListener {
        private SceneListener() {
        }

        public void renderPassStarted(RenderContext renderContext) {
        }

        public void renderPassFinished(RenderContext renderContext) {
            ScapeEditRoot3DPart editPart = (ScapeEditRoot3DPart)GEF3DViewPart.this.getEditPart();
            if (GEF3DViewPart.this.renderListener != null && (editPart == null || GEF3DViewPart.this.getAnimationStep() == GEF3DViewPart.this.getAnimationStepCount())) {
                GEF3DViewPart.this.renderListener.endPainting();
            }
        }

        public void cameraChanged(ICamera iOldCamera, ICamera iNewCamera) {
        }
    }
}

