/*
 * Decompiled with CFR 0.152.
 */
package org.metaabm.xsd;

import java.io.File;
import java.io.IOException;
import java.util.StringTokenizer;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.metaabm.SContext;
import org.metaabm.util.MetaABMResourceFactoryImpl;

public class MetaABMPersist {
    public static final String CONTEXT_FILE_NAME = "model.metaabm";
    private Resource resource;
    SContext context;
    private URI fileURI;

    protected MetaABMPersist(SContext context, URI fileURI) {
        this.context = context;
        this.fileURI = fileURI;
    }

    public static MetaABMPersist create(SContext persist, String path) throws IOException {
        MetaABMPersist cp = new MetaABMPersist(persist, null);
        cp.setFilePath(path);
        return cp;
    }

    public static MetaABMPersist create(SContext persist, File file) throws IOException {
        MetaABMPersist cp = new MetaABMPersist(persist, null);
        cp.setFile(file);
        return cp;
    }

    public static MetaABMPersist create(String path) throws IOException {
        MetaABMPersist cp = new MetaABMPersist(null, null);
        cp.setFilePath(path);
        return cp;
    }

    public static MetaABMPersist createURI(URI path) throws IOException {
        MetaABMPersist cp = new MetaABMPersist(null, null);
        cp.setFileURI(path);
        return cp;
    }

    public static MetaABMPersist create(File file) throws IOException {
        MetaABMPersist cp = new MetaABMPersist(null, null);
        cp.setFile(file);
        return cp;
    }

    public SContext load() throws IOException {
        if (this.resource == null) {
            MetaABMResourceFactoryImpl resourceFactory = new MetaABMResourceFactoryImpl();
            Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("metaabm", resourceFactory);
            ResourceSetImpl resourceSet = new ResourceSetImpl();
            resourceSet.getLoadOptions().put("DEFER_ATTACHMENT", Boolean.TRUE);
            resourceSet.getLoadOptions().put("DEFER_IDREF_RESOLUTION", Boolean.TRUE);
            resourceSet.getLoadOptions().put("USE_DEPRECATED_METHODS", Boolean.TRUE);
            this.resource = resourceSet.getResource(this.fileURI, true);
        }
        this.context = (SContext)this.resource.getEObject("/");
        return this.context;
    }

    public void save() throws IOException {
        if (this.resource == null) {
            this.resource = new XMIResourceFactoryImpl().createResource(this.fileURI);
        }
        if (!this.resource.getContents().contains((Object)this.context)) {
            this.resource.getContents().clear();
            this.resource.getContents().add((Object)this.context);
        }
        this.resource.save(null);
    }

    public static String platformPath(String inputPath) {
        inputPath = inputPath.replace('/', File.separatorChar).replace('\\', File.separatorChar);
        StringBuffer resultPath = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(inputPath, ";");
        while (stringTokenizer.hasMoreTokens()) {
            String pathDir = stringTokenizer.nextToken();
            File f = new File(pathDir);
            try {
                resultPath.append(f.getCanonicalPath());
            }
            catch (IOException iOException) {
                System.out.println("WARNING: Could not get system file context.");
                resultPath.append(pathDir);
            }
            if (!stringTokenizer.hasMoreTokens()) continue;
            resultPath.append(File.pathSeparator);
        }
        return resultPath.toString();
    }

    public Resource getResource() {
        return this.resource;
    }

    public void setResource(Resource resource) {
        this.resource = resource;
    }

    public SContext getContext() {
        return this.context;
    }

    public void setContext(SContext context) {
        this.context = context;
    }

    public void reset() {
        this.context = null;
        this.fileURI = null;
        this.resource = null;
    }

    public URI getFileURI() {
        return this.fileURI;
    }

    public void setFileURI(URI fileURI) {
        this.fileURI = fileURI;
        this.resource = null;
    }

    public void setFilePath(String path) throws IOException {
        this.setFile(new File(MetaABMPersist.platformPath(path)));
    }

    public void setFile(File file) throws IOException {
        this.setFileURI(URI.createFileURI((String)file.getCanonicalPath()));
    }
}

