/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef3d;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.TreeSearch;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.editparts.LayerManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SurfaceSearch
implements TreeSearch {
    private Set<IFigure> m_ignoredLayers;
    private EditPartViewer m_viewer;

    private Set<IFigure> getIgnoredLayers() {
        if (this.m_ignoredLayers == null) {
            this.m_ignoredLayers = new HashSet<IFigure>();
            LayerManager layerManager = (LayerManager)this.m_viewer.getEditPartRegistry().get(LayerManager.ID);
            this.addLayer(layerManager.getLayer((Object)"Connection Layer"));
            this.addLayer(layerManager.getLayer((Object)"Feedback Layer"));
            this.addLayer(layerManager.getLayer((Object)"Grid Layer"));
            this.addLayer(layerManager.getLayer((Object)"Guide Layer"));
            this.addLayer(layerManager.getLayer((Object)"Handle Layer"));
            this.addLayer(layerManager.getLayer((Object)"Scaled Feedback Layer"));
        }
        return this.m_ignoredLayers;
    }

    private void addLayer(IFigure i_layer) {
        if (i_layer == null) {
            return;
        }
        this.m_ignoredLayers.add(i_layer);
    }

    public SurfaceSearch(EditPartViewer i_viewer) {
        if (i_viewer == null) {
            throw new NullPointerException("i_viewer must not be null");
        }
        this.m_viewer = i_viewer;
    }

    public boolean accept(IFigure i_figure) {
        return true;
    }

    public boolean prune(IFigure i_figure) {
        return this.getIgnoredLayers().contains(i_figure);
    }
}

