/*
 * Decompiled with CFR 0.152.
 */
package org.ascape.view.nonvis;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import org.ascape.model.event.ScapeEvent;
import org.ascape.model.space.SpatialTemporalException;
import org.ascape.util.PropertyAccessor;
import org.ascape.view.nonvis.NonGraphicView;

public class ParameterControlView
extends NonGraphicView {
    private static final long serialVersionUID = 1L;
    private FileReader input;
    private BufferedReader bufInput;
    private Vector params;
    private String firstLine;
    private String nextLine;
    private String filename;

    public void setFile(String filename) throws IOException {
        this.filename = filename;
        this.params = new Vector();
        try {
            this.input = new FileReader(filename);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e.toString());
        }
        this.bufInput = new BufferedReader(this.input);
        this.firstLine = this.bufInput.readLine();
        this.nextLine = null;
    }

    public void initParams() {
        List accessors = this.getScape().retrieveAllAccessors();
        StringTokenizer st = new StringTokenizer(this.firstLine);
        while (st.hasMoreTokens()) {
            boolean paramFound = false;
            String parameterName = st.nextToken();
            for (PropertyAccessor accessor : accessors) {
                if (!accessor.getName().equalsIgnoreCase(parameterName)) continue;
                this.params.add(accessor);
                paramFound = true;
            }
            if (paramFound) continue;
            if (parameterName.equalsIgnoreCase("RandomSeed")) {
                this.params.add("RandomSeed");
                continue;
            }
            if (parameterName.equalsIgnoreCase("StartPeriod")) {
                this.params.add("StartPeriod");
                continue;
            }
            if (parameterName.equalsIgnoreCase("StopPeriod")) {
                this.params.add("StopPeriod");
                continue;
            }
            throw new RuntimeException("***Warning*** Paramater not found: " + parameterName);
        }
        try {
            this.nextLine = this.bufInput.readLine();
        }
        catch (IOException iOException) {
            throw new RuntimeException("No data in file " + this.filename);
        }
        if (this.nextLine == null) {
            throw new RuntimeException("No data in file " + this.filename);
        }
    }

    public void scapeDeserialized(ScapeEvent scapeEvent) {
        super.scapeDeserialized(scapeEvent);
        this.readParams();
    }

    public void scapeSetup(ScapeEvent scapeEvent) {
        this.readParams();
    }

    private void readParams() {
        if (this.nextLine == null) {
            this.initParams();
        }
        StringTokenizer st = new StringTokenizer(this.nextLine);
        int i = 0;
        while (i < this.params.size()) {
            String token = st.nextToken();
            Object nextParam = this.params.elementAt(i);
            if (nextParam instanceof PropertyAccessor) {
                try {
                    ((PropertyAccessor)nextParam).setAsText(token);
                }
                catch (InvocationTargetException e) {
                    throw new Error("Exception in invoked method: " + e.getTargetException());
                }
            }
            if (nextParam instanceof String) {
                if (nextParam.equals("RandomSeed")) {
                    this.getScape().setRandomSeed(Long.valueOf(token));
                } else if (nextParam.equals("StartPeriod")) {
                    try {
                        this.getScape().setStartPeriod(Integer.valueOf(token));
                    }
                    catch (SpatialTemporalException spatialTemporalException) {
                        this.getScape().getEnvironment().getConsole().println("Bad Start Period Specified: " + Integer.valueOf(token));
                    }
                } else if (nextParam.equals("StopPeriod")) {
                    try {
                        this.getScape().setStopPeriod(Integer.valueOf(token));
                    }
                    catch (SpatialTemporalException spatialTemporalException) {
                        this.getScape().getEnvironment().getConsole().println("Bad Start Period Specified: " + Integer.valueOf(token));
                    }
                }
            }
            ++i;
        }
    }

    public void scapeStopped(ScapeEvent scapeEvent) {
        try {
            this.nextLine = this.bufInput.readLine();
            if (this.nextLine != null) {
                this.getScape().getRunner().requestRestart();
                return;
            }
        }
        catch (IOException iOException) {}
        this.getScape().getRunner().quit();
    }
}

