/*
 * Decompiled with CFR 0.152.
 */
package org.ascape.util;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

public class PropertyAccessor
implements Comparable,
Serializable {
    private static final long serialVersionUID = 1L;
    protected Object object;
    protected PropertyDescriptor descriptor;
    protected Class propertyClass;

    public PropertyAccessor(Object object, PropertyDescriptor descriptor) {
        this.object = object;
        this.descriptor = descriptor;
        this.propertyClass = descriptor.getPropertyType();
    }

    public PropertyAccessor(Object object, String accessorName) {
        this.object = object;
        try {
            this.descriptor = new PropertyDescriptor(accessorName, object.getClass());
        }
        catch (IntrospectionException introspectionException) {
            throw new RuntimeException("IntrospectionException; Likely cause: Property accessor name doesn't match any properties: " + object.getClass() + "." + accessorName);
        }
        this.propertyClass = this.descriptor.getPropertyType();
    }

    public PropertyDescriptor getDescriptor() {
        return this.descriptor;
    }

    public void setDescriptor(PropertyDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    public String getName() {
        return this.descriptor.getName();
    }

    public String getLongName() {
        return PropertyAccessor.getLongName(this.descriptor);
    }

    public static final String getLongName(PropertyDescriptor descriptor) {
        return PropertyAccessor.removeUnderscores(PropertyAccessor.addSpacesToVariableName(PropertyAccessor.capitalizeFirstCharacter(descriptor.getName())));
    }

    public String getAsText() {
        return PropertyAccessor.getAsText(this.object, this.descriptor);
    }

    public static final String getAsText(Object object, PropertyDescriptor descriptor) {
        try {
            return PropertyAccessor.getValue(object, descriptor).toString();
        }
        catch (NullPointerException nullPointerException) {
            return "(null)";
        }
    }

    public static Object stringAsClass(Class wrapper, String string) throws NumberFormatException, IllegalArgumentException {
        block22: {
            try {
                T[] enumValues = wrapper.getEnumConstants();
                if (enumValues != null) {
                    T[] TArray = enumValues;
                    int n = enumValues.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object object = TArray[n2];
                        Enum en = (Enum)object;
                        if (en.toString().equals(string)) {
                            return en;
                        }
                        ++n2;
                    }
                    throw new IllegalArgumentException("No enumerator matching: " + string + " in " + wrapper.getName());
                }
                if (wrapper == Integer.TYPE) {
                    return new Integer(string);
                }
                if (wrapper == Double.TYPE) {
                    return new Double(string);
                }
                if (wrapper == Float.TYPE) {
                    return new Float(string);
                }
                if (wrapper == Long.TYPE) {
                    return new Long(string);
                }
                if (wrapper == Short.TYPE) {
                    return new Short(string);
                }
                if (wrapper == Byte.TYPE) {
                    return new Byte(string);
                }
                if (wrapper == BigDecimal.class) {
                    return new BigDecimal(string);
                }
                if (wrapper == BigInteger.class) {
                    return new BigInteger(string);
                }
                if (wrapper != Boolean.TYPE) break block22;
                if (string.length() > 0) {
                    String firstLetter = string.substring(0, 1);
                    if (string.equals("0")) {
                        return new Boolean(false);
                    }
                    if (string.equals("1")) {
                        return new Boolean(true);
                    }
                    if (firstLetter.equalsIgnoreCase("n")) {
                        return new Boolean(false);
                    }
                    if (firstLetter.equalsIgnoreCase("y")) {
                        return new Boolean(true);
                    }
                    if (firstLetter.equalsIgnoreCase("f")) {
                        return new Boolean(false);
                    }
                    if (firstLetter.equalsIgnoreCase("t")) {
                        return new Boolean(true);
                    }
                    return new Boolean(string);
                }
                return null;
            }
            catch (NullPointerException nullPointerException) {
                return null;
            }
        }
        if (wrapper == String.class) {
            return string;
        }
        throw new IllegalArgumentException("A conversion method hasn't been defined for " + wrapper.toString());
    }

    public void setAsText(String string) throws InvocationTargetException, IllegalArgumentException {
        PropertyAccessor.setAsText(this.object, string, this.descriptor);
    }

    public static void setAsText(Object object, String string, PropertyDescriptor descriptor) throws InvocationTargetException, IllegalArgumentException {
        Object[] args = new Object[1];
        try {
            args[0] = PropertyAccessor.stringAsClass(descriptor.getPropertyType(), string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException(String.valueOf(string) + " can not be converted to (" + descriptor.getPropertyType() + ") " + descriptor.getPropertyType().getName());
        }
        try {
            descriptor.getWriteMethod().invoke(object, args);
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Set as text won't work for property " + descriptor.getName() + ", access too restricted: " + e);
        }
    }

    public boolean isWriteable() {
        return PropertyAccessor.isWriteable(this.descriptor);
    }

    public static boolean isWriteable(PropertyDescriptor descriptor) {
        boolean writeable = descriptor.getWriteMethod() != null;
        try {
            PropertyAccessor.stringAsClass(descriptor.getPropertyType(), "");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            writeable = false;
        }
        return writeable;
    }

    public Object getValue() {
        return PropertyAccessor.getValue(this.object, this.descriptor);
    }

    public static final Object getValue(Object object, PropertyDescriptor descriptor) {
        try {
            return descriptor.getReadMethod().invoke(object, null);
        }
        catch (IllegalAccessException e) {
            System.out.println("Error in dynamic method read: " + e);
        }
        catch (IllegalArgumentException e) {
            System.out.println("Error in dynamic method read: " + e);
        }
        catch (InvocationTargetException e) {
            System.out.println("Error in dynamic method read: " + e);
        }
        catch (NullPointerException nullPointerException) {
            System.out.println("No read method for property: " + descriptor.getName());
        }
        return null;
    }

    public void setValue(Object value) {
        try {
            Object[] args = new Object[]{value};
            this.descriptor.getWriteMethod().invoke(this.object, args);
        }
        catch (IllegalAccessException e) {
            System.out.println("Error in dynamic method read: " + e);
        }
        catch (InvocationTargetException e) {
            System.out.println("Error in dynamic method read: " + e);
        }
    }

    public static List determineReadWriteAccessors(Object object, Class stopClass, boolean includeGetters) throws IntrospectionException {
        ArrayList<PropertyAccessor> tempPropertyAccessors = new ArrayList<PropertyAccessor>();
        PropertyDescriptor[] infoProperties = stopClass == null || object.getClass() == stopClass ? Introspector.getBeanInfo(object.getClass()).getPropertyDescriptors() : Introspector.getBeanInfo(object.getClass(), stopClass).getPropertyDescriptors();
        int i = 0;
        while (i < infoProperties.length) {
            Class<?> pt;
            if (!(!includeGetters && infoProperties[i].getWriteMethod() == null || infoProperties[i].getReadMethod() == null || (pt = infoProperties[i].getReadMethod().getReturnType()) != Integer.TYPE && pt != Double.TYPE && pt != String.class && pt != Float.TYPE && pt != Boolean.TYPE)) {
                tempPropertyAccessors.add(new PropertyAccessor(object, infoProperties[i]));
            }
            ++i;
        }
        return tempPropertyAccessors;
    }

    public static final String capitalizeFirstCharacter(String string) {
        if (string.length() > 1) {
            return String.valueOf(string.substring(0, 1).toUpperCase()) + string.substring(1, string.length());
        }
        return string.toUpperCase();
    }

    public static final String addSpacesToVariableName(String string) {
        if (string.length() > 0) {
            String newString = "" + string.charAt(0);
            int i = 1;
            while (i < string.length()) {
                newString = !Character.isUpperCase(string.charAt(i)) || Character.isUpperCase(string.charAt(i - 1)) ? String.valueOf(newString) + string.charAt(i) : String.valueOf(newString) + " " + string.charAt(i);
                ++i;
            }
            return newString;
        }
        return "";
    }

    public static final String removeUnderscores(String string) {
        int i = 0;
        while (i < string.length()) {
            if (string.charAt(i) == '_') {
                string = i < string.length() - 1 ? String.valueOf(string.substring(0, i)) + string.substring(i + 1, string.length()) : string.substring(0, i);
            }
            ++i;
        }
        return string;
    }

    public int compareTo(Object o) {
        return this.getName().compareTo(((PropertyAccessor)o).getName());
    }

    public static String paramName(String arg) {
        int equalAt = arg.lastIndexOf("=");
        if (equalAt > 0) {
            return arg.substring(0, equalAt);
        }
        return null;
    }

    public static String paramValue(String arg) {
        return arg.substring(arg.lastIndexOf("=") + 1);
    }

    public static Integer paramValueInt(String arg) {
        return (Integer)PropertyAccessor.stringAsClass(Integer.TYPE, PropertyAccessor.paramValue(arg));
    }

    public static Long paramValueLong(String arg) {
        return Long.parseLong(PropertyAccessor.paramValue(arg));
    }

    public static Boolean paramValueBoolean(String arg) {
        return (Boolean)PropertyAccessor.stringAsClass(Boolean.TYPE, PropertyAccessor.paramValue(arg));
    }
}

