/*
 * Decompiled with CFR 0.152.
 */
package org.ascape.model.event;

import java.util.TooManyListenersException;
import org.ascape.model.event.ControlEvent;
import org.ascape.model.event.DefaultScapeListener;
import org.ascape.model.event.ScapeEvent;
import org.ascape.model.event.ScapeListener;

public class ScapeListenerDelegate
extends DefaultScapeListener {
    private static final long serialVersionUID = 1L;
    private ScapeListener scapeListener;

    public ScapeListenerDelegate() {
    }

    public ScapeListenerDelegate(ScapeListener scapeListener) {
        this.scapeListener = scapeListener;
    }

    public void scapeRemoved(ScapeEvent scapeEvent) {
        if (this.scape == null) {
            throw new RuntimeException("Tried to remove a scape from a delegate with no scape.");
        }
        if (scapeEvent == null) {
            throw new RuntimeException("Tried to remove a null scape.");
        }
        this.listeningToScape = false;
    }

    public void scapeNotification(ScapeEvent scapeEvent) {
        super.scapeNotification(scapeEvent);
        if (scapeEvent.getID() == 3) {
            this.scapeListener.scapeIterated(scapeEvent);
        } else if (scapeEvent.getID() == -1) {
            this.scapeListener.scapeSetup(scapeEvent);
        } else if (scapeEvent.getID() == -4) {
            this.scapeListener.scapeInitialized(scapeEvent);
        } else if (scapeEvent.getID() == -5) {
            try {
                this.scapeListener.scapeAdded(scapeEvent);
            }
            catch (TooManyListenersException e) {
                throw new RuntimeException(e);
            }
        } else if (scapeEvent.getID() == 1) {
            this.scapeListener.scapeStarted(scapeEvent);
        } else if (scapeEvent.getID() == 2) {
            this.scapeListener.scapeStopped(scapeEvent);
        } else if (scapeEvent.getID() == 5) {
            this.scapeListener.scapeDeserialized(scapeEvent);
        } else if (scapeEvent.getID() == -2) {
            this.scapeListener.scapeClosing(scapeEvent);
        }
    }

    public void notifyScapeUpdated() {
        this.scape.respondControl(new ControlEvent(this.scapeListener, 1));
    }

    public ScapeListener getScapeListener() {
        return this.scapeListener;
    }

    public void setScapeListener(ScapeListener scapeListener) {
        this.scapeListener = scapeListener;
    }

    public String toString() {
        return "Delegate Listener for " + this.scapeListener;
    }
}

