/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw3d.graphics3d.lwjgl.graphics;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import org.eclipse.draw3d.graphics3d.Graphics3D;
import org.eclipse.draw3d.graphics3d.ILodHelper;
import org.eclipse.draw3d.graphics3d.RenderImage;
import org.eclipse.draw3d.util.Draw3DCache;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL15;

public abstract class LwjglVBO
implements RenderImage {
    private int m_bufferCount;
    private int m_colorBufferId;
    private BufferInfo m_colorBufferInfo;
    private State m_state = State.INITIAL;
    private int m_texCoordBufferId;
    private BufferInfo m_texCoordBufferInfo;
    private int m_vertexBufferId;
    private BufferInfo m_vertexBufferInfo;

    protected abstract void cleanup(Graphics3D var1, ILodHelper var2);

    public void dispose() {
        if (this.getState() == State.DISPOSED) {
            throw new IllegalStateException(this + " is already disposed");
        }
        if (this.m_state == State.READY) {
            IntBuffer idBuffer = Draw3DCache.getIntBuffer((int)this.m_bufferCount);
            try {
                idBuffer.rewind();
                idBuffer.put(this.m_vertexBufferId);
                if (this.hasBuffer(BufferType.COLOR)) {
                    idBuffer.put(this.m_colorBufferId);
                }
                if (this.hasBuffer(BufferType.TEXTURE_COORDINATES)) {
                    idBuffer.put(this.m_texCoordBufferId);
                }
                idBuffer.rewind();
                GL15.glDeleteBuffers((IntBuffer)idBuffer);
                this.m_vertexBufferId = 0;
                this.m_colorBufferId = 0;
                this.m_texCoordBufferId = 0;
                this.setState(State.DISPOSED);
            }
            catch (Throwable throwable) {
                Draw3DCache.returnIntBuffer((IntBuffer[])new IntBuffer[]{idBuffer});
                throw throwable;
            }
            Draw3DCache.returnIntBuffer((IntBuffer[])new IntBuffer[]{idBuffer});
        }
    }

    protected abstract void doRender(Graphics3D var1, ILodHelper var2);

    protected abstract Buffer getBuffer(BufferType var1);

    protected abstract BufferInfo getBufferInfo(BufferType var1);

    protected State getState() {
        return this.m_state;
    }

    protected void stateChanged(State i_oldState, State i_newState) {
    }

    private void setState(State i_newState) {
        State oldState = this.m_state;
        this.m_state = i_newState;
        this.stateChanged(oldState, i_newState);
    }

    protected abstract boolean hasBuffer(BufferType var1);

    public void initialize(Graphics3D i_g3d) {
        if (this.getState() != State.INITIAL) {
            throw new IllegalStateException(this + " was already initialized");
        }
        Buffer vertexBuffer = this.getBuffer(BufferType.VERTEX);
        this.m_vertexBufferInfo = this.getBufferInfo(BufferType.VERTEX);
        this.m_bufferCount = 1;
        if (this.hasBuffer(BufferType.COLOR)) {
            ++this.m_bufferCount;
        }
        if (this.hasBuffer(BufferType.TEXTURE_COORDINATES)) {
            ++this.m_bufferCount;
        }
        IntBuffer idBuffer = Draw3DCache.getIntBuffer((int)this.m_bufferCount);
        try {
            idBuffer.rewind();
            GL15.glGenBuffers((IntBuffer)idBuffer);
            idBuffer.rewind();
            this.m_vertexBufferId = idBuffer.get();
            this.uploadBuffer(this.m_vertexBufferId, this.m_vertexBufferInfo, vertexBuffer);
            vertexBuffer = null;
            if (this.hasBuffer(BufferType.COLOR)) {
                this.m_colorBufferId = idBuffer.get();
                Buffer colorBuffer = this.getBuffer(BufferType.COLOR);
                this.m_colorBufferInfo = this.getBufferInfo(BufferType.COLOR);
                this.uploadBuffer(this.m_colorBufferId, this.m_colorBufferInfo, colorBuffer);
                colorBuffer = null;
            }
            if (this.hasBuffer(BufferType.TEXTURE_COORDINATES)) {
                this.m_texCoordBufferId = idBuffer.get();
                Buffer texCoordBuffer = this.getBuffer(BufferType.TEXTURE_COORDINATES);
                this.m_texCoordBufferInfo = this.getBufferInfo(BufferType.TEXTURE_COORDINATES);
                this.uploadBuffer(this.m_texCoordBufferId, this.m_texCoordBufferInfo, texCoordBuffer);
                texCoordBuffer = null;
            }
            this.setState(State.READY);
        }
        catch (Throwable throwable) {
            Draw3DCache.returnIntBuffer((IntBuffer[])new IntBuffer[]{idBuffer});
            throw throwable;
        }
        Draw3DCache.returnIntBuffer((IntBuffer[])new IntBuffer[]{idBuffer});
    }

    protected abstract void prepare(Graphics3D var1, ILodHelper var2);

    public void render(Graphics3D i_g3d, ILodHelper i_lodContext) {
        if (this.getState() != State.READY) {
            throw new IllegalStateException(this + " is not ready");
        }
        if (this.hasBuffer(BufferType.COLOR)) {
            GL15.glBindBuffer((int)34962, (int)this.m_colorBufferId);
            GL11.glEnableClientState((int)32886);
            GL11.glColorPointer((int)this.m_colorBufferInfo.getSize(), (int)this.m_colorBufferInfo.getDataType(), (int)this.m_colorBufferInfo.getStride(), (long)this.m_colorBufferInfo.getOffset());
        }
        if (this.hasBuffer(BufferType.TEXTURE_COORDINATES)) {
            GL15.glBindBuffer((int)34962, (int)this.m_texCoordBufferId);
            GL11.glEnableClientState((int)32888);
            GL11.glTexCoordPointer((int)this.m_texCoordBufferInfo.getSize(), (int)this.m_texCoordBufferInfo.getDataType(), (int)this.m_texCoordBufferInfo.getStride(), (long)this.m_texCoordBufferInfo.getOffset());
        }
        GL15.glBindBuffer((int)34962, (int)this.m_vertexBufferId);
        GL11.glEnableClientState((int)32884);
        GL11.glVertexPointer((int)this.m_vertexBufferInfo.getSize(), (int)this.m_vertexBufferInfo.getDataType(), (int)this.m_vertexBufferInfo.getStride(), (long)this.m_vertexBufferInfo.getOffset());
        try {
            this.prepare(i_g3d, i_lodContext);
            try {
                this.doRender(i_g3d, i_lodContext);
            }
            finally {
                this.cleanup(i_g3d, i_lodContext);
            }
        }
        finally {
            GL11.glDisableClientState((int)32884);
            if (this.hasBuffer(BufferType.TEXTURE_COORDINATES)) {
                GL11.glDisableClientState((int)32888);
            }
            if (this.hasBuffer(BufferType.COLOR)) {
                GL11.glDisableClientState((int)32886);
            }
        }
    }

    private void uploadBuffer(int i_id, BufferInfo i_info, Buffer i_buffer) {
        i_buffer.rewind();
        GL15.glBindBuffer((int)34962, (int)i_id);
        switch (i_info.getDataType()) {
            case 5120: 
            case 5121: {
                GL15.glBufferData((int)34962, (ByteBuffer)((ByteBuffer)i_buffer), (int)i_info.getUsage());
                break;
            }
            case 5122: 
            case 5123: {
                GL15.glBufferData((int)34962, (ShortBuffer)((ShortBuffer)i_buffer), (int)i_info.getUsage());
                break;
            }
            case 5124: 
            case 5125: {
                GL15.glBufferData((int)34962, (IntBuffer)((IntBuffer)i_buffer), (int)i_info.getUsage());
                break;
            }
            case 5126: {
                GL15.glBufferData((int)34962, (FloatBuffer)((FloatBuffer)i_buffer), (int)i_info.getUsage());
                break;
            }
            case 5130: {
                GL15.glBufferData((int)34962, (DoubleBuffer)((DoubleBuffer)i_buffer), (int)i_info.getUsage());
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown buffer data type: " + i_info.getDataType());
            }
        }
    }

    protected static class BufferInfo {
        private int m_dataType;
        private int m_offset;
        private int m_size;
        private int m_stride;
        private int m_usage;

        public BufferInfo(int i_dataType, int i_usage, int i_size, int i_stride, int i_offset) {
            this.m_dataType = i_dataType;
            this.m_usage = i_usage;
            this.m_size = i_size;
            this.m_stride = i_stride;
            this.m_offset = i_offset;
        }

        public int getDataType() {
            return this.m_dataType;
        }

        public int getOffset() {
            return this.m_offset;
        }

        public int getSize() {
            return this.m_size;
        }

        public int getStride() {
            return this.m_stride;
        }

        public int getUsage() {
            return this.m_usage;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum BufferType {
        COLOR,
        TEXTURE_COORDINATES,
        VERTEX;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum State {
        DISPOSED,
        INITIAL,
        READY;

    }
}

