/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw3d.graphics3d.lwjgl.graphics;

import org.eclipse.draw3d.graphics.optimizer.PrimitiveSet;
import org.eclipse.draw3d.graphics.optimizer.classification.PrimitiveClass;
import org.eclipse.draw3d.graphics.optimizer.primitive.OutlineRenderRule;
import org.eclipse.draw3d.graphics.optimizer.primitive.SolidRenderRule;
import org.eclipse.draw3d.graphics3d.Graphics3D;
import org.eclipse.draw3d.graphics3d.ILodHelper;
import org.eclipse.draw3d.graphics3d.lwjgl.graphics.LwjglVertexPrimitiveVBO;
import org.eclipse.draw3d.util.ColorConverter;
import org.eclipse.swt.graphics.Color;
import org.lwjgl.opengl.GL11;

public class LwjglQuadVBO
extends LwjglVertexPrimitiveVBO {
    private float[] m_color = new float[4];
    private boolean m_solid;

    public LwjglQuadVBO(PrimitiveSet i_primitives) {
        super(i_primitives);
        PrimitiveClass clazz = i_primitives.getPrimitiveClass();
        if (!clazz.isQuad()) {
            throw new IllegalArgumentException(i_primitives + " does not contain quads");
        }
        this.m_solid = clazz.isSolid();
        if (this.m_solid) {
            SolidRenderRule rule = clazz.getRenderRule().asSolid();
            ColorConverter.toFloatArray((Color)rule.getColor(), (int)rule.getAlpha(), (float[])this.m_color);
        } else {
            OutlineRenderRule rule = clazz.getRenderRule().asOutline();
            ColorConverter.toFloatArray((Color)rule.getColor(), (int)rule.getAlpha(), (float[])this.m_color);
        }
    }

    protected void doRender(Graphics3D i_g3d, ILodHelper i_lodContext) {
        i_g3d.glColor4f(this.m_color);
        if (this.m_solid) {
            GL11.glPolygonMode((int)1032, (int)6914);
            GL11.glDrawArrays((int)7, (int)0, (int)this.getVertexCount());
        } else {
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)0.0f);
            GL11.glPolygonMode((int)1032, (int)6913);
            GL11.glDrawArrays((int)7, (int)0, (int)this.getVertexCount());
        }
    }
}

