/*
 * Decompiled with CFR 0.152.
 */
package org.ascape.model;

import org.ascape.model.Agent;
import org.ascape.util.ValueSetter;

public abstract class HistoryValueSetter
extends ValueSetter {
    private double[] values = new double[0];
    private int periodBegin;

    public void setPeriodRange(int periodBegin, int periodEnd) {
        this.periodBegin = periodBegin;
        this.values = new double[periodEnd - periodBegin + 1];
    }

    public void setInitialPeriods(int size) {
        this.values = new double[size];
    }

    public double getValueFor(int period) {
        return this.values[period - this.periodBegin];
    }

    public synchronized void setValueFor(int period, double value) {
        if (period - this.periodBegin < this.values.length) {
            this.values[period - this.periodBegin] = value;
        } else {
            double[] newValues = new double[period - this.periodBegin + 1];
            int i = 0;
            while (i < this.values.length) {
                newValues[i] = this.values[i];
                ++i;
            }
            newValues[period - this.periodBegin] = value;
            this.values = newValues;
        }
    }

    public double getValue(Object object) {
        return this.values[((Agent)object).getRoot().getPeriod() - this.periodBegin];
    }
}

