/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef3d.ui.parts;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.draw2d.ExclusionSearch;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LightweightSystem;
import org.eclipse.draw2d.TreeSearch;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw3d.Draw3DCanvas;
import org.eclipse.draw3d.IFigure3D;
import org.eclipse.draw3d.ISurface;
import org.eclipse.draw3d.LightweightSystem3D;
import org.eclipse.draw3d.geometry.IVector3f;
import org.eclipse.draw3d.geometry.Vector3f;
import org.eclipse.draw3d.picking.Hit;
import org.eclipse.draw3d.picking.Picker;
import org.eclipse.draw3d.util.Draw3DCache;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.Handle;
import org.eclipse.gef.editparts.LayerManager;
import org.eclipse.gef3d.SurfaceSearch;
import org.eclipse.gef3d.ui.parts.GraphicalViewer3D;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class GraphicalViewer3DHelper {
    protected GraphicalViewer3D viewer;

    public GraphicalViewer3DHelper(GraphicalViewer3D viewer3D) {
        if (viewer3D == null) {
            throw new NullPointerException("viewer3D must not be null");
        }
        this.viewer = viewer3D;
    }

    public Handle findHandleAt(Point i_sLocation) {
        Vector3f point;
        block5: {
            Hit hit;
            block4: {
                LayerManager layermanager = (LayerManager)this.viewer.getEditPartRegistry().get(LayerManager.ID);
                if (layermanager == null) {
                    return null;
                }
                point = Draw3DCache.getVector3f();
                try {
                    ArrayList<IFigure> ignore = new ArrayList<IFigure>(3);
                    ignore.add(layermanager.getLayer((Object)"Primary Layer"));
                    ignore.add(layermanager.getLayer((Object)"Connection Layer"));
                    ignore.add(layermanager.getLayer((Object)"Feedback Layer"));
                    ExclusionSearch search = new ExclusionSearch(ignore);
                    LightweightSystem3D lws = this.viewer.getLightweightSystem3D();
                    Picker picker = lws.getPicker();
                    ISurface surface = picker.getCurrentSurface();
                    surface.getWorldLocation(i_sLocation, point);
                    hit = picker.getHit((IVector3f)point, (TreeSearch)search);
                    if (hit != null) break block4;
                }
                catch (Throwable throwable) {
                    Draw3DCache.returnVector3f((Vector3f[])new Vector3f[]{point});
                    throw throwable;
                }
                Draw3DCache.returnVector3f((Vector3f[])new Vector3f[]{point});
                return null;
            }
            IFigure3D figure3D = hit.getFigure3D();
            if (!(figure3D instanceof Handle)) break block5;
            Handle handle = (Handle)figure3D;
            Draw3DCache.returnVector3f((Vector3f[])new Vector3f[]{point});
            return handle;
        }
        Draw3DCache.returnVector3f((Vector3f[])new Vector3f[]{point});
        return null;
    }

    public EditPart findObjectAtExcluding(Point i_sLocation, Collection i_exclude, EditPartViewer.Conditional i_condition) {
        EditPart part;
        Point figureSLocation;
        Vector3f point;
        block5: {
            EditPart editPart;
            point = Draw3DCache.getVector3f();
            figureSLocation = Draw3DCache.getPoint();
            try {
                LightweightSystem3D lws = this.viewer.getLightweightSystem3D();
                Picker picker = lws.getPicker();
                ISurface surface = picker.getCurrentSurface();
                surface.getWorldLocation(i_sLocation, point);
                ConditionalTreeSearch search = new ConditionalTreeSearch(i_exclude, i_condition);
                Hit hit = picker.getHit((IVector3f)point, (TreeSearch)search);
                part = null;
                if (hit != null) {
                    IFigure figure = hit.getSearchResult();
                    while (part == null && figure != null) {
                        part = (EditPart)this.viewer.getVisualPartMap().get(figure);
                        figure = figure.getParent();
                    }
                }
                if (part != null) break block5;
                editPart = this.viewer.getContents();
            }
            catch (Throwable throwable) {
                Draw3DCache.returnVector3f((Vector3f[])new Vector3f[]{point});
                Draw3DCache.returnPoint((Point[])new Point[]{figureSLocation});
                throw throwable;
            }
            Draw3DCache.returnVector3f((Vector3f[])new Vector3f[]{point});
            Draw3DCache.returnPoint((Point[])new Point[]{figureSLocation});
            return editPart;
        }
        EditPart editPart = part;
        Draw3DCache.returnVector3f((Vector3f[])new Vector3f[]{point});
        Draw3DCache.returnPoint((Point[])new Point[]{figureSLocation});
        return editPart;
    }

    public LightweightSystem createLightweightSystem() {
        LightweightSystem3D lws3D = new LightweightSystem3D();
        lws3D.getPicker().setSurfaceSearch((TreeSearch)new SurfaceSearch((EditPartViewer)this.viewer));
        return lws3D;
    }

    public Control createControl3D(Composite i_composite, LightweightSystem3D lightweightSystem3D) {
        Draw3DCanvas canvas = Draw3DCanvas.createCanvas((Composite)i_composite, (int)0, (LightweightSystem3D)lightweightSystem3D);
        this.viewer.setControl((Control)canvas);
        return this.viewer.getControl();
    }

    class ConditionalTreeSearch
    extends ExclusionSearch {
        final EditPartViewer.Conditional condition;

        ConditionalTreeSearch(Collection coll, EditPartViewer.Conditional condition) {
            super(coll);
            this.condition = condition;
        }

        public boolean accept(IFigure i_figure) {
            IFigure current = i_figure;
            EditPart editpart = null;
            while (editpart == null && current != null) {
                editpart = (EditPart)GraphicalViewer3DHelper.this.viewer.getVisualPartMap().get(current);
                current = current.getParent();
            }
            return editpart != null && (this.condition == null || this.condition.evaluate(editpart));
        }

        public String toString() {
            StringBuilder result = new StringBuilder("ConditionalTreeSearch [");
            result.append("condition: ").append(String.valueOf(this.condition));
            result.append("]");
            return result.toString();
        }
    }
}

