/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.tests.services;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.uml2.uml.Activity;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.Dependency;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.EncapsulatedClassifier;
import org.eclipse.uml2.uml.Generalization;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.Interaction;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.InterfaceRealization;
import org.eclipse.uml2.uml.LiteralBoolean;
import org.eclipse.uml2.uml.LiteralInteger;
import org.eclipse.uml2.uml.LiteralString;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageImport;
import org.eclipse.uml2.uml.ParameterableElement;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.PrimitiveType;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Slot;
import org.eclipse.uml2.uml.StateMachine;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.StructuralFeature;
import org.eclipse.uml2.uml.StructuredClassifier;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.UMLPlugin;
import org.eclipse.uml2.uml.Usage;
import org.eclipse.uml2.uml.util.UMLSwitch;

public class UMLServices {
    private static final String SCENARIO_PREFIX = "Scenario_";
    private static final String SEPARATOR = ",";

    public Type findTypeByName(EObject object, String typeName) {
        Type result = this.findTypeByName(this.getAllRootsInResourceSet(object), typeName);
        return result;
    }

    public Type getStringType(EObject object) {
        Type result = this.findTypeByName(this.getAllRootsInResourceSet(object), "String");
        return result;
    }

    public Type findTypeByName(Collection<EObject> roots, String typeName) {
        for (EObject root : roots) {
            Type result = this.findTypeByNameFrom(root, typeName);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public Collection<EObject> getAllRootsInResourceSet(EObject context) {
        Resource res = context.eResource();
        if (res != null && res.getResourceSet() != null) {
            ArrayList<EObject> roots = new ArrayList<EObject>();
            for (Resource childRes : res.getResourceSet().getResources()) {
                roots.addAll((Collection<EObject>)childRes.getContents());
            }
            return roots;
        }
        return Collections.emptySet();
    }

    public List<EObject> getAllStereotypesAndProfiles(Element element) {
        ArrayList<EObject> stereotypesAndProfiles = new ArrayList<EObject>();
        Collection<Profile> profiles = UMLServices.getAllProfilesInPlatform(element);
        stereotypesAndProfiles.addAll(this.getAllStereotypes(element, profiles));
        stereotypesAndProfiles.addAll(profiles);
        return stereotypesAndProfiles;
    }

    private List<Stereotype> getAllStereotypes(Element element, Collection<Profile> profiles) {
        ArrayList<Stereotype> stereotypes = new ArrayList<Stereotype>();
        for (Profile profile : profiles) {
            Package pkg = element.getNearestPackage();
            boolean isProfileApplied = false;
            if (pkg.isProfileApplied(profile)) {
                isProfileApplied = true;
            }
            if (!isProfileApplied) {
                pkg.applyProfile(profile);
            }
            stereotypes.addAll((Collection<Stereotype>)element.getApplicableStereotypes());
            if (isProfileApplied) continue;
            pkg.unapplyProfile(profile);
        }
        return stereotypes;
    }

    public static Collection<Profile> getAllProfilesInPlatform(Element element) {
        Package package_ = element.getNearestPackage();
        final ArrayList<Profile> roots = new ArrayList<Profile>();
        if (package_ instanceof Package) {
            Package packageUML = package_;
            ResourceSet resourceSet = packageUML.eResource().getResourceSet();
            for (URI profileURI : UMLPlugin.getEPackageNsURIToProfileLocationMap().values()) {
                try {
                    resourceSet.getResource(profileURI.trimFragment(), true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            for (Resource resource : resourceSet.getResources()) {
                TreeIterator allContents = resource.getAllContents();
                while (allContents.hasNext()) {
                    new UMLSwitch<Object>(){

                        public Object caseProfile(Profile profile) {
                            if (profile.isDefined()) {
                                roots.add(profile);
                            }
                            return profile;
                        }
                    }.doSwitch((EObject)allContents.next());
                }
            }
        }
        return roots;
    }

    private Type findTypeByNameFrom(EObject root, String typeName) {
        if (root instanceof Type && this.nameMatches((NamedElement)((Type)root), typeName)) {
            return (Type)root;
        }
        TreeIterator i = root.eAllContents();
        while (i.hasNext()) {
            EObject obj = (EObject)i.next();
            if (!(obj instanceof Type) || !this.nameMatches((NamedElement)((Type)obj), typeName)) continue;
            return (Type)obj;
        }
        return null;
    }

    private boolean nameMatches(NamedElement namedElt, String name) {
        if (namedElt != null && namedElt.getName() != null && name != null) {
            return namedElt.getName().trim().equalsIgnoreCase(name.trim());
        }
        return false;
    }

    public String computeUmlLabel(NamedElement element) {
        return element.getName();
    }

    public String genDependencyName(NamedElement source, NamedElement target) {
        return source.getName() + "To" + target.getName();
    }

    public void createSlot(InstanceSpecification source, Property property) {
        Slot slot = UMLFactory.eINSTANCE.createSlot();
        slot.setDefiningFeature((StructuralFeature)property);
        source.getSlots().add((Object)slot);
        if (property.getType() instanceof PrimitiveType) {
            String typeName = ((PrimitiveType)property.getType()).getName();
            LiteralInteger value = null;
            if ("Integer".equals(typeName)) {
                LiteralInteger aLiteralInteger = UMLFactory.eINSTANCE.createLiteralInteger();
                aLiteralInteger.setValue(Integer.parseInt(property.getDefault()));
                value = aLiteralInteger;
            } else if ("Boolean".equals(typeName)) {
                LiteralBoolean aLiteralBoolean = UMLFactory.eINSTANCE.createLiteralBoolean();
                aLiteralBoolean.setValue(Boolean.parseBoolean(property.getDefault()));
                value = aLiteralBoolean;
            } else if ("String".equals(typeName)) {
                LiteralString aLiteralString = UMLFactory.eINSTANCE.createLiteralString();
                aLiteralString.setValue(property.getDefault());
                value = aLiteralString;
            }
            if (value != null) {
                slot.getValues().add((Object)value);
            }
        }
    }

    public Set<Type> getAvailableTypes(Package pkg) {
        LinkedHashSet<Type> availableTypes = new LinkedHashSet<Type>();
        Set<Package> availablePackages = this.getAvailablePackages(pkg);
        for (Package availablePackage : availablePackages) {
            Set types = availablePackage.getOwnedTypes().stream().filter(type -> type instanceof Class || type instanceof Interface || type instanceof DataType).collect(Collectors.toCollection(LinkedHashSet::new));
            availableTypes.addAll(types);
        }
        return availableTypes;
    }

    public Set<Package> getAvailablePackages(Package pkg) {
        LinkedHashSet<Package> packages = new LinkedHashSet<Package>();
        packages.add(pkg);
        TreeIterator iterator = pkg.getModel().eAllContents();
        while (iterator.hasNext()) {
            EObject eObject = (EObject)iterator.next();
            if (!(eObject instanceof Package)) continue;
            packages.add((Package)eObject);
            for (PackageImport packageImport : pkg.getPackageImports()) {
                packages.add(packageImport.getImportedPackage());
            }
        }
        return packages;
    }

    public static String getNewInteractionName(EObject pkg) {
        StringBuffer name = new StringBuffer(SCENARIO_PREFIX);
        name.append(UMLServices.getNumberOfElements((List)((Package)pkg).getPackagedElements(), SCENARIO_PREFIX));
        return name.toString();
    }

    private static int getNumberOfElements(List elements, String prefix) {
        int lastUsedIndex = -1;
        for (Object element : elements) {
            int index;
            String name = ((NamedElement)element).getName();
            if (name == null || !name.startsWith(prefix) || (index = Integer.valueOf(name.substring(name.lastIndexOf("_") + 1)).intValue()) <= lastUsedIndex) continue;
            lastUsedIndex = index;
        }
        return lastUsedIndex + 1;
    }

    public String getStereotypesDescription(Element elt, String attributesToDisplay) {
        String description = "";
        ArrayList<String> displayedAttributeList = new ArrayList<String>(Arrays.asList(attributesToDisplay.split(SEPARATOR)));
        for (Stereotype stereotype : elt.getAppliedStereotypes()) {
            description = description.concat("<<" + stereotype.getName() + ">>\n");
            for (Property attribute : stereotype.getAllAttributes()) {
                Object obj;
                if (!displayedAttributeList.contains(attribute.getName()) || (obj = this.getDisplayContent(elt, stereotype, attribute.getName())) == null) continue;
                description = description.concat(attribute.getName() + " = " + String.valueOf(obj) + "\n");
            }
        }
        return description;
    }

    private Object getDisplayContent(Element elt, Stereotype stereotype, String attributeToDisplay) {
        Object obj = elt.getValue(stereotype, attributeToDisplay);
        if (obj instanceof NamedElement) {
            return ((NamedElement)obj).getName();
        }
        return obj;
    }

    public List<Package> getAllAvailableRootPackages(Element element) {
        ArrayList<Package> packages = new ArrayList<Package>();
        packages.add((Package)element.getModel());
        element.getModel().getImportedPackages().stream().filter(Model.class::isInstance).forEach(packages::add);
        return packages;
    }

    public List<EObject> getValidsForComponentDiagram(EObject cur) {
        Iterable allContents = () -> cur.eResource().getAllContents();
        return StreamSupport.stream(allContents.spliterator(), false).filter(input -> input instanceof Package || input instanceof Interface || "Class".equals(input.eClass().getName()) || "Component".equals(input.eClass().getName())).collect(Collectors.toList());
    }

    public List<EObject> getValidsForCompositeDiagram(EObject cur) {
        Iterable allContents = () -> cur.eResource().getAllContents();
        Predicate<EObject> validForCompositeDiagram = new Predicate<EObject>(){

            @Override
            public boolean test(EObject input) {
                if (input instanceof StructuredClassifier) {
                    return !(input instanceof Interaction) && !(input instanceof StateMachine) && !(input instanceof Activity);
                }
                return input instanceof Package || input instanceof Interface || "Port".equals(input.eClass().getName()) || "Property".equals(input.eClass().getName());
            }
        };
        return StreamSupport.stream(allContents.spliterator(), false).filter(validForCompositeDiagram).collect(Collectors.toList());
    }

    public Comment getComment(Element element) {
        if (element.getOwnedComments().size() > 0) {
            return (Comment)element.getOwnedComments().get(0);
        }
        return null;
    }

    public boolean canCreateAnInstanceSlot(InstanceSpecification preSource, InstanceSpecification preTarget) {
        boolean result = !this.candidatesForInstanceSlot(preSource, preTarget).isEmpty();
        return result;
    }

    public Set<Property> candidatesForInstanceSlot(InstanceSpecification source, InstanceSpecification target) {
        HashSet<Property> candidates = new HashSet<Property>();
        for (Classifier sourceClassifier : source.getClassifiers()) {
            for (Classifier targetClassifier : target.getClassifiers()) {
                candidates.addAll(UMLServices.candidatesForInstanceSlot(sourceClassifier, targetClassifier));
            }
        }
        return candidates;
    }

    private static Set<Property> candidatesForInstanceSlot(Classifier source, Classifier target) {
        HashSet<Property> candidates = new HashSet<Property>();
        HashSet associations = new HashSet();
        associations.addAll(source.getAssociations());
        for (Classifier superType : UMLServices.getSuperTypes(source)) {
            associations.addAll(superType.getAssociations());
        }
        for (Association association : associations) {
            Property sourceAsso = UMLServices.getSource(association);
            Property targetAsso = UMLServices.getTarget(association);
            if (!UMLServices.conformTo((Type)source, sourceAsso.getType()) || !UMLServices.conformTo((Type)target, targetAsso.getType())) continue;
            if (association.getNavigableOwnedEnds().contains((Object)sourceAsso)) {
                candidates.add(sourceAsso);
                continue;
            }
            if (!association.getNavigableOwnedEnds().contains((Object)targetAsso)) continue;
            candidates.add(targetAsso);
        }
        return candidates;
    }

    public static Property getSource(Association association) {
        if (association.getMemberEnds() != null && association.getMemberEnds().size() > 0) {
            return (Property)association.getMemberEnds().get(0);
        }
        return null;
    }

    public static Property getTarget(Association association) {
        if (association.getMemberEnds() != null && association.getMemberEnds().size() > 1) {
            return (Property)association.getMemberEnds().get(1);
        }
        return null;
    }

    private static boolean conformTo(Type type1, Type type2) {
        boolean conform = false;
        HashSet<Object> allTypes1 = new HashSet<Object>();
        allTypes1.add(type1);
        if (type1 instanceof Classifier) {
            allTypes1.addAll(UMLServices.getSuperTypes((Classifier)type1));
        }
        HashSet<Object> allTypes2 = new HashSet<Object>();
        allTypes2.add(type2);
        if (type2 instanceof Classifier) {
            allTypes2.addAll(UMLServices.getSuperTypes((Classifier)type2));
        }
        for (Type type : allTypes1) {
            for (Type type3 : allTypes2) {
                if (!type.conformsTo(type3)) continue;
                conform = true;
                break;
            }
            if (conform) break;
        }
        return conform;
    }

    private static Set<Classifier> getSuperTypes(Classifier type) {
        HashSet<Classifier> result = new HashSet<Classifier>();
        EList generals = type.getGenerals();
        for (Classifier general : generals) {
            result.add(general);
            result.addAll(UMLServices.getSuperTypes(general));
        }
        for (Dependency dependency : type.getClientDependencies()) {
            if (!(dependency instanceof InterfaceRealization)) continue;
            Interface contract = ((InterfaceRealization)dependency).getContract();
            result.add((Classifier)contract);
            result.addAll(UMLServices.getSuperTypes((Classifier)contract));
        }
        return result;
    }

    public Set<Element> candidatesForSlot(InstanceSpecification anInstanceSpecification) {
        HashSet<Element> result = new HashSet<Element>();
        for (Classifier classifier : anInstanceSpecification.getClassifiers()) {
            result.add((Element)classifier);
            result.addAll((Collection<Element>)classifier.getAllAttributes());
            for (Classifier superType : UMLServices.getSuperTypes(classifier)) {
                result.add((Element)superType);
                result.addAll((Collection<Element>)superType.getAllAttributes());
            }
        }
        return result;
    }

    public boolean isConnectable(Element source, Element target) {
        boolean result = false;
        if (source instanceof Interface) {
            if (target instanceof Interface) {
                result = this.isConnectable((Interface)source, (Interface)target);
            } else if (target instanceof Port) {
                result = this.isConnectable((Interface)source, (Port)target);
            } else if (target instanceof Property) {
                result = this.isConnectable((Interface)source, (Property)target);
            }
        } else if (source instanceof Port) {
            if (target instanceof Interface) {
                result = this.isConnectable((Port)source, (Interface)target);
            } else if (target instanceof Port) {
                result = false;
            } else if (target instanceof Property) {
                result = this.isConnectable((Port)source, (Property)target);
            }
        } else if (source instanceof Property) {
            if (target instanceof Interface) {
                result = this.isConnectable((Property)source, (Interface)target);
            } else if (target instanceof Port) {
                result = this.isConnectable((Property)source, (Port)target);
            } else if (target instanceof Property) {
                result = this.isConnectable((Property)source, (Property)target);
            }
        }
        return result;
    }

    protected boolean isConnectable(Interface source, Interface target) {
        boolean res = source.conformsTo((Type)target);
        if (!res) {
            EList generalizations = source.getGeneralizations();
            for (Generalization generalization : generalizations) {
                if (generalization.getGeneral() instanceof Interface && (res = this.isConnectable((Interface)generalization.getGeneral(), target))) break;
            }
        }
        return res;
    }

    protected boolean isConnectable(Interface source, Port target) {
        boolean res = false;
        ArrayList clientDependencies = new ArrayList(target.getClientDependencies());
        if (target.getType() instanceof EncapsulatedClassifier) {
            clientDependencies.addAll(target.getType().getClientDependencies());
        }
        for (Dependency dependency : clientDependencies) {
            if (!(dependency instanceof InterfaceRealization)) continue;
            EList suppliers = dependency.getSuppliers();
            for (NamedElement interfaceSupplier : suppliers) {
                if (interfaceSupplier instanceof Interface && (res = this.isConnectable(source, (Interface)interfaceSupplier))) break;
            }
            if (res) break;
        }
        return res;
    }

    protected boolean isConnectable(Port source, Interface target) {
        boolean res = false;
        ArrayList clientDependencies = new ArrayList(source.getClientDependencies());
        if (source.getType() instanceof EncapsulatedClassifier) {
            clientDependencies.addAll(source.getType().getClientDependencies());
        }
        for (Dependency dependency : clientDependencies) {
            if (!(dependency instanceof Usage)) continue;
            EList suppliers = dependency.getSuppliers();
            for (NamedElement interfaceSupplier : suppliers) {
                if (interfaceSupplier instanceof Interface && (res = this.isConnectable((Interface)interfaceSupplier, target))) break;
            }
            if (res) break;
        }
        return res;
    }

    protected boolean isConnectable(Property source, Property target) {
        boolean res = true;
        if (source.getType() != null && target.getType() != null) {
            res = source.getType() instanceof Interface && target.getType() instanceof Interface ? this.isConnectable((Interface)source.getType(), (Interface)target.getType()) : source.isCompatibleWith((ParameterableElement)target);
        }
        return res;
    }

    protected boolean isConnectable(Interface source, Property target) {
        return false;
    }

    protected boolean isConnectable(Property source, Interface target) {
        return false;
    }

    protected boolean isConnectable(Port source, Property target) {
        return false;
    }

    protected boolean isConnectable(Property source, Port target) {
        return false;
    }
}

