/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.runtime.test;

import java.util.HashMap;
import java.util.Set;
import org.eclipse.acceleo.query.runtime.IQueryBuilderEngine;
import org.eclipse.acceleo.query.runtime.IQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IQueryEvaluationEngine;
import org.eclipse.acceleo.query.runtime.IReadOnlyQueryEnvironment;
import org.eclipse.acceleo.query.runtime.Query;
import org.eclipse.acceleo.query.runtime.QueryEvaluation;
import org.eclipse.acceleo.query.runtime.QueryParsing;
import org.eclipse.acceleo.query.runtime.ServiceUtils;
import org.eclipse.acceleo.query.runtime.servicelookup.ServicesCountCalls;
import org.eclipse.emf.ecore.EcorePackage;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ShortcutEvaluationTest {
    IQueryEvaluationEngine evaluator;
    IQueryBuilderEngine parser;
    private HashMap<String, Object> variables;

    @Before
    public void setUp() {
        IQueryEnvironment queryEnvironment = Query.newEnvironmentWithDefaultServices(null);
        Set services = ServiceUtils.getServices((IReadOnlyQueryEnvironment)queryEnvironment, ServicesCountCalls.class);
        ServiceUtils.registerServices((IQueryEnvironment)queryEnvironment, (Set)services);
        this.parser = QueryParsing.newBuilder();
        this.evaluator = QueryEvaluation.newEngine((IQueryEnvironment)queryEnvironment);
        this.variables = new HashMap();
        this.variables.put("self", EcorePackage.eINSTANCE);
        this.evaluator.eval(this.parser.build("self.reset()"), this.variables);
    }

    @Test
    public void serviceIsCounting() {
        Assert.assertEquals((Object)0, (Object)this.evaluator.eval(this.parser.build("self.getCallCounts()"), this.variables).getResult());
        Assert.assertEquals((Object)Boolean.TRUE, (Object)this.evaluator.eval(this.parser.build("self.checkAlwaysTrue()"), this.variables).getResult());
        Assert.assertEquals((Object)1, (Object)this.evaluator.eval(this.parser.build("self.getCallCounts()"), this.variables).getResult());
        Assert.assertEquals((Object)Boolean.FALSE, (Object)this.evaluator.eval(this.parser.build("self.checkAlwaysFalse()"), this.variables).getResult());
        Assert.assertEquals((Object)2, (Object)this.evaluator.eval(this.parser.build("self.getCallCounts()"), this.variables).getResult());
    }

    @Test
    public void andPrematureStopWhenFalse() {
        Assert.assertEquals((Object)0, (Object)this.evaluator.eval(this.parser.build("self.getCallCounts()"), this.variables).getResult());
        Assert.assertEquals((Object)Boolean.FALSE, (Object)this.evaluator.eval(this.parser.build("self.checkAlwaysFalse() and self.checkAlwaysTrue()"), this.variables).getResult());
        Assert.assertEquals((Object)1, (Object)this.evaluator.eval(this.parser.build("self.getCallCounts()"), this.variables).getResult());
    }

    @Test
    public void andNoStopWhenTrue() {
        Assert.assertEquals((Object)0, (Object)this.evaluator.eval(this.parser.build("self.getCallCounts()"), this.variables).getResult());
        Assert.assertEquals((Object)Boolean.TRUE, (Object)this.evaluator.eval(this.parser.build("self.checkAlwaysTrue() and self.checkAlwaysTrue()"), this.variables).getResult());
        Assert.assertEquals((Object)2, (Object)this.evaluator.eval(this.parser.build("self.getCallCounts()"), this.variables).getResult());
    }

    @Test
    public void orPrematureStopWhenTrue() {
        Assert.assertEquals((Object)0, (Object)this.evaluator.eval(this.parser.build("self.getCallCounts()"), this.variables).getResult());
        Assert.assertEquals((Object)Boolean.TRUE, (Object)this.evaluator.eval(this.parser.build("self.checkAlwaysTrue() or self.checkAlwaysTrue()"), this.variables).getResult());
        Assert.assertEquals((Object)1, (Object)this.evaluator.eval(this.parser.build("self.getCallCounts()"), this.variables).getResult());
    }

    @Test
    public void orNoStopWhenFalse() {
        Assert.assertEquals((Object)0, (Object)this.evaluator.eval(this.parser.build("self.getCallCounts()"), this.variables).getResult());
        Assert.assertEquals((Object)Boolean.TRUE, (Object)this.evaluator.eval(this.parser.build("self.checkAlwaysFalse() or self.checkAlwaysTrue()"), this.variables).getResult());
        Assert.assertEquals((Object)2, (Object)this.evaluator.eval(this.parser.build("self.getCallCounts()"), this.variables).getResult());
    }

    @Test
    public void impliesPrematureStopWhenFalse() {
        Assert.assertEquals((Object)0, (Object)this.evaluator.eval(this.parser.build("self.getCallCounts()"), this.variables).getResult());
        Assert.assertEquals((Object)Boolean.TRUE, (Object)this.evaluator.eval(this.parser.build("self.checkAlwaysFalse() implies self.checkAlwaysTrue()"), this.variables).getResult());
        Assert.assertEquals((Object)1, (Object)this.evaluator.eval(this.parser.build("self.getCallCounts()"), this.variables).getResult());
    }

    @Test
    public void impliesNoStopWhenTrue() {
        Assert.assertEquals((Object)0, (Object)this.evaluator.eval(this.parser.build("self.getCallCounts()"), this.variables).getResult());
        Assert.assertEquals((Object)Boolean.TRUE, (Object)this.evaluator.eval(this.parser.build("self.checkAlwaysTrue() implies self.checkAlwaysTrue()"), this.variables).getResult());
        Assert.assertEquals((Object)2, (Object)this.evaluator.eval(this.parser.build("self.getCallCounts()"), this.variables).getResult());
    }
}

