/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.cdo.tests;

import java.util.HashMap;
import org.eclipse.emf.cdo.internal.server.Repository;
import org.eclipse.emf.cdo.net4j.CDONet4jUtil;
import org.eclipse.emf.cdo.server.CDOServerUtil;
import org.eclipse.emf.cdo.server.IRepository;
import org.eclipse.emf.cdo.server.IStore;
import org.eclipse.emf.cdo.server.mem.MEMStoreUtil;
import org.eclipse.emf.cdo.server.net4j.CDONet4jServerUtil;
import org.eclipse.emf.cdo.spi.server.InternalSessionManager;
import org.eclipse.emf.cdo.spi.server.InternalStore;
import org.eclipse.net4j.Net4jUtil;
import org.eclipse.net4j.acceptor.IAcceptor;
import org.eclipse.net4j.tcp.TCPUtil;
import org.eclipse.net4j.util.container.ContainerUtil;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.net4j.util.om.OMPlatform;
import org.eclipse.net4j.util.om.log.OMLogHandler;
import org.eclipse.net4j.util.om.log.PrintLogHandler;
import org.eclipse.net4j.util.om.trace.OMTraceHandler;
import org.eclipse.net4j.util.om.trace.PrintTraceHandler;
import org.eclipse.net4j.util.security.IAuthenticator;
import org.eclipse.net4j.util.security.INegotiator;
import org.eclipse.net4j.util.security.IPasswordCredentialsProvider;
import org.eclipse.net4j.util.security.PasswordCredentialsProvider;
import org.eclipse.net4j.util.security.ResponseNegotiator;
import org.eclipse.net4j.util.security.UserManager;

public final class CDOServer {
    public static final int PORT = 12345;
    public static final String REPOSITORY_NAME = "testRepo";
    public static final String PROTOCOL = "tcp";
    public static final String IP = "127.0.0.1";
    public static final String USER_NAME = "user";
    public static final String PASSWORD = "password";
    private IRepository repository;
    private final boolean withAuth;
    private IManagedContainer container;
    private IAcceptor acceptor;

    public CDOServer(boolean withAuth) {
        this.withAuth = withAuth;
    }

    protected IRepository createRepository() {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("supportingAudits", Boolean.TRUE.toString());
        props.put("supportingBranches", Boolean.TRUE.toString());
        Repository.Default res = new Repository.Default(){

            public String getUUID() {
                return "5ef25598-0af9-4436-b7df-5764732e4c0b";
            }
        };
        res.setName(REPOSITORY_NAME);
        res.setStore((InternalStore)this.createStore());
        res.setProperties(props);
        return res;
    }

    protected IStore createStore() {
        return MEMStoreUtil.createMEMStore();
    }

    protected INegotiator createNegotiator() {
        ResponseNegotiator negotiator = new ResponseNegotiator();
        negotiator.setCredentialsProvider((IPasswordCredentialsProvider)new PasswordCredentialsProvider(USER_NAME, PASSWORD));
        return negotiator;
    }

    public void start() {
        if (this.repository == null) {
            this.container = ContainerUtil.createContainer();
            Net4jUtil.prepareContainer((IManagedContainer)this.container);
            CDONet4jUtil.prepareContainer((IManagedContainer)this.container);
            TCPUtil.prepareContainer((IManagedContainer)this.container);
            this.container.activate();
            OMPlatform.INSTANCE.setDebugging(false);
            OMPlatform.INSTANCE.addTraceHandler((OMTraceHandler)PrintTraceHandler.CONSOLE);
            OMPlatform.INSTANCE.addLogHandler((OMLogHandler)PrintLogHandler.CONSOLE);
            Net4jUtil.prepareContainer((IManagedContainer)this.container);
            TCPUtil.prepareContainer((IManagedContainer)this.container);
            CDONet4jServerUtil.prepareContainer((IManagedContainer)this.container);
            this.repository = this.createRepository();
            if (this.withAuth) {
                InternalSessionManager sessionManager = (InternalSessionManager)CDOServerUtil.createSessionManager();
                UserManager userManager = new UserManager();
                userManager.addUser(USER_NAME, PASSWORD.toCharArray());
                sessionManager.setAuthenticator((IAuthenticator)userManager);
                ((Repository)this.repository).setSessionManager(sessionManager);
            }
            CDOServerUtil.addRepository((IManagedContainer)this.container, (IRepository)this.repository);
            this.acceptor = Net4jUtil.getAcceptor((IManagedContainer)this.container, (String)PROTOCOL, (String)"127.0.0.1:12345");
        }
    }

    public void stop() {
        this.acceptor.close();
        LifecycleUtil.deactivate((Object)this.repository);
        LifecycleUtil.deactivate((Object)this.container);
        this.repository = null;
        this.container = null;
    }
}

