/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.ide;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.acceleo.query.ide.runtime.impl.namespace.EclipseQualifiedNameResolver;
import org.eclipse.acceleo.query.ide.runtime.impl.namespace.ResolverFactoryRegistryListener;
import org.eclipse.acceleo.query.ide.runtime.namespace.IResolverFactoryDescriptor;
import org.eclipse.acceleo.query.runtime.impl.namespace.JavaLoader;
import org.eclipse.acceleo.query.runtime.namespace.ILoader;
import org.eclipse.acceleo.query.runtime.namespace.IQualifiedNameResolver;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryEventListener;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.util.ResourceLocator;
import org.osgi.framework.BundleContext;

public class QueryPlugin
extends EMFPlugin {
    public static final String PLUGIN_ID = "org.eclipse.acceleo.query.ide";
    public static final QueryPlugin INSTANCE = new QueryPlugin();
    private static Implementation plugin;
    private static final List<IResolverFactoryDescriptor> RESOLVER_FACTORY_DESCRIPTORS;

    static {
        RESOLVER_FACTORY_DESCRIPTORS = new ArrayList<IResolverFactoryDescriptor>();
    }

    public QueryPlugin() {
        super(new ResourceLocator[0]);
    }

    public ResourceLocator getPluginResourceLocator() {
        return plugin;
    }

    public static Implementation getPlugin() {
        return plugin;
    }

    public static QueryPlugin getDefault() {
        return INSTANCE;
    }

    public static void log(Exception exception, boolean blocker) {
        int severity = 2;
        if (blocker) {
            severity = 4;
        }
        INSTANCE.log(new Status(severity, PLUGIN_ID, exception.getMessage(), (Throwable)exception));
    }

    public static void log(String message, boolean blocker) {
        String errorMessage;
        int severity = 2;
        if (blocker) {
            severity = 4;
        }
        if ((errorMessage = message) == null || "".equals(errorMessage)) {
            errorMessage = "Logging null message should never happens.";
        }
        INSTANCE.log(new Status(severity, PLUGIN_ID, errorMessage));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerResolverFactory(IResolverFactoryDescriptor descriptor) {
        if (descriptor != null) {
            List<IResolverFactoryDescriptor> list = RESOLVER_FACTORY_DESCRIPTORS;
            synchronized (list) {
                RESOLVER_FACTORY_DESCRIPTORS.add(descriptor);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregisterResolverFactory(IResolverFactoryDescriptor descriptor) {
        if (descriptor != null) {
            List<IResolverFactoryDescriptor> list = RESOLVER_FACTORY_DESCRIPTORS;
            synchronized (list) {
                RESOLVER_FACTORY_DESCRIPTORS.remove(descriptor);
            }
        }
    }

    public static class Implementation
    extends EMFPlugin.EclipsePlugin {
        private final ResolverFactoryRegistryListener resolverFactoryListener = new ResolverFactoryRegistryListener();

        public Implementation() {
            plugin = this;
        }

        public void start(BundleContext context) throws Exception {
            super.start(context);
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            registry.addListener((IRegistryEventListener)this.resolverFactoryListener, "org.eclipse.acceleo.query.ide.resolverfactory");
            this.resolverFactoryListener.parseInitialContributions();
        }

        public void stop(BundleContext context) throws Exception {
            super.stop(context);
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            registry.removeListener((IRegistryEventListener)this.resolverFactoryListener);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IQualifiedNameResolver createQualifiedNameResolver(ClassLoader classLoader, IProject project, String qualifierSeparator) {
            ArrayList factoryDescriptors;
            List list = RESOLVER_FACTORY_DESCRIPTORS;
            synchronized (list) {
                factoryDescriptors = new ArrayList(RESOLVER_FACTORY_DESCRIPTORS);
            }
            EclipseQualifiedNameResolver res = factoryDescriptors.isEmpty() ? new EclipseQualifiedNameResolver(classLoader, project, qualifierSeparator) : ((IResolverFactoryDescriptor)factoryDescriptors.get(0)).getFactory().createResolver(classLoader, project, qualifierSeparator);
            return res;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ILoader createJavaLoader(String qualifierSeparator) {
            ArrayList factoryDescriptors;
            List list = RESOLVER_FACTORY_DESCRIPTORS;
            synchronized (list) {
                factoryDescriptors = new ArrayList(RESOLVER_FACTORY_DESCRIPTORS);
            }
            Object res = factoryDescriptors.isEmpty() ? new JavaLoader(qualifierSeparator) : ((IResolverFactoryDescriptor)factoryDescriptors.get(0)).getFactory().createJavaLoader(qualifierSeparator);
            return res;
        }
    }
}

