/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.aql.migration.converters;

import java.util.Collections;
import java.util.List;
import org.eclipse.acceleo.query.ast.Call;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.TextEdit;

final class AmbiguousServiceMethodRefactorVisitor
extends ASTVisitor {
    private final IDocument document;
    private final String serviceName;
    private final List<org.eclipse.acceleo.query.ast.Expression> serviceArguments;

    AmbiguousServiceMethodRefactorVisitor(IDocument document, Call call) {
        this.document = document;
        this.serviceName = call.getServiceName();
        this.serviceArguments = call.getArguments();
    }

    public boolean visit(MethodDeclaration method) {
        if (method.getName().getIdentifier().equals(this.serviceName) && this.parametersAreMatching(method.parameters(), this.serviceArguments)) {
            ASTRewrite rewrite = ASTRewrite.create((AST)method.getAST());
            MethodDeclaration newMethod = method.getAST().newMethodDeclaration();
            for (Object modifier : method.modifiers()) {
                newMethod.modifiers().add(rewrite.createCopyTarget((ASTNode)modifier));
            }
            newMethod.setReturnType2((Type)rewrite.createCopyTarget((ASTNode)method.getReturnType2()));
            newMethod.setName(newMethod.getAST().newSimpleName(String.valueOf(this.serviceName) + "JavaService"));
            for (Object parameter : method.parameters()) {
                newMethod.parameters().add(rewrite.createCopyTarget((ASTNode)parameter));
            }
            Block body = newMethod.getAST().newBlock();
            ReturnStatement returnStatement = newMethod.getAST().newReturnStatement();
            MethodInvocation methodInvocation = newMethod.getAST().newMethodInvocation();
            methodInvocation.setName(newMethod.getAST().newSimpleName(this.serviceName));
            for (Object parameter : method.parameters()) {
                ASTNode argument = rewrite.createCopyTarget((ASTNode)((SingleVariableDeclaration)parameter).getName());
                methodInvocation.arguments().add(argument);
            }
            returnStatement.setExpression((Expression)methodInvocation);
            body.statements().add(returnStatement);
            newMethod.setBody(body);
            TypeDeclaration typeDeclaration = (TypeDeclaration)method.getParent();
            ListRewrite declarations = rewrite.getListRewrite((ASTNode)typeDeclaration, TypeDeclaration.BODY_DECLARATIONS_PROPERTY);
            declarations.insertAfter((ASTNode)newMethod, (ASTNode)method, null);
            try {
                TextEdit edit = rewrite.rewriteAST(this.document, Collections.EMPTY_MAP);
                edit.apply(this.document);
            }
            catch (IllegalArgumentException | BadLocationException | MalformedTreeException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    private boolean parametersAreMatching(List<SingleVariableDeclaration> parameters, List<org.eclipse.acceleo.query.ast.Expression> arguments) {
        boolean res = true;
        res = parameters.size() == arguments.size();
        return res;
    }
}

