/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.services;

import java.util.Comparator;
import java.util.Map;

final class LambdaComparator<T>
implements Comparator<T> {
    private final Map<T, Object> preComputedValues;

    LambdaComparator(Map<T, Object> preComputedValues) {
        this.preComputedValues = preComputedValues;
    }

    @Override
    public int compare(T o1, T o2) {
        int result;
        Object o1Result = this.preComputedValues.get(o1);
        Object o2Result = this.preComputedValues.get(o2);
        try {
            if (o1Result instanceof Comparable) {
                Comparable c1 = (Comparable)o1Result;
                result = c1.compareTo(o2Result);
            } else if (o2Result instanceof Comparable) {
                Comparable c2 = (Comparable)o2Result;
                result = -c2.compareTo(o1Result);
            } else {
                result = 0;
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Cannot compare " + o1 + " with " + o2, e);
        }
        return result;
    }
}

