/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.aql.parser;

import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.acceleo.AcceleoASTNode;
import org.eclipse.acceleo.AcceleoPackage;
import org.eclipse.acceleo.Expression;
import org.eclipse.acceleo.Metamodel;
import org.eclipse.acceleo.Module;
import org.eclipse.acceleo.TypedElement;
import org.eclipse.acceleo.aql.parser.AcceleoAstResult;
import org.eclipse.acceleo.query.parser.AstResult;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;

public final class AcceleoAstUtils {
    private AcceleoAstUtils() {
    }

    public static AcceleoASTNode getContainerOfAqlAstElement(EObject aqlAstElement) {
        Expression containerAcceleoExpression = AcceleoAstUtils.getContainerAcceleoExpression(aqlAstElement);
        if (containerAcceleoExpression == null) {
            TypedElement containerAcceleoTypedElement = AcceleoAstUtils.getContainerTypedElement(aqlAstElement);
            return (AcceleoASTNode)((Object)containerAcceleoTypedElement);
        }
        return containerAcceleoExpression;
    }

    public static AstResult getAqlAstResultOfAqlAstElement(EObject aqlAstElement) {
        AcceleoASTNode acceleoContainerOfAqlAstElement = AcceleoAstUtils.getContainerOfAqlAstElement(aqlAstElement);
        return AcceleoAstUtils.getContainedAqlAstResultOf(acceleoContainerOfAqlAstElement);
    }

    public static AstResult getContainedAqlAstResultOf(AcceleoASTNode acceleoAstElementContainingAqlAstElement) {
        AstResult containedAstResult = null;
        if (acceleoAstElementContainingAqlAstElement instanceof Expression) {
            Expression acceleoContainerExpression = (Expression)acceleoAstElementContainingAqlAstElement;
            containedAstResult = acceleoContainerExpression.getAst();
        } else if (acceleoAstElementContainingAqlAstElement instanceof TypedElement) {
            TypedElement acceleoContainerTypedElement = (TypedElement)((Object)acceleoAstElementContainingAqlAstElement);
            containedAstResult = acceleoContainerTypedElement.getType();
        }
        return containedAstResult;
    }

    public static Module getContainerModule(AcceleoASTNode astNode) {
        return AcceleoAstUtils.getSelfOrFirstContainerOfType(astNode, Module.class);
    }

    public static String getModuleFullyQualifiedName(Module module) {
        Objects.requireNonNull(module);
        return String.valueOf(module.getName()) + "_" + module.getMetamodels().stream().map(Metamodel::getReferencedPackage).map(EPackage::getNsURI).collect(Collectors.joining("[", ", ", "]"));
    }

    public static Expression getContainerAcceleoExpression(EObject containedEObject) {
        return AcceleoAstUtils.getSelfOrFirstContainerOfType(containedEObject, Expression.class);
    }

    public static TypedElement getContainerTypedElement(EObject containedEObject) {
        return AcceleoAstUtils.getSelfOrFirstContainerOfType(containedEObject, TypedElement.class);
    }

    private static <T extends EObject> T getSelfOrFirstContainerOfType(EObject containedEObject, Class<T> containerType) {
        Objects.requireNonNull(containedEObject);
        Objects.requireNonNull(containerType);
        EObject candidate = containedEObject;
        while (candidate != null && !containerType.isInstance(candidate)) {
            candidate = candidate.eContainer();
        }
        return (T)((EObject)containerType.cast(candidate));
    }

    public static <T extends AcceleoASTNode> T getSelfOrEquivalentOf(T acceleoAstNode, AcceleoAstResult inAcceleoAstResult) {
        if (inAcceleoAstResult.getStartPosition(acceleoAstNode) == -1 && inAcceleoAstResult.getEndPosition(acceleoAstNode) == -1) {
            return AcceleoAstUtils.getStructuralEqualOf(acceleoAstNode, inAcceleoAstResult);
        }
        return acceleoAstNode;
    }

    public static <T extends EObject> T getSelfOrEquivalentOf(T aqlAstElement, AcceleoAstResult inAcceleoAstResult) {
        AcceleoASTNode acceleoContainerOfAqlAstElement = AcceleoAstUtils.getContainerOfAqlAstElement(aqlAstElement);
        AcceleoASTNode equivalentOfAcceleoContainerOfAqlAstElement = AcceleoAstUtils.getSelfOrEquivalentOf(acceleoContainerOfAqlAstElement, inAcceleoAstResult);
        AstResult aqlAstToSearchIn = AcceleoAstUtils.getContainedAqlAstResultOf(equivalentOfAcceleoContainerOfAqlAstElement);
        return AcceleoAstUtils.getSelfOrEquivalentOf(aqlAstElement, aqlAstToSearchIn);
    }

    public static <T extends EObject> T getSelfOrEquivalentOf(T aqlAstElement, AstResult inAqlAstResult) {
        org.eclipse.acceleo.query.ast.Expression aqlRootElement = inAqlAstResult.getAst();
        if (AcceleoAstUtils.isEqualStructurally(aqlAstElement, (EObject)aqlRootElement)) {
            return (T)aqlRootElement;
        }
        TreeIterator candidatesIterator = aqlRootElement.eAllContents();
        while (candidatesIterator.hasNext()) {
            EObject candidate = (EObject)candidatesIterator.next();
            if (!AcceleoAstUtils.isEqualStructurally(candidate, aqlAstElement)) continue;
            return (T)candidate;
        }
        throw new IllegalArgumentException("Equivalent of AQL AcceleoASTNode \"" + aqlAstElement.toString() + "\" could not be found in AQL AST: " + inAqlAstResult);
    }

    private static <T extends AcceleoASTNode> T getStructuralEqualOf(T astNode, AcceleoAstResult inAcceleoAstResult) {
        Module inAcceleoModule = inAcceleoAstResult.getModule();
        if (AcceleoAstUtils.isEqualStructurally(astNode, inAcceleoModule)) {
            return (T)inAcceleoModule;
        }
        TreeIterator candidatesIterator = inAcceleoModule.eAllContents();
        while (candidatesIterator.hasNext()) {
            AcceleoASTNode candidateAstNode;
            EObject candidate = (EObject)candidatesIterator.next();
            if (!(candidate instanceof AcceleoASTNode) || !AcceleoAstUtils.isEqualStructurally(candidateAstNode = (AcceleoASTNode)candidate, astNode)) continue;
            return (T)candidateAstNode;
        }
        throw new IllegalArgumentException("Equivalent of Acceleo AcceleoASTNode \"" + astNode.toString() + "\" could not be found in Acceleo AST: " + inAcceleoAstResult);
    }

    public static boolean isEqualStructurally(AcceleoASTNode left, AcceleoASTNode right) {
        return new EcoreUtil.EqualityHelper(){
            private static final long serialVersionUID = 1L;

            protected boolean haveEqualAttribute(EObject eObject1, EObject eObject2, EAttribute attribute) {
                boolean result;
                if (attribute.getEAttributeType().equals(AcceleoPackage.eINSTANCE.getASTResult())) {
                    AstResult value1 = (AstResult)eObject1.eGet((EStructuralFeature)attribute);
                    AstResult value2 = (AstResult)eObject2.eGet((EStructuralFeature)attribute);
                    result = this.equals((EObject)value1.getAst(), (EObject)value2.getAst());
                } else if (attribute.getEAttributeType().equals(AcceleoPackage.eINSTANCE.getAcceleoAstResult())) {
                    AcceleoAstResult value1 = (AcceleoAstResult)eObject1.eGet((EStructuralFeature)attribute);
                    AcceleoAstResult value2 = (AcceleoAstResult)eObject2.eGet((EStructuralFeature)attribute);
                    result = this.equals(value1.getModule(), value2.getModule());
                } else {
                    result = super.haveEqualAttribute(eObject1, eObject2, attribute);
                }
                return result;
            }
        }.equals((EObject)left, (EObject)right);
    }

    public static boolean isEqualStructurally(EObject left, EObject right) {
        return new EcoreUtil.EqualityHelper(){
            private static final long serialVersionUID = 1L;

            protected boolean haveEqualAttribute(EObject eObject1, EObject eObject2, EAttribute attribute) {
                return super.haveEqualAttribute(eObject1, eObject2, attribute);
            }
        }.equals(left, right);
    }
}

