/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.aql.parser;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.acceleo.Import;
import org.eclipse.acceleo.Module;
import org.eclipse.acceleo.ModuleElement;
import org.eclipse.acceleo.ModuleReference;
import org.eclipse.acceleo.Query;
import org.eclipse.acceleo.Template;
import org.eclipse.acceleo.aql.evaluation.AcceleoEvaluator;
import org.eclipse.acceleo.aql.evaluation.QueryService;
import org.eclipse.acceleo.aql.evaluation.TemplateService;
import org.eclipse.acceleo.aql.parser.AcceleoParser;
import org.eclipse.acceleo.query.runtime.IService;
import org.eclipse.acceleo.query.runtime.impl.namespace.AbstractLoader;
import org.eclipse.acceleo.query.runtime.namespace.IQualifiedNameLookupEngine;
import org.eclipse.acceleo.query.runtime.namespace.IQualifiedNameResolver;

public class ModuleLoader
extends AbstractLoader {
    private final AcceleoEvaluator evaluator;
    private AcceleoParser parser;

    public ModuleLoader(AcceleoParser parser, AcceleoEvaluator evaluator) {
        super("::", "mtl", "mtl");
        this.parser = parser;
        this.evaluator = evaluator;
    }

    public Object load(IQualifiedNameResolver resolver, String qualifiedName) {
        Module res;
        try {
            Throwable throwable = null;
            Object var5_6 = null;
            try (InputStream is = resolver.getInputStream(this.resourceName(qualifiedName));){
                res = is != null ? this.parser.parse(is, StandardCharsets.UTF_8, qualifiedName).getModule() : null;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            res = null;
        }
        return res;
    }

    public boolean canHandle(Object object) {
        return object instanceof Module;
    }

    public Set<IService<?>> getServices(IQualifiedNameLookupEngine lookupEngine, Object object, String contextQualifiedName) {
        LinkedHashSet res = new LinkedHashSet();
        Module module = (Module)object;
        for (ModuleElement element : module.getModuleElements()) {
            if (element instanceof Template) {
                res.add((IService<?>)new TemplateService((Template)element, this.evaluator, lookupEngine, contextQualifiedName));
                continue;
            }
            if (!(element instanceof Query)) continue;
            res.add((IService<?>)new QueryService((Query)element, this.evaluator, lookupEngine, contextQualifiedName));
        }
        return res;
    }

    public List<String> getImports(Object object) {
        ArrayList<String> res = new ArrayList<String>();
        Module module = (Module)object;
        for (Import imp : module.getImports()) {
            ModuleReference moduleRef = imp.getModule();
            if (moduleRef == null || moduleRef.getQualifiedName() == null) continue;
            res.add(moduleRef.getQualifiedName());
        }
        return res;
    }

    public String getExtends(Object object) {
        Module module = (Module)object;
        ModuleReference ext = module.getExtends();
        String res = ext != null ? ext.getQualifiedName() : null;
        return res;
    }
}

