/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.aql.evaluation.writer;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.acceleo.OpenModeKind;
import org.eclipse.acceleo.aql.evaluation.writer.AcceleoFileWriter;
import org.eclipse.acceleo.aql.evaluation.writer.IAcceleoGenerationStrategy;
import org.eclipse.acceleo.aql.evaluation.writer.IAcceleoWriter;
import org.eclipse.acceleo.aql.evaluation.writer.NullWriter;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.URIConverter;

public class DefaultGenerationStrategy
implements IAcceleoGenerationStrategy {
    private static final Map<String, Object> EMPTY_OPTION_MAP = new HashMap<String, Object>();
    protected final Map<URI, Map<String, String>> protectedAreaContents = new LinkedHashMap<URI, Map<String, String>>();
    protected final URIConverter uriConverter = URIConverter.INSTANCE;

    @Override
    public void closeWriter(IAcceleoWriter writer) throws IOException {
        writer.close();
    }

    @Override
    public String getProtectedAreaContent(URI uri, String protectedAreaID) {
        return null;
    }

    @Override
    public IAcceleoWriter createWriterFor(URI uri, OpenModeKind openMode, Charset charset, String lineDelimiter) throws IOException {
        IAcceleoWriter writer;
        boolean exists = this.uriConverter.exists(uri, EMPTY_OPTION_MAP);
        switch (openMode) {
            case CREATE: {
                if (exists) {
                    writer = new NullWriter(uri);
                    break;
                }
            }
            case OVERWRITE: {
                if (exists) {
                    Throwable throwable = null;
                    Object var8_9 = null;
                    try (InputStream input = this.uriConverter.createInputStream(uri);){
                        Map<String, String> protectedAreas = this.readProtectedAreaContent(new InputStreamReader(input), lineDelimiter);
                        if (protectedAreas != null && !protectedAreas.isEmpty()) {
                            this.protectedAreaContents.put(uri, protectedAreas);
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                writer = new AcceleoFileWriter(uri, this.uriConverter, charset);
                break;
            }
            default: {
                writer = new NullWriter(uri);
            }
        }
        return writer;
    }

    @Override
    public void terminate() {
    }

    protected Map<String, String> readProtectedAreaContent(Reader reader, String lineDelimiter) throws IOException {
        LinkedHashMap<String, String> protectedAreas = new LinkedHashMap<String, String>();
        BufferedReader localReader = new BufferedReader(reader);
        String line = localReader.readLine();
        while (line != null) {
            int start = line.indexOf(USER_CODE_START);
            if (start >= 0) {
                String marker = line.substring(start + USER_CODE_START.length()).trim();
                StringBuffer areaContent = new StringBuffer(1024);
                areaContent.append(line.substring(start));
                line = localReader.readLine();
                while (line != null) {
                    int end = line.indexOf(USER_CODE_END);
                    if (end >= 0) {
                        int endOffset = end + USER_CODE_END.length();
                        areaContent.append(line.substring(0, endOffset));
                        break;
                    }
                    areaContent.append(line);
                    areaContent.append(lineDelimiter);
                }
                protectedAreas.put(marker, areaContent.toString());
            }
            line = localReader.readLine();
        }
        return protectedAreas;
    }
}

