/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.aql.ide;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.acceleo.Module;
import org.eclipse.acceleo.ModuleElement;
import org.eclipse.acceleo.Template;
import org.eclipse.acceleo.aql.ide.resolver.EclipseQualifiedNameResolver;
import org.eclipse.acceleo.aql.ide.resolver.IResolverFactoryDescriptor;
import org.eclipse.acceleo.aql.ide.resolver.ResolverFactoryRegistryListener;
import org.eclipse.acceleo.aql.parser.AcceleoParser;
import org.eclipse.acceleo.aql.resolver.IQualifiedNameResolver;
import org.eclipse.acceleo.query.runtime.IReadOnlyQueryEnvironment;
import org.eclipse.acceleo.query.runtime.Query;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryEventListener;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.util.ResourceLocator;
import org.osgi.framework.BundleContext;

public class Activator
extends EMFPlugin {
    public static final String PLUGIN_ID = "org.eclipse.acceleo.aql.ide";
    public static final Activator INSTANCE = new Activator();
    private static Implementation plugin;
    private static final List<IResolverFactoryDescriptor> RESOLVER_FACTORY_DESCRIPTORS;

    static {
        RESOLVER_FACTORY_DESCRIPTORS = new ArrayList<IResolverFactoryDescriptor>();
    }

    public Activator() {
        super(new ResourceLocator[0]);
    }

    public ResourceLocator getPluginResourceLocator() {
        return plugin;
    }

    public static Implementation getPlugin() {
        return plugin;
    }

    public static Activator getDefault() {
        return INSTANCE;
    }

    public static void log(Exception exception, boolean blocker) {
        int severity = 2;
        if (blocker) {
            severity = 4;
        }
        INSTANCE.log(new Status(severity, PLUGIN_ID, exception.getMessage(), (Throwable)exception));
    }

    public static void log(String message, boolean blocker) {
        String errorMessage;
        int severity = 2;
        if (blocker) {
            severity = 4;
        }
        if ((errorMessage = message) == null || "".equals(errorMessage)) {
            errorMessage = "Logging null message should never happens.";
        }
        INSTANCE.log(new Status(severity, PLUGIN_ID, errorMessage));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerResolverFactory(IResolverFactoryDescriptor descriptor) {
        if (descriptor != null) {
            List<IResolverFactoryDescriptor> list = RESOLVER_FACTORY_DESCRIPTORS;
            synchronized (list) {
                RESOLVER_FACTORY_DESCRIPTORS.add(descriptor);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregisterResolverFactory(IResolverFactoryDescriptor descriptor) {
        if (descriptor != null) {
            List<IResolverFactoryDescriptor> list = RESOLVER_FACTORY_DESCRIPTORS;
            synchronized (list) {
                RESOLVER_FACTORY_DESCRIPTORS.remove(descriptor);
            }
        }
    }

    public static boolean isAcceleoMain(IResource resource) {
        boolean res = false;
        AcceleoParser parser = new AcceleoParser((IReadOnlyQueryEnvironment)Query.newEnvironment());
        IFile file = (IFile)resource;
        try {
            Throwable throwable = null;
            Object var5_8 = null;
            try (InputStream contents = file.getContents();){
                Module module = parser.parse(contents, Charset.forName(file.getCharset()), "none").getModule();
                for (ModuleElement element : module.getModuleElements()) {
                    if (!(element instanceof Template) || !((Template)element).isMain()) continue;
                    res = true;
                    break;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            Activator.getPlugin().log(new Status(4, PLUGIN_ID, "couldn't parse module " + resource.getFullPath(), (Throwable)e));
        }
        catch (CoreException e) {
            Activator.getPlugin().log(new Status(4, PLUGIN_ID, "couldn't parse module " + resource.getFullPath(), (Throwable)e));
        }
        return res;
    }

    public static class Implementation
    extends EMFPlugin.EclipsePlugin {
        private final ResolverFactoryRegistryListener resolverFactoryListener = new ResolverFactoryRegistryListener();

        public Implementation() {
            plugin = this;
        }

        public void start(BundleContext context) throws Exception {
            super.start(context);
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            registry.addListener((IRegistryEventListener)this.resolverFactoryListener, "org.eclipse.acceleo.aql.ide.resolverfactory");
            this.resolverFactoryListener.parseInitialContributions();
        }

        public void stop(BundleContext context) throws Exception {
            super.stop(context);
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            registry.removeListener((IRegistryEventListener)this.resolverFactoryListener);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IQualifiedNameResolver createQualifiedNameResolver(IReadOnlyQueryEnvironment queryEnvironment, IProject project) {
            ArrayList factoryDescriptors;
            List list = RESOLVER_FACTORY_DESCRIPTORS;
            synchronized (list) {
                factoryDescriptors = new ArrayList(RESOLVER_FACTORY_DESCRIPTORS);
            }
            EclipseQualifiedNameResolver res = factoryDescriptors.isEmpty() ? new EclipseQualifiedNameResolver(((Object)((Object)this)).getClass().getClassLoader(), queryEnvironment, project) : ((IResolverFactoryDescriptor)factoryDescriptors.get(0)).getFactory().createResolver(queryEnvironment, project);
            return res;
        }
    }
}

