/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.aql.location.aql;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.eclipse.acceleo.query.validation.type.IType;

public class AqlVariablesLocalContext {
    private final Map<String, Object> variableDefinitions = new HashMap<String, Object>();
    private final Map<String, Set<IType>> variableTypes = new HashMap<String, Set<IType>>();

    public AqlVariablesLocalContext addVariable(String variableName, Object variableDefinition, Set<IType> variablePossibleTypes) {
        Objects.requireNonNull(variableName);
        Objects.requireNonNull(variableDefinition);
        Objects.requireNonNull(variablePossibleTypes);
        this.variableDefinitions.put(variableName, variableDefinition);
        this.variableTypes.put(variableName, variablePossibleTypes);
        return this;
    }

    public AqlVariablesLocalContext addAllVariables(AqlVariablesLocalContext contextToAdd) {
        Objects.requireNonNull(contextToAdd);
        for (String variableNameToAdd : contextToAdd.getVariableNames()) {
            Object variableDefinitionToAdd = contextToAdd.getVariableDefinitions().get(variableNameToAdd);
            Set<IType> variableTypesToAdd = contextToAdd.getVariableTypes().get(variableNameToAdd);
            this.addVariable(variableNameToAdd, variableDefinitionToAdd, variableTypesToAdd);
        }
        return this;
    }

    public Set<String> getVariableNames() {
        return this.variableDefinitions.keySet();
    }

    public Map<String, Object> getVariableDefinitions() {
        return Collections.unmodifiableMap(this.variableDefinitions);
    }

    public Map<String, Set<IType>> getVariableTypes() {
        return Collections.unmodifiableMap(this.variableTypes);
    }
}

