/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.aql.location.aql;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.acceleo.aql.location.aql.AqlLocationLinkToAny;
import org.eclipse.acceleo.aql.location.aql.AqlLocationLinkToAql;
import org.eclipse.acceleo.aql.location.aql.AqlVariablesLocalContext;
import org.eclipse.acceleo.aql.location.common.AbstractLocationLink;
import org.eclipse.acceleo.aql.parser.AcceleoAstUtils;
import org.eclipse.acceleo.query.ast.Call;
import org.eclipse.acceleo.query.ast.EnumLiteral;
import org.eclipse.acceleo.query.ast.Error;
import org.eclipse.acceleo.query.ast.Expression;
import org.eclipse.acceleo.query.ast.Literal;
import org.eclipse.acceleo.query.ast.TypeLiteral;
import org.eclipse.acceleo.query.ast.VariableDeclaration;
import org.eclipse.acceleo.query.ast.util.AstSwitch;
import org.eclipse.acceleo.query.parser.AstEvaluator;
import org.eclipse.acceleo.query.parser.AstResult;
import org.eclipse.acceleo.query.parser.AstValidator;
import org.eclipse.acceleo.query.parser.CombineIterator;
import org.eclipse.acceleo.query.runtime.EvaluationResult;
import org.eclipse.acceleo.query.runtime.IQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IReadOnlyQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IService;
import org.eclipse.acceleo.query.runtime.IValidationResult;
import org.eclipse.acceleo.query.runtime.impl.EvaluationServices;
import org.eclipse.acceleo.query.runtime.impl.Nothing;
import org.eclipse.acceleo.query.runtime.impl.ValidationServices;
import org.eclipse.acceleo.query.validation.type.IType;
import org.eclipse.emf.ecore.EObject;

public class AqlDefinitionLocator
extends AstSwitch<List<AbstractLocationLink<?, ?>>> {
    private final IQueryEnvironment queryEnvironment;
    private final EvaluationServices aqlEvaluationServices;
    private final AstEvaluator aqlEvaluator;
    private final AstValidator aqlValidator;
    private final AqlVariablesLocalContext aqlVariablesContext;
    private final AstResult aqlAstResult;

    public AqlDefinitionLocator(IQueryEnvironment queryEnvironment, AstResult aqlAstResult, AqlVariablesLocalContext aqlVariablesContext) {
        this.queryEnvironment = Objects.requireNonNull(queryEnvironment);
        this.aqlAstResult = Objects.requireNonNull(aqlAstResult);
        this.aqlEvaluationServices = new EvaluationServices((IReadOnlyQueryEnvironment)this.queryEnvironment);
        this.aqlEvaluator = new AstEvaluator(this.aqlEvaluationServices);
        this.aqlVariablesContext = Objects.requireNonNull(aqlVariablesContext);
        this.aqlValidator = new AstValidator(new ValidationServices((IReadOnlyQueryEnvironment)this.queryEnvironment));
    }

    public List<AbstractLocationLink<?, ?>> caseVariableDeclaration(VariableDeclaration variableDeclaration) {
        return Collections.singletonList(new AqlLocationLinkToAql((EObject)variableDeclaration, (EObject)variableDeclaration));
    }

    public List<AbstractLocationLink<?, ?>> caseExpression(Expression expression) {
        EvaluationResult evaluationResult = this.aqlEvaluator.eval(this.aqlVariablesContext.getVariableDefinitions(), expression);
        Object expressionDefiningElement = evaluationResult.getResult();
        if (expressionDefiningElement == null || expressionDefiningElement instanceof Nothing) {
            return new ArrayList();
        }
        return Collections.singletonList(new AqlLocationLinkToAny((EObject)expression, expressionDefiningElement));
    }

    public List<AbstractLocationLink<?, ?>> caseLiteral(Literal literal) {
        return new ArrayList();
    }

    public List<AbstractLocationLink<?, ?>> caseTypeLiteral(TypeLiteral typeLiteral) {
        return Collections.singletonList(new AqlLocationLinkToAny((EObject)typeLiteral, typeLiteral.getValue()));
    }

    public List<AbstractLocationLink<?, ?>> caseEnumLiteral(EnumLiteral enumLiteral) {
        return Collections.singletonList(new AqlLocationLinkToAny((EObject)enumLiteral, enumLiteral.getLiteral()));
    }

    public List<AbstractLocationLink<?, ?>> caseCall(Call call) {
        this.aqlValidator.validate(this.aqlVariablesContext.getVariableTypes(), this.aqlAstResult);
        ArrayList<IService> candidateServices = new ArrayList<IService>();
        String serviceName = call.getServiceName();
        List argumentTypes = call.getArguments().stream().map(argument -> {
            AstResult aqlAstOfArgument = AcceleoAstUtils.getAqlAstResultOfAqlAstElement((EObject)argument);
            IValidationResult aqlValidationResultOfArgument = this.aqlValidator.validate(this.aqlVariablesContext.getVariableTypes(), aqlAstOfArgument);
            Set argumentPossibleTypes = aqlValidationResultOfArgument.getPossibleTypes(argument);
            return argumentPossibleTypes;
        }).collect(Collectors.toList());
        CombineIterator it = new CombineIterator(argumentTypes);
        while (it.hasNext()) {
            List currentArgTypes = it.next();
            IService service2 = this.queryEnvironment.getLookupEngine().lookup(serviceName, currentArgTypes.toArray(new IType[currentArgTypes.size()]));
            if (service2 == null) continue;
            candidateServices.add(service2);
        }
        return candidateServices.stream().map(service -> new AqlLocationLinkToAny((EObject)call, service.getOrigin())).collect(Collectors.toList());
    }

    public List<AbstractLocationLink<?, ?>> caseError(Error object) {
        return new ArrayList();
    }
}

