/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.tests.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.eclipse.acceleo.Module;
import org.eclipse.acceleo.aql.AcceleoUtil;
import org.eclipse.acceleo.aql.evaluation.AcceleoEvaluator;
import org.eclipse.acceleo.aql.evaluation.GenerationResult;
import org.eclipse.acceleo.aql.evaluation.strategy.DefaultGenerationStrategy;
import org.eclipse.acceleo.aql.evaluation.strategy.DefaultWriterFactory;
import org.eclipse.acceleo.aql.evaluation.strategy.IAcceleoGenerationStrategy;
import org.eclipse.acceleo.aql.evaluation.strategy.IWriterFactory;
import org.eclipse.acceleo.query.runtime.namespace.IQualifiedNameQueryEnvironment;
import org.eclipse.acceleo.tests.utils.AbstractLanguageTestSuite;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.junit.Assert;
import org.junit.Test;

public abstract class AbstractEvaluationTestSuite
extends AbstractLanguageTestSuite {
    private static final String ACTUAL_SUFFIT = "-actual.txt";
    private static final String EXPECTED_SUFFIX = "-expected.txt";
    private static final String PROTECTED_AREA_SUFFIX = "-protectedArea.txt";
    private final Resource model;

    protected AbstractEvaluationTestSuite(String testFolder) throws IOException {
        super(testFolder);
        File modelFile = this.getModelFile(new File(this.getTestFolderPath()));
        this.model = this.getModel(modelFile, resourceSetForModels);
    }

    protected Resource getModel(File modelFile, ResourceSet rs) {
        URI modelURI = URI.createFileURI((String)modelFile.getAbsolutePath());
        Resource res = rs.getURIConverter().exists(modelURI, null) ? rs.getResource(modelURI, true) : null;
        return res;
    }

    @Test
    public void evaluation() throws IOException {
        Module module = this.astResult.getModule();
        URI generatedFolderURI = URI.createURI((String)"generated/").resolve(this.model.getURI());
        URI protectedAreaFolderURI = URI.createURI((String)"protected-area/").resolve(this.model.getURI());
        for (URI protectedAreaURI : this.getProtectedAreaFiles(protectedAreaFolderURI)) {
            URI relativeURI = protectedAreaURI.deresolve(protectedAreaFolderURI);
            URI destinationURI = URI.createURI((String)relativeURI.resolve(this.memoryDestination).toString().replaceAll(PROTECTED_AREA_SUFFIX, ""));
            AbstractEvaluationTestSuite.copy(resourceSetForModels.getURIConverter(), protectedAreaURI, destinationURI);
        }
        List<URI> expectedGeneratedFiles = this.getExpectedGeneratedFiles(generatedFolderURI);
        ArrayList<URI> unexpectedGeneratedFiles = new ArrayList<URI>();
        DefaultGenerationStrategy strategy = new DefaultGenerationStrategy(this.model.getResourceSet().getURIConverter(), (IWriterFactory)new DefaultWriterFactory());
        AcceleoUtil.generate((AcceleoEvaluator)this.evaluator, (IQualifiedNameQueryEnvironment)queryEnvironment, (Module)module, (Resource)this.model, (IAcceleoGenerationStrategy)strategy, (URI)this.memoryDestination, null);
        this.assertGenerationMessages(this.evaluator.getGenerationResult());
        GenerationResult result = this.evaluator.getGenerationResult();
        ArrayList generatedAndLost = new ArrayList();
        generatedAndLost.addAll(result.getGeneratedFiles());
        generatedAndLost.addAll(result.getLostFiles());
        for (URI memoryGeneratedURI : generatedAndLost) {
            URI generatedURI = URI.createURI((String)memoryGeneratedURI.toString().substring(this.memoryDestinationString.length())).resolve(generatedFolderURI);
            URI expectedURI = URI.createURI((String)(generatedURI.toString() + EXPECTED_SUFFIX));
            expectedGeneratedFiles.remove(expectedURI);
            URI actualURI = URI.createURI((String)(generatedURI.toString() + ACTUAL_SUFFIT));
            if (resourceSetForModels.getURIConverter().exists(expectedURI, null)) {
                String actualContent;
                String expectedContent;
                Throwable throwable = null;
                Throwable throwable2 = null;
                try (InputStream expectedStream = resourceSetForModels.getURIConverter().createInputStream(expectedURI);){
                    expectedContent = AcceleoUtil.getContent((InputStream)expectedStream, (String)"UTF-8");
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                    } else if (throwable != throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    throw throwable;
                }
                throwable2 = null;
                Object var17_20 = null;
                try (InputStream actualStream = resourceSetForModels.getURIConverter().createInputStream(memoryGeneratedURI);){
                    actualContent = AcceleoUtil.getContent((InputStream)actualStream, (String)"UTF-8");
                }
                catch (Throwable throwable4) {
                    if (throwable2 == null) {
                        throwable2 = throwable4;
                    } else if (throwable2 != throwable4) {
                        throwable2.addSuppressed(throwable4);
                    }
                    throw throwable2;
                }
                Assert.assertEquals((Object)this.getPortableString(expectedContent), (Object)this.getPortableString(actualContent));
                continue;
            }
            AbstractEvaluationTestSuite.copy(resourceSetForModels.getURIConverter(), memoryGeneratedURI, actualURI);
            unexpectedGeneratedFiles.add(actualURI);
        }
        if (!unexpectedGeneratedFiles.isEmpty()) {
            Assert.fail((String)("unexpected generated file: " + Arrays.deepToString(unexpectedGeneratedFiles.toArray())));
        }
        if (!expectedGeneratedFiles.isEmpty()) {
            Assert.fail((String)("expected generated file are missing: " + Arrays.deepToString(expectedGeneratedFiles.toArray(new URI[expectedGeneratedFiles.size()]))));
        }
    }

    @Test
    public void evaluationWindowsEndLine() throws IOException {
        Module module = this.astResultWindowsEndLine.getModule();
        URI generatedFolderURI = URI.createURI((String)"generated/").resolve(this.model.getURI());
        URI protectedAreaFolderURI = URI.createURI((String)"protected-area/").resolve(this.model.getURI());
        for (URI protectedAreaURI : this.getProtectedAreaFiles(protectedAreaFolderURI)) {
            URI relativeURI = protectedAreaURI.deresolve(protectedAreaFolderURI);
            URI destinationURI = URI.createURI((String)relativeURI.resolve(this.memoryDestination).toString().replaceAll(PROTECTED_AREA_SUFFIX, ""));
            AbstractEvaluationTestSuite.copy(resourceSetForModels.getURIConverter(), protectedAreaURI, destinationURI);
        }
        List<URI> expectedGeneratedFiles = this.getExpectedGeneratedFiles(generatedFolderURI);
        ArrayList<URI> unexpectedGeneratedFiles = new ArrayList<URI>();
        DefaultGenerationStrategy strategy = new DefaultGenerationStrategy(this.model.getResourceSet().getURIConverter(), (IWriterFactory)new DefaultWriterFactory());
        AcceleoUtil.generate((AcceleoEvaluator)this.evaluatorWindowsEndLine, (IQualifiedNameQueryEnvironment)queryEnvironmentWindowsEndLine, (Module)module, (Resource)this.model, (IAcceleoGenerationStrategy)strategy, (URI)this.memoryDestination, null);
        this.assertGenerationMessagesWindowsEndLine(this.evaluatorWindowsEndLine.getGenerationResult());
        GenerationResult result = this.evaluatorWindowsEndLine.getGenerationResult();
        ArrayList generatedAndLost = new ArrayList();
        generatedAndLost.addAll(result.getGeneratedFiles());
        generatedAndLost.addAll(result.getLostFiles());
        for (URI memoryGeneratedURI : generatedAndLost) {
            URI generatedURI = URI.createURI((String)memoryGeneratedURI.toString().substring(this.memoryDestinationString.length())).resolve(generatedFolderURI);
            URI expectedURI = URI.createURI((String)(generatedURI.toString() + EXPECTED_SUFFIX));
            expectedGeneratedFiles.remove(expectedURI);
            URI actualURI = URI.createURI((String)(generatedURI.toString() + ACTUAL_SUFFIT));
            if (resourceSetForModels.getURIConverter().exists(expectedURI, null)) {
                String actualContent;
                String expectedContent;
                Throwable throwable = null;
                Throwable throwable2 = null;
                try (InputStream expectedStream = resourceSetForModels.getURIConverter().createInputStream(expectedURI);){
                    expectedContent = AcceleoUtil.getContent((InputStream)expectedStream, (String)"UTF-8");
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                    } else if (throwable != throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    throw throwable;
                }
                throwable2 = null;
                Object var17_20 = null;
                try (InputStream actualStream = resourceSetForModels.getURIConverter().createInputStream(memoryGeneratedURI);){
                    actualContent = AcceleoUtil.getContent((InputStream)actualStream, (String)"UTF-8");
                }
                catch (Throwable throwable4) {
                    if (throwable2 == null) {
                        throwable2 = throwable4;
                    } else if (throwable2 != throwable4) {
                        throwable2.addSuppressed(throwable4);
                    }
                    throw throwable2;
                }
                Assert.assertEquals((Object)this.getPortableString(expectedContent), (Object)this.getPortableString(actualContent));
                continue;
            }
            AbstractEvaluationTestSuite.copy(resourceSetForModels.getURIConverter(), memoryGeneratedURI, actualURI);
            unexpectedGeneratedFiles.add(actualURI);
        }
        if (!unexpectedGeneratedFiles.isEmpty()) {
            Assert.fail((String)("unexpected generated file: " + Arrays.deepToString(unexpectedGeneratedFiles.toArray())));
        }
        if (!expectedGeneratedFiles.isEmpty()) {
            Assert.fail((String)("expected generated file are missing: " + Arrays.deepToString(expectedGeneratedFiles.toArray(new URI[expectedGeneratedFiles.size()]))));
        }
    }

    private List<URI> getExpectedGeneratedFiles(URI generatedFolderURI) {
        ArrayList<URI> res = new ArrayList<URI>();
        File generatedFolder = new File(generatedFolderURI.toFileString());
        String[] expectedFileNames = generatedFolder.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(AbstractEvaluationTestSuite.EXPECTED_SUFFIX);
            }
        });
        if (expectedFileNames != null) {
            String[] stringArray = expectedFileNames;
            int n = expectedFileNames.length;
            int n2 = 0;
            while (n2 < n) {
                String expectedFileName = stringArray[n2];
                res.add(URI.createURI((String)expectedFileName).resolve(generatedFolderURI));
                ++n2;
            }
        }
        return res;
    }

    private List<URI> getProtectedAreaFiles(URI protectedAreaFolderURI) {
        ArrayList<URI> res = new ArrayList<URI>();
        File generatedFolder = new File(protectedAreaFolderURI.toFileString());
        String[] expectedFileNames = generatedFolder.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(AbstractEvaluationTestSuite.PROTECTED_AREA_SUFFIX);
            }
        });
        if (expectedFileNames != null) {
            String[] stringArray = expectedFileNames;
            int n = expectedFileNames.length;
            int n2 = 0;
            while (n2 < n) {
                String expectedFileName = stringArray[n2];
                res.add(URI.createURI((String)expectedFileName).resolve(protectedAreaFolderURI));
                ++n2;
            }
        }
        return res;
    }

    private void assertGenerationMessages(GenerationResult generationResult) throws IOException {
        String actualContent = this.getRuntimeMessages(generationResult.getDiagnostic());
        File expectedFile = this.getExpectedRuntimeMessageFile(new File(this.getTestFolderPath()));
        File actualFile = this.getActualRuntimeMessageFile(new File(this.getTestFolderPath()));
        if (!expectedFile.exists()) {
            if (!actualFile.exists() && !expectedFile.exists()) {
                actualFile.createNewFile();
            }
            Throwable throwable = null;
            Object var6_8 = null;
            try (FileOutputStream stream = new FileOutputStream(actualFile);){
                AbstractEvaluationTestSuite.setContent(stream, "UTF-8", actualContent);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            Assert.fail((String)"file doesn't exist.");
        } else {
            String expectedContent = "";
            Throwable throwable = null;
            Object var7_13 = null;
            try (FileInputStream stream = new FileInputStream(expectedFile);){
                expectedContent = AcceleoUtil.getContent((InputStream)stream, (String)"UTF-8");
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
            Assert.assertEquals((Object)expectedContent, (Object)actualContent);
        }
    }

    protected File getExpectedRuntimeMessageFile(File testFolder) {
        return new File(String.valueOf(testFolder) + File.separator + testFolder.getName() + "-expected-runtimeMessages.txt");
    }

    protected File getActualRuntimeMessageFile(File testFolder) {
        return new File(String.valueOf(testFolder) + File.separator + testFolder.getName() + "-actual-runtimeMessages.txt");
    }

    private void assertGenerationMessagesWindowsEndLine(GenerationResult generationResult) throws IOException {
        String actualContent = this.getRuntimeMessages(generationResult.getDiagnostic());
        File expectedFile = this.getExpectedRuntimeMessageFileWindowsEndLine(new File(this.getTestFolderPath()));
        File actualFile = this.getActualRuntimeMessageFileWindowsEndLine(new File(this.getTestFolderPath()));
        if (!expectedFile.exists()) {
            if (!actualFile.exists() && !expectedFile.exists()) {
                actualFile.createNewFile();
            }
            Throwable throwable = null;
            Object var6_8 = null;
            try (FileOutputStream stream = new FileOutputStream(actualFile);){
                AbstractEvaluationTestSuite.setContent(stream, "UTF-8", actualContent);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            Assert.fail((String)"file doesn't exist.");
        } else {
            String expectedContent = "";
            Throwable throwable = null;
            Object var7_13 = null;
            try (FileInputStream stream = new FileInputStream(expectedFile);){
                expectedContent = AcceleoUtil.getContent((InputStream)stream, (String)"UTF-8");
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
            Assert.assertEquals((Object)expectedContent, (Object)actualContent);
        }
    }

    protected File getExpectedRuntimeMessageFileWindowsEndLine(File testFolder) {
        return new File(String.valueOf(testFolder) + File.separator + testFolder.getName() + "-WindowsEndLine-expected-runtimeMessages.txt");
    }

    protected File getActualRuntimeMessageFileWindowsEndLine(File testFolder) {
        return new File(String.valueOf(testFolder) + File.separator + testFolder.getName() + "-WindowsEndLine-actual-runtimeMessages.txt");
    }

    private String getRuntimeMessages(Diagnostic diagnostic) {
        StringBuilder builder = new StringBuilder();
        this.walkDiagnostic(builder, "", diagnostic);
        return this.getPortableString(builder.toString());
    }

    private void walkDiagnostic(StringBuilder builder, String prefix, Diagnostic diagnostic) {
        builder.append(prefix + " (" + diagnostic.getSource() + " " + diagnostic.getCode() + " " + diagnostic.getSeverity() + ") " + diagnostic.getMessage() + "[" + this.getDataString(diagnostic.getData()) + "]\n");
        for (Diagnostic child : diagnostic.getChildren()) {
            this.walkDiagnostic(builder, prefix + "  ", child);
        }
    }

    private String getDataString(List<?> data) {
        StringBuilder builder = new StringBuilder();
        if (data != null) {
            for (Object datum : data) {
                if (datum instanceof Map) {
                    builder.append("[");
                    for (Map.Entry entry : ((Map)datum).entrySet()) {
                        builder.append("(" + String.valueOf(entry.getKey()) + ", " + String.valueOf(entry.getValue()) + "), ");
                    }
                    builder.append("]");
                    continue;
                }
                if (datum != null) {
                    builder.append(datum.toString());
                    continue;
                }
                builder.append("null");
            }
        }
        return builder.toString();
    }
}

