/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.tests;

import java.io.Serializable;
import java.util.Iterator;
import org.eclipse.acceleo.query.tests.qmodel.BooleanResult;
import org.eclipse.acceleo.query.tests.qmodel.EObjectResult;
import org.eclipse.acceleo.query.tests.qmodel.EObjectVariable;
import org.eclipse.acceleo.query.tests.qmodel.EmptyResult;
import org.eclipse.acceleo.query.tests.qmodel.EnumeratorResult;
import org.eclipse.acceleo.query.tests.qmodel.ErrorResult;
import org.eclipse.acceleo.query.tests.qmodel.IntegerResult;
import org.eclipse.acceleo.query.tests.qmodel.InvalidResult;
import org.eclipse.acceleo.query.tests.qmodel.ListResult;
import org.eclipse.acceleo.query.tests.qmodel.Query;
import org.eclipse.acceleo.query.tests.qmodel.QueryEvaluationResult;
import org.eclipse.acceleo.query.tests.qmodel.QueryValidationResult;
import org.eclipse.acceleo.query.tests.qmodel.SerializableResult;
import org.eclipse.acceleo.query.tests.qmodel.SetResult;
import org.eclipse.acceleo.query.tests.qmodel.StringResult;
import org.eclipse.acceleo.query.tests.qmodel.ValidationMessage;
import org.eclipse.acceleo.query.tests.qmodel.Variable;
import org.eclipse.emf.ecore.EObject;
import org.junit.Assert;

public class QueryResultAssert {
    public static void assertEquivalentEvaluation(QueryEvaluationResult expectedResult, QueryEvaluationResult actualResult) {
        Assert.assertSame((Object)expectedResult.eClass().getName(), (Object)actualResult.eClass().getName());
        if (expectedResult instanceof ListResult) {
            Assert.assertTrue((boolean)(actualResult instanceof ListResult));
            Assert.assertEquals((long)((ListResult)expectedResult).getValues().size(), (long)((ListResult)actualResult).getValues().size());
            Iterator expectedIt = ((ListResult)expectedResult).getValues().iterator();
            Iterator actualIt = ((ListResult)actualResult).getValues().iterator();
            while (expectedIt.hasNext()) {
                QueryResultAssert.assertEquivalentEvaluation((QueryEvaluationResult)expectedIt.next(), (QueryEvaluationResult)actualIt.next());
            }
        } else if (expectedResult instanceof SetResult) {
            Assert.assertTrue((boolean)(actualResult instanceof SetResult));
            Assert.assertEquals((long)((SetResult)expectedResult).getValues().size(), (long)((SetResult)actualResult).getValues().size());
            Iterator expectedIt = ((SetResult)expectedResult).getValues().iterator();
            Iterator actualIt = ((SetResult)actualResult).getValues().iterator();
            while (expectedIt.hasNext()) {
                QueryResultAssert.assertEquivalentEvaluation((QueryEvaluationResult)expectedIt.next(), (QueryEvaluationResult)actualIt.next());
            }
        } else if (expectedResult instanceof EObjectResult) {
            Assert.assertTrue((boolean)(actualResult instanceof EObjectResult));
            EObject expectedValue = ((EObjectResult)expectedResult).getValue();
            EObject actualValue = ((EObjectResult)actualResult).getValue();
            Assert.assertEquals((Object)expectedValue, (Object)actualValue);
        } else if (expectedResult instanceof StringResult) {
            Assert.assertTrue((boolean)(actualResult instanceof StringResult));
            String expectedValue = ((StringResult)expectedResult).getValue();
            String actualValue = ((StringResult)actualResult).getValue();
            Assert.assertEquals((Object)expectedValue, (Object)actualValue);
        } else if (expectedResult instanceof BooleanResult) {
            Assert.assertTrue((boolean)(actualResult instanceof BooleanResult));
            Boolean expectedValue = ((BooleanResult)expectedResult).isValue();
            Boolean actualValue = ((BooleanResult)actualResult).isValue();
            Assert.assertEquals((Object)expectedValue, (Object)actualValue);
        } else if (expectedResult instanceof InvalidResult) {
            Assert.assertTrue((boolean)(actualResult instanceof InvalidResult));
        } else if (!(expectedResult instanceof ErrorResult)) {
            if (expectedResult instanceof EmptyResult) {
                Assert.assertTrue((boolean)(actualResult instanceof EmptyResult));
            } else if (expectedResult instanceof EnumeratorResult) {
                Assert.assertTrue((boolean)(actualResult instanceof EnumeratorResult));
                String expectedValue = ((EnumeratorResult)expectedResult).getValue();
                String actualValue = ((EnumeratorResult)actualResult).getValue();
                Assert.assertEquals((Object)expectedValue, (Object)actualValue);
            } else if (expectedResult instanceof SerializableResult) {
                Assert.assertTrue((boolean)(actualResult instanceof SerializableResult));
                Serializable expectedValue = ((SerializableResult)expectedResult).getValue();
                Serializable actualValue = ((SerializableResult)actualResult).getValue();
                Assert.assertEquals((Object)expectedValue, (Object)actualValue);
            } else if (expectedResult instanceof IntegerResult) {
                Assert.assertTrue((boolean)(actualResult instanceof IntegerResult));
                Integer expectedValue = ((IntegerResult)expectedResult).getValue();
                Integer actualValue = ((IntegerResult)actualResult).getValue();
                Assert.assertEquals((Object)expectedValue, (Object)actualValue);
            } else {
                Assert.fail((String)("not supported yet in the test framework:" + expectedResult.eClass().getName()));
            }
        }
    }

    public static void assertEquivalentValidation(QueryValidationResult expectedResult, QueryValidationResult actualResult) {
        Assert.assertEquals((Object)expectedResult.getPossibleTypes(), (Object)actualResult.getPossibleTypes());
        Assert.assertEquals((long)expectedResult.getValidationMessages().size(), (long)actualResult.getValidationMessages().size());
        int i = 0;
        while (i < expectedResult.getValidationMessages().size()) {
            ValidationMessage expectedMessage = (ValidationMessage)expectedResult.getValidationMessages().get(i);
            ValidationMessage actualMessage = (ValidationMessage)actualResult.getValidationMessages().get(i);
            Assert.assertEquals((Object)expectedMessage.getSeverity(), (Object)actualMessage.getSeverity());
            Assert.assertEquals((long)expectedMessage.getStartPosition(), (long)actualMessage.getStartPosition());
            Assert.assertEquals((long)expectedMessage.getEndPosition(), (long)actualMessage.getEndPosition());
            Assert.assertEquals((Object)expectedMessage.getMessage(), (Object)actualMessage.getMessage());
            ++i;
        }
    }

    public static void printValidation(Query query, QueryValidationResult result) {
        System.out.println("Interpreter: " + result.getInterpreter());
        QueryResultAssert.printQuery(query);
        System.out.println("Possible types:");
        for (String possibleType : result.getPossibleTypes()) {
            System.out.println("\t" + possibleType);
        }
        System.out.println("Validation messages:");
        for (ValidationMessage message : result.getValidationMessages()) {
            System.out.println("\t" + String.valueOf(message.getSeverity()) + " " + message.getMessage());
        }
        System.out.flush();
    }

    private static void printQuery(Query query) {
        System.out.println("Expression: " + query.getExpression());
        System.out.println("Self: " + query.getStartingPoint().getName() + " - " + String.valueOf(query.getStartingPoint().getTarget()));
        for (Variable variable : query.getVariables()) {
            if (!(variable instanceof EObjectVariable)) continue;
            System.out.println(variable.getName() + ": " + String.valueOf(((EObjectVariable)variable).getValue().getTarget()));
        }
    }
}

