/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.common;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.acceleo.common.AcceleoCommonMessages;
import org.eclipse.acceleo.common.AcceleoLibraryConnectorsRegistry;
import org.eclipse.acceleo.common.internal.utils.AcceleoDynamicMetamodelResourceSetImpl;
import org.eclipse.acceleo.common.internal.utils.AcceleoLibrariesEclipseUtil;
import org.eclipse.acceleo.common.internal.utils.AcceleoLogger;
import org.eclipse.acceleo.common.internal.utils.AcceleoPackageRegistry;
import org.eclipse.acceleo.common.internal.utils.AcceleoServicesEclipseUtil;
import org.eclipse.acceleo.common.internal.utils.workspace.AcceleoModelManager;
import org.eclipse.acceleo.common.internal.utils.workspace.AcceleoWorkspaceUtil;
import org.eclipse.acceleo.common.library.connector.ILibrary;
import org.eclipse.acceleo.common.preference.AcceleoPreferences;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryEventListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.URI;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class AcceleoCommonPlugin
extends Plugin {
    public static final String LIBRARIES_EXTENSION_POINT = "org.eclipse.acceleo.common.libraries";
    public static final String LIBRARY_CONNECTORS_EXTENSION_POINT = "org.eclipse.acceleo.common.library.connectors";
    public static final String PLUGIN_ID = "org.eclipse.acceleo.common";
    @Deprecated
    public static final String SERVICES_EXTENSION_POINT = "org.eclipse.acceleo.common.java.services";
    private static final String CLASS_TAG_NAME = "class";
    private static final String FILE_EXTENSION_TAG_NAME = "fileExtension";
    private static final String FILE_TAG_NAME = "file";
    private static AcceleoCommonPlugin plugin;
    private BundleContext context;
    private final AcceleoLibraryConnectorsRegistryListener librariesConnectorListener = new AcceleoLibraryConnectorsRegistryListener();
    private final AcceleoLibrariesRegistryListener librariesListener = new AcceleoLibrariesRegistryListener();
    private final WorkspaceEcoreListener workspaceEcoreListener = new WorkspaceEcoreListener();

    public AcceleoCommonPlugin() {
        plugin = this;
    }

    public static AcceleoCommonPlugin getDefault() {
        return plugin;
    }

    @Deprecated
    public static void log(Exception e, boolean blocker) {
        AcceleoLogger.log(e, blocker);
    }

    @Deprecated
    public static void log(IStatus status) {
        AcceleoLogger.log(status);
    }

    @Deprecated
    public static void log(String message, boolean blocker) {
        AcceleoLogger.log(message, blocker);
    }

    @Deprecated
    public static void log(String message, Exception cause, boolean blocker) {
        AcceleoLogger.log(message, cause, blocker);
    }

    public BundleContext getContext() {
        return this.context;
    }

    public void start(BundleContext bundleContext) throws Exception {
        super.start(bundleContext);
        AcceleoWorkspaceUtil.INSTANCE.initialize();
        Bundle pdeCoreBundle = Platform.getBundle((String)"org.eclipse.pde.core");
        if (pdeCoreBundle != null) {
            ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.workspaceEcoreListener, 7);
        }
        ResourcesPlugin.getWorkspace().getRoot().accept(new IResourceVisitor(){

            public boolean visit(IResource resource) throws CoreException {
                if (resource instanceof IFile && resource instanceof IFile && ((IFile)resource).getFileExtension() != null && ((IFile)resource).getFileExtension().equals("ecore") && AcceleoCommonPlugin.this.mightBeInAcceleoScope((IFile)resource)) {
                    URI uri = URI.createPlatformResourceURI((String)resource.getFullPath().toString(), (boolean)true);
                    AcceleoPackageRegistry.INSTANCE.registerEcorePackages(uri.toString(), AcceleoDynamicMetamodelResourceSetImpl.DYNAMIC_METAMODEL_RESOURCE_SET);
                }
                return true;
            }
        });
        this.context = bundleContext;
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        registry.addListener((IRegistryEventListener)this.librariesConnectorListener, LIBRARY_CONNECTORS_EXTENSION_POINT);
        registry.addListener((IRegistryEventListener)this.librariesListener, LIBRARIES_EXTENSION_POINT);
        this.parseInitialContributions();
        AcceleoModelManager.getManager().startup();
    }

    public void stop(BundleContext bundleContext) throws Exception {
        try {
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            registry.removeListener((IRegistryEventListener)this.librariesConnectorListener);
            registry.removeListener((IRegistryEventListener)this.librariesListener);
            Bundle pdeCoreBundle = Platform.getBundle((String)"org.eclipse.pde.core");
            if (pdeCoreBundle != null) {
                ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.workspaceEcoreListener);
            }
            AcceleoServicesEclipseUtil.clearRegistry();
            AcceleoLibraryConnectorsRegistry.INSTANCE.clearRegistry();
            AcceleoLibrariesEclipseUtil.clearRegistry();
            AcceleoWorkspaceUtil.INSTANCE.dispose();
            AcceleoPreferences.save();
            plugin = null;
            this.context = null;
            AcceleoModelManager.getManager().shutdown();
        }
        finally {
            super.stop(bundleContext);
        }
    }

    private void parseInitialContributions() {
        int n;
        int n2;
        IConfigurationElement[] iConfigurationElementArray;
        IExtension extension;
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtension[] iExtensionArray = registry.getExtensionPoint(LIBRARY_CONNECTORS_EXTENSION_POINT).getExtensions();
        int n3 = iExtensionArray.length;
        int n4 = 0;
        while (n4 < n3) {
            extension = iExtensionArray[n4];
            iConfigurationElementArray = extension.getConfigurationElements();
            n2 = iConfigurationElementArray.length;
            n = 0;
            while (n < n2) {
                IConfigurationElement service = iConfigurationElementArray[n];
                try {
                    AcceleoLibraryConnectorsRegistry.INSTANCE.addLibraryConnector(service.createExecutableExtension(CLASS_TAG_NAME).getClass(), service.getAttribute(FILE_EXTENSION_TAG_NAME));
                }
                catch (CoreException e) {
                    AcceleoLogger.log((Exception)((Object)e), false);
                }
                ++n;
            }
            ++n4;
        }
        iExtensionArray = registry.getExtensionPoint(LIBRARIES_EXTENSION_POINT).getExtensions();
        n3 = iExtensionArray.length;
        n4 = 0;
        while (n4 < n3) {
            extension = iExtensionArray[n4];
            iConfigurationElementArray = extension.getConfigurationElements();
            n2 = iConfigurationElementArray.length;
            n = 0;
            while (n < n2) {
                IConfigurationElement library = iConfigurationElementArray[n];
                String pathToFile = library.getAttribute(FILE_TAG_NAME);
                Class<ILibrary> libClass = AcceleoLibraryConnectorsRegistry.INSTANCE.getConnectorForResource(pathToFile);
                if (libClass != null) {
                    try {
                        ILibrary lib = libClass.newInstance();
                        lib.setURI(URI.createFileURI((String)ResourcesPlugin.getWorkspace().getRoot().getProject(extension.getContributor().getName()).getFile(pathToFile).getLocation().toString()));
                        AcceleoLibrariesEclipseUtil.addLibrary(lib);
                    }
                    catch (InstantiationException e) {
                        AcceleoLogger.log(e, true);
                    }
                    catch (IllegalAccessException e) {
                        AcceleoLogger.log(e, true);
                    }
                } else {
                    AcceleoLogger.log(AcceleoCommonMessages.getString("AcceleoLogger.MissingHandle", pathToFile), false);
                }
                ++n;
            }
            ++n4;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean mightBeInAcceleoScope(IFile ecoreFile) {
        try {
            if (ecoreFile.getProject() == null) return false;
            if (ecoreFile.getProject().getDescription() == null) return false;
            String[] stringArray = ecoreFile.getProject().getDescription().getNatureIds();
            int n = stringArray.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                String nature = stringArray[n2];
                if ("org.eclipse.pde.PluginNature".equals(nature)) {
                    return true;
                }
                ++n2;
            }
        }
        catch (CoreException coreException) {}
        return false;
    }

    final class AcceleoLibrariesRegistryListener
    implements IRegistryEventListener {
        AcceleoLibrariesRegistryListener() {
        }

        public void added(IExtension[] extensions) {
            IExtension[] iExtensionArray = extensions;
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
                int n3 = iConfigurationElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement service = iConfigurationElementArray[n4];
                    String pathToFile = service.getAttribute(AcceleoCommonPlugin.FILE_TAG_NAME);
                    Class<ILibrary> libClass = AcceleoLibraryConnectorsRegistry.INSTANCE.getConnectorForResource(pathToFile);
                    if (libClass != null) {
                        try {
                            ILibrary lib = libClass.newInstance();
                            lib.setURI(URI.createFileURI((String)ResourcesPlugin.getWorkspace().getRoot().getProject(extension.getContributor().getName()).getFile(pathToFile).getLocation().toString()));
                            AcceleoLibrariesEclipseUtil.addLibrary(lib);
                        }
                        catch (InstantiationException e) {
                            AcceleoLogger.log(e, true);
                        }
                        catch (IllegalAccessException e) {
                            AcceleoLogger.log(e, true);
                        }
                    } else {
                        AcceleoLogger.log(AcceleoCommonMessages.getString("AcceleoLogger.MissingHandle", pathToFile), false);
                    }
                    ++n4;
                }
                ++n2;
            }
        }

        public void added(IExtensionPoint[] extensionPoints) {
        }

        public void removed(IExtension[] extensions) {
            IExtension[] iExtensionArray = extensions;
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
                int n3 = iConfigurationElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement service = iConfigurationElementArray[n4];
                    AcceleoLibrariesEclipseUtil.removeLibrary(service.getAttribute(AcceleoCommonPlugin.FILE_TAG_NAME));
                    ++n4;
                }
                ++n2;
            }
        }

        public void removed(IExtensionPoint[] extensionPoints) {
        }
    }

    final class AcceleoLibraryConnectorsRegistryListener
    implements IRegistryEventListener {
        AcceleoLibraryConnectorsRegistryListener() {
        }

        public void added(IExtension[] extensions) {
            IExtension[] iExtensionArray = extensions;
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
                int n3 = iConfigurationElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement service = iConfigurationElementArray[n4];
                    try {
                        AcceleoLibraryConnectorsRegistry.INSTANCE.addLibraryConnector(service.createExecutableExtension(AcceleoCommonPlugin.CLASS_TAG_NAME).getClass(), service.getAttribute(AcceleoCommonPlugin.FILE_EXTENSION_TAG_NAME));
                    }
                    catch (CoreException e) {
                        AcceleoLogger.log((Exception)((Object)e), false);
                    }
                    ++n4;
                }
                ++n2;
            }
        }

        public void added(IExtensionPoint[] extensionPoints) {
        }

        public void removed(IExtension[] extensions) {
            IExtension[] iExtensionArray = extensions;
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
                int n3 = iConfigurationElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement service = iConfigurationElementArray[n4];
                    AcceleoLibraryConnectorsRegistry.INSTANCE.removeLibraryConnector(service.getAttribute(AcceleoCommonPlugin.CLASS_TAG_NAME));
                    ++n4;
                }
                ++n2;
            }
        }

        public void removed(IExtensionPoint[] extensionPoints) {
        }
    }

    private class WorkspaceEcoreListener
    implements IResourceChangeListener {
        WorkspaceEcoreListener() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            switch (event.getType()) {
                case 2: 
                case 4: {
                    if (!(event.getResource() instanceof IProject)) break;
                    try {
                        List<IFile> ecoreFiles = this.members((IContainer)event.getResource(), "ecore");
                        if (ecoreFiles.isEmpty()) break;
                        for (IFile ecoreFile : ecoreFiles) {
                            AcceleoPackageRegistry.INSTANCE.unregisterEcorePackages(ecoreFile.getFullPath().toString());
                        }
                    }
                    catch (CoreException e) {
                        AcceleoLogger.log((Exception)((Object)e), false);
                    }
                    break;
                }
                case 1: {
                    IResource resource = null;
                    if (event.getResource() != null) {
                        resource = event.getResource();
                    } else if (this.getResources(event.getDelta()).size() > 0) {
                        List<IResource> resources = this.getResources(event.getDelta());
                        resource = resources.get(0);
                    }
                    if (resource == null || !resource.isAccessible() || resource.getFileExtension() == null || !resource.getFileExtension().endsWith("ecore") || !(resource instanceof IFile) || !AcceleoCommonPlugin.this.mightBeInAcceleoScope((IFile)resource)) break;
                    URI uri = URI.createPlatformResourceURI((String)resource.getFullPath().toString(), (boolean)true);
                    AcceleoPackageRegistry.INSTANCE.registerEcorePackages(uri.toString(), AcceleoDynamicMetamodelResourceSetImpl.DYNAMIC_METAMODEL_RESOURCE_SET);
                }
            }
        }

        private List<IResource> getResources(IResourceDelta delta) {
            IResourceDelta[] affectedChildren;
            ArrayList<IResource> resources = new ArrayList<IResource>();
            IResourceDelta[] iResourceDeltaArray = affectedChildren = delta.getAffectedChildren();
            int n = affectedChildren.length;
            int n2 = 0;
            while (n2 < n) {
                IResourceDelta iResourceDelta = iResourceDeltaArray[n2];
                IResource resource = iResourceDelta.getResource();
                if (resource instanceof IFile && ((IFile)resource).getFileExtension() != null && ((IFile)resource).getFileExtension().equals("ecore")) {
                    resources.add(resource);
                }
                resources.addAll(this.getResources(iResourceDelta));
                ++n2;
            }
            return resources;
        }

        private List<IFile> members(IContainer container, String extension) throws CoreException {
            IResource[] children;
            ArrayList<IFile> output = new ArrayList<IFile>();
            if (container != null && container.isAccessible() && (children = container.members()) != null) {
                int i = 0;
                while (i < children.length) {
                    IResource resource = children[i];
                    if (resource instanceof IFile && extension.equals(((IFile)resource).getFileExtension())) {
                        output.add((IFile)resource);
                    } else if (resource instanceof IContainer) {
                        output.addAll(this.members((IContainer)resource, extension));
                    }
                    ++i;
                }
            }
            return output;
        }
    }
}

