/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.ui.editors;

import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Stream;
import org.eclipse.fordiac.ide.ui.FordiacLogHelper;
import org.eclipse.fordiac.ide.ui.editors.EditorAction;
import org.eclipse.fordiac.ide.ui.editors.EditorFilter;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.properties.PropertySheet;

public final class EditorUtils {
    public static final String TEXT_EDITOR_ID = "org.eclipse.ui.DefaultTextEditor";
    public static final EditorAction CloseEditor = part -> {
        boolean bl = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().closeEditor(part, false);
    };

    private EditorUtils() {
        throw new AssertionError();
    }

    public static IEditorPart getCurrentActiveEditor() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && window.getActivePage() != null) {
            return window.getActivePage().getActiveEditor();
        }
        return null;
    }

    public static GraphicalViewer getGraphicalViewerFromCurrentActiveEditor() {
        IEditorPart currentActiveEditor = EditorUtils.getCurrentActiveEditor();
        if (currentActiveEditor != null) {
            return (GraphicalViewer)currentActiveEditor.getAdapter(GraphicalViewer.class);
        }
        return null;
    }

    public static IEditorPart openTextEditor(IEditorInput input) {
        return EditorUtils.openEditor(input, TEXT_EDITOR_ID);
    }

    public static IEditorPart openEditor(IEditorInput input, String editorId) {
        IEditorPart editor = null;
        IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        try {
            editor = activePage.openEditor(input, editorId, true, 3);
        }
        catch (PartInitException e) {
            FordiacLogHelper.logError(e.getMessage(), e);
        }
        return editor;
    }

    public static IEditorPart[] findEditor(EditorFilter filter) {
        IEditorReference[] editorReferences = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getEditorReferences();
        return (IEditorPart[])Arrays.stream(editorReferences).map(ref -> ref.getEditor(false)).filter(Objects::nonNull).filter(editor -> filter.filter((IEditorPart)editor)).toArray(IEditorPart[]::new);
    }

    public static void forEachOpenEditorFiltered(EditorFilter filter, EditorAction action) {
        Stream.of(PlatformUI.getWorkbench().getWorkbenchWindows()).flatMap(window -> Stream.of(window.getPages())).flatMap(page -> Stream.of(page.getEditorReferences())).map(ref -> ref.getEditor(false)).filter(Objects::nonNull).filter(filter::filter).forEach(action::run);
    }

    public static void closeEditorsFiltered(EditorFilter filter) {
        EditorUtils.forEachOpenEditorFiltered(filter, CloseEditor);
    }

    public static void refreshPropertySheetWithSelection(IEditorPart activeEditor, EditPartViewer viewer, Object obj) {
        if (viewer != null) {
            viewer.select((EditPart)obj);
        }
        IViewPart view = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("org.eclipse.ui.views.PropertySheet");
        if (activeEditor != null && view instanceof PropertySheet) {
            PropertySheet propertySheet = (PropertySheet)view;
            ISelection selection = activeEditor.getSite().getSelectionProvider().getSelection();
            propertySheet.selectionChanged((IWorkbenchPart)activeEditor, selection);
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().activate((IWorkbenchPart)view);
        }
    }
}

