/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.structuredtextcore.formatting2;

import java.util.Objects;
import java.util.regex.Pattern;
import org.eclipse.fordiac.ide.structuredtextcore.formatting2.FormatterUtil;
import org.eclipse.fordiac.ide.structuredtextcore.formatting2.STCoreFormatterPreferenceKeys;
import org.eclipse.xtext.formatting2.FormatterPreferenceKeys;
import org.eclipse.xtext.formatting2.ITextReplacerContext;
import org.eclipse.xtext.formatting2.internal.MultilineCommentReplacer;
import org.eclipse.xtext.formatting2.internal.WhitespaceReplacer;
import org.eclipse.xtext.formatting2.regionaccess.IComment;
import org.eclipse.xtext.preferences.TypedPreferenceKey;

public class STCoreMultilineCommentReplacer
extends MultilineCommentReplacer {
    private static final Pattern JOIN_PATTERN = Pattern.compile("(?<=\\w)\\h*+\\R\\h*+(?=\\w)");
    private final char prefix;
    private final boolean multiline;

    protected STCoreMultilineCommentReplacer(IComment comment, char prefix) {
        super(comment, prefix);
        this.prefix = prefix;
        this.multiline = STCoreMultilineCommentReplacer.isMultiline(comment, prefix);
    }

    public void configureWhitespace(WhitespaceReplacer leading, WhitespaceReplacer trailing) {
        FormatterUtil.configureCommentWhitespace(leading.getFormatting(), trailing.getFormatting());
        if (this.multiline) {
            this.enforceNewLine(leading);
            this.enforceNewLine(trailing);
        } else {
            if (!leading.getRegion().isMultiline()) {
                this.enforceSingleSpace(leading);
            }
            if (!trailing.getRegion().isMultiline()) {
                this.enforceSingleSpace(trailing);
            }
        }
    }

    public ITextReplacerContext createReplacements(ITextReplacerContext context) {
        int commentLineLength;
        Object indendationString;
        String lineSeparator = (String)context.getFormatter().getPreference((TypedPreferenceKey)FormatterPreferenceKeys.lineSeparator);
        Integer maxCommentWidth = (Integer)context.getFormatter().getPreference((TypedPreferenceKey)STCoreFormatterPreferenceKeys.maxCommentWidth);
        int lengthBeforeComment = context.getLeadingCharsInLineCount();
        if (this.multiline) {
            indendationString = context.getIndentationString();
            commentLineLength = maxCommentWidth - 3;
        } else {
            indendationString = context.getIndentationString() + " ".repeat(Math.max(0, lengthBeforeComment - FormatterUtil.getIndendationChars(context)));
            commentLineLength = maxCommentWidth - 6;
        }
        if (commentLineLength < 1) {
            return context;
        }
        String text = this.getComment().getText();
        String body = text.substring(2, text.length() - 2);
        String stripped = Pattern.compile("^\\h*+(?:" + Pattern.quote(Character.toString(this.prefix)) + " )?", 8).matcher(body).replaceAll("").strip();
        String joined = JOIN_PATTERN.matcher(stripped).replaceAll(" ");
        String wrapped = FormatterUtil.wrapLines(joined, commentLineLength, lineSeparator);
        String prefixed = FormatterUtil.prefixLines(wrapped, (String)indendationString + " " + Character.toString(this.prefix), lineSeparator);
        String replacement = this.multiline ? "(" + Character.toString(this.prefix) + lineSeparator + prefixed.stripTrailing() + lineSeparator + (String)indendationString + " " + Character.toString(this.prefix) + ")" : "(" + prefixed.strip() + " " + Character.toString(this.prefix) + ")";
        if (!Objects.equals(text, replacement)) {
            context.addReplacement(this.getComment().replaceWith(replacement));
        }
        return context;
    }

    protected static boolean isMultiline(IComment comment, char prefix) {
        return Pattern.compile(Pattern.quote(Character.toString(prefix)) + "*+\\h*+$", 8).matcher(comment.getText().substring(2)).lookingAt();
    }
}

