/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.structuredtextcore.ui.refactoring;

import com.google.inject.Inject;
import com.google.inject.Provider;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.fordiac.ide.structuredtextcore.ui.refactoring.ExtractCallableRefactoring;
import org.eclipse.fordiac.ide.structuredtextcore.ui.refactoring.ExtractCallableWizard;
import org.eclipse.fordiac.ide.ui.FordiacLogHelper;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.RefactoringWizardOpenOperation;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.editor.utils.EditorUtils;

public class ExtractCallableHandler
extends AbstractHandler {
    @Inject
    private Provider<ExtractCallableRefactoring> refactoringProvider;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        try {
            XtextEditor editor = EditorUtils.getActiveXtextEditor((ExecutionEvent)event);
            if (editor != null) {
                ITextSelection selection = (ITextSelection)editor.getSelectionProvider().getSelection();
                ExtractCallableRefactoring refactoring = (ExtractCallableRefactoring)((Object)this.refactoringProvider.get());
                refactoring.initialize(editor, selection);
                ExtractCallableWizard wizard = new ExtractCallableWizard(refactoring);
                RefactoringWizardOpenOperation openOperation = new RefactoringWizardOpenOperation((RefactoringWizard)wizard);
                openOperation.run(editor.getShell(), refactoring.getName());
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            FordiacLogHelper.logError((String)"Error during refactoring", (Throwable)e);
        }
        return null;
    }
}

