/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.structuredtextcore.ui.contentassist;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.inject.Inject;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.fordiac.ide.globalconstantseditor.globalConstants.GlobalConstantsPackage;
import org.eclipse.fordiac.ide.globalconstantseditor.globalConstants.STVarGlobalDeclarationBlock;
import org.eclipse.fordiac.ide.model.libraryElement.ICallable;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementPackage;
import org.eclipse.fordiac.ide.model.typelibrary.TypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibrary;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibraryManager;
import org.eclipse.fordiac.ide.structuredtextcore.resource.STCoreResourceDescriptionStrategy;
import org.eclipse.fordiac.ide.structuredtextcore.services.STCoreGrammarAccess;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STCorePackage;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STImport;
import org.eclipse.fordiac.ide.structuredtextcore.ui.contentassist.AbstractSTCoreProposalProvider;
import org.eclipse.fordiac.ide.structuredtextcore.ui.contentassist.STCoreConfigurableCompletionProposal;
import org.eclipse.fordiac.ide.structuredtextcore.ui.contentassist.STCoreImportReplacementTextApplier;
import org.eclipse.fordiac.ide.structuredtextcore.util.STCoreRegionString;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.CrossReference;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.formatting.IWhitespaceInformationProvider;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.resource.impl.AliasedEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.ui.editor.contentassist.AbstractJavaBasedContentProposalProvider;
import org.eclipse.xtext.ui.editor.contentassist.ConfigurableCompletionProposal;
import org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ui.editor.contentassist.ICompletionProposalAcceptor;
import org.eclipse.xtext.util.ITextRegion;

public class STCoreProposalProvider
extends AbstractSTCoreProposalProvider {
    @Inject
    private STCoreGrammarAccess grammarAccess;

    public void completeKeyword(Keyword keyword, ContentAssistContext contentAssistContext, ICompletionProposalAcceptor acceptor) {
        if (STCoreProposalProvider.isKeywordWorthyToPropose(keyword)) {
            super.completeKeyword(keyword, contentAssistContext, acceptor);
        }
    }

    protected static boolean isKeywordWorthyToPropose(Keyword keyword) {
        return keyword.getValue().length() > 1 && Character.isLetter(keyword.getValue().charAt(0));
    }

    @Override
    public void completeSTFeatureExpression_Feature(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.lookupCrossReference((CrossReference)assignment.getTerminal(), context, acceptor, this::isVisible);
    }

    @Override
    public void completeSTVarDeclaration_Type(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.lookupCrossReference((CrossReference)assignment.getTerminal(), context, acceptor, this::isVisible);
    }

    @Override
    public void completeSTTypeDeclaration_Type(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.lookupCrossReference((CrossReference)assignment.getTerminal(), context, acceptor, this::isVisible);
    }

    @Override
    public void completeSTImport_ImportedNamespace(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.createReferenceImportProposals(model, context, acceptor);
        this.createWildcardImportProposals(model, context, acceptor);
    }

    protected boolean isVisible(IEObjectDescription description) {
        return description.getName().getSegmentCount() == 1 || LibraryElementPackage.eINSTANCE.getLibraryElement().isSuperTypeOf(description.getEClass()) && STCoreProposalProvider.isGlobalLibraryElement(description) || STCorePackage.eINSTANCE.getSTVarDeclaration().equals(description.getEClass()) && STCoreProposalProvider.isGlobalVariable(description);
    }

    protected static boolean isGlobalLibraryElement(IEObjectDescription description) {
        String containerEClassName = description.getUserData(STCoreResourceDescriptionStrategy.CONTAINER_ECLASS_NAME);
        if (containerEClassName != null) {
            return containerEClassName.isEmpty();
        }
        return description.getEObjectOrProxy().eContainer() == null;
    }

    protected static boolean isGlobalVariable(IEObjectDescription description) {
        String containerEClassName = description.getUserData(STCoreResourceDescriptionStrategy.CONTAINER_ECLASS_NAME);
        if (containerEClassName != null) {
            return GlobalConstantsPackage.eINSTANCE.getSTVarGlobalDeclarationBlock().getName().equals(containerEClassName);
        }
        return description.getEObjectOrProxy().eContainer() instanceof STVarGlobalDeclarationBlock;
    }

    protected void createPackageProposals(EObject model, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        TypeLibrary typeLibrary = TypeLibraryManager.INSTANCE.getTypeLibraryFromContext(model);
        if (typeLibrary != null) {
            for (String packageName : typeLibrary.getPackages()) {
                if (!acceptor.canAcceptMoreProposals()) {
                    return;
                }
                acceptor.accept(this.createPackageProposal(packageName, context));
            }
        }
    }

    protected ICompletionProposal createPackageProposal(String packageName, ContentAssistContext context) {
        ICompletionProposal result = this.createCompletionProposal(packageName, new StyledString(packageName), PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER"), context);
        this.getPriorityHelper().adjustCrossReferencePriority(result, context.getPrefix());
        return result;
    }

    protected void createReferenceImportProposals(EObject model, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.getCrossReferenceProposalCreator().lookupCrossReference(model, STCorePackage.Literals.ST_FEATURE_EXPRESSION__FEATURE, acceptor, this.getCrossReferenceProposalCreator()::isImportableDescription, this.getProposalFactory(this.grammarAccess.getQualifiedNameWithWildcardRule().getName(), context));
        this.getCrossReferenceProposalCreator().lookupCrossReference(model, STCorePackage.Literals.ST_VAR_DECLARATION__TYPE, acceptor, this.getCrossReferenceProposalCreator()::isImportableDescription, this.getProposalFactory(this.grammarAccess.getQualifiedNameWithWildcardRule().getName(), context));
    }

    protected void createWildcardImportProposals(EObject model, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        TypeLibrary typeLibrary = TypeLibraryManager.INSTANCE.getTypeLibraryFromContext(model);
        if (typeLibrary != null) {
            STCoreProposalProvider.createSimpleProposals(typeLibrary.getPackages(), acceptor, (Function<String, ICompletionProposal>)((Function)value -> this.createWildcardImportProposal((String)value, PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER"), context)));
            STCoreProposalProvider.createSimpleProposals(typeLibrary.getGlobalConstants().stream().map(TypeEntry::getFullTypeName).toList(), acceptor, (Function<String, ICompletionProposal>)((Function)value -> this.createWildcardImportProposal((String)value, PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FILE"), context)));
        }
    }

    protected ICompletionProposal createWildcardImportProposal(String value, Image image, ContentAssistContext context) {
        String proposal = value + "::*";
        return this.createCompletionProposal(proposal, new StyledString(proposal), image, context);
    }

    protected static void createSimpleProposals(Iterable<String> values, ICompletionProposalAcceptor acceptor, Function<String, ICompletionProposal> proposalFactory) {
        for (String value : values) {
            if (!acceptor.canAcceptMoreProposals()) {
                return;
            }
            acceptor.accept((ICompletionProposal)proposalFactory.apply((Object)value));
        }
    }

    protected StyledString getStyledDisplayString(IEObjectDescription description) {
        String signature = description.getUserData(STCoreResourceDescriptionStrategy.DISPLAY_STRING);
        if (signature != null) {
            StyledString result = new StyledString(signature);
            if (description.getQualifiedName().getSegmentCount() > 1) {
                result.append(" - " + this.getQualifiedNameConverter().toString(description.getQualifiedName()), StyledString.QUALIFIER_STYLER);
            }
            return result;
        }
        return super.getStyledDisplayString(description);
    }

    protected StyledString getStyledDisplayString(EObject element, String qualifiedNameAsString, String shortName) {
        if (!element.eIsProxy() && element instanceof ICallable) {
            ICallable callable = (ICallable)element;
            StyledString result = new StyledString(callable.getSignature());
            QualifiedName qualifiedName = this.getQualifiedNameConverter().toQualifiedName(qualifiedNameAsString);
            if (qualifiedName.getSegmentCount() > 1) {
                result.append(" - " + qualifiedNameAsString, StyledString.QUALIFIER_STYLER);
            }
            return result;
        }
        return super.getStyledDisplayString(element, qualifiedNameAsString, shortName);
    }

    protected String getDisplayString(EObject element, String qualifiedNameAsString, String shortName) {
        if (!element.eIsProxy() && element instanceof ICallable) {
            ICallable callable = (ICallable)element;
            StringBuilder result = new StringBuilder(callable.getSignature());
            QualifiedName qualifiedName = this.getQualifiedNameConverter().toQualifiedName(qualifiedNameAsString);
            if (qualifiedName.getSegmentCount() > 1) {
                result.append(" - " + qualifiedNameAsString);
            }
            return result.toString();
        }
        return super.getDisplayString(element, qualifiedNameAsString, shortName);
    }

    protected ConfigurableCompletionProposal doCreateProposal(String proposal, StyledString displayString, Image image, int replacementOffset, int replacementLength) {
        return new STCoreConfigurableCompletionProposal(proposal, replacementOffset, replacementLength, proposal.length(), image, displayString, null, null);
    }

    protected Function<IEObjectDescription, ICompletionProposal> getProposalFactory(String ruleName, ContentAssistContext contentAssistContext) {
        return new STCoreProposalCreator(contentAssistContext, ruleName, this.getQualifiedNameConverter());
    }

    public STCoreReferenceProposalCreator getCrossReferenceProposalCreator() {
        return (STCoreReferenceProposalCreator)super.getCrossReferenceProposalCreator();
    }

    protected class STCoreProposalCreator
    extends AbstractJavaBasedContentProposalProvider.DefaultProposalCreator {
        private final ContentAssistContext contentAssistContext;
        private final String ruleName;

        protected STCoreProposalCreator(ContentAssistContext contentAssistContext, String ruleName, IQualifiedNameConverter qualifiedNameConverter) {
            super((AbstractJavaBasedContentProposalProvider)STCoreProposalProvider.this, contentAssistContext, ruleName, qualifiedNameConverter);
            this.contentAssistContext = contentAssistContext;
            this.ruleName = ruleName;
        }

        public ICompletionProposal apply(IEObjectDescription candidate) {
            ICompletionProposal result = super.apply(candidate);
            if (result instanceof STCoreConfigurableCompletionProposal) {
                STCoreConfigurableCompletionProposal configurableResult = (STCoreConfigurableCompletionProposal)result;
                if (this.isCallableDescription(candidate) && this.shouldAddParameters()) {
                    List parameterProposalRegions;
                    String parameterProposal;
                    String nameProposal = configurableResult.getReplacementString();
                    int replacementOffset = configurableResult.getReplacementOffset();
                    String parameterProposalData = candidate.getUserData(STCoreResourceDescriptionStrategy.PARAMETER_PROPOSAL);
                    String parameterProposalRegionsData = candidate.getUserData(STCoreResourceDescriptionStrategy.PARAMETER_PROPOSAL_REGIONS);
                    if (parameterProposalData != null && parameterProposalRegionsData != null) {
                        parameterProposal = parameterProposalData;
                        parameterProposalRegions = STCoreRegionString.parseRegions((String)parameterProposalRegionsData, (int)(replacementOffset + nameProposal.length()));
                    } else {
                        ICallable callable;
                        EObject eObject = candidate.getEObjectOrProxy();
                        if (eObject instanceof ICallable && !(callable = (ICallable)eObject).eIsProxy()) {
                            STCoreRegionString parameterProposalString = STCoreResourceDescriptionStrategy.getCallableParameterProposal((ICallable)callable);
                            parameterProposal = parameterProposalString.toString();
                            parameterProposalRegions = parameterProposalString.getRegions(replacementOffset + nameProposal.length());
                        } else {
                            parameterProposal = "()";
                            parameterProposalRegions = Collections.emptyList();
                        }
                    }
                    String proposal = nameProposal + parameterProposal;
                    configurableResult.setReplacementString(proposal);
                    if (parameterProposalRegions.isEmpty()) {
                        configurableResult.setCursorPosition(proposal.length());
                        configurableResult.setSelectionStart(replacementOffset + proposal.length() - 1);
                        configurableResult.setSelectionLength(0);
                        configurableResult.setSimpleLinkedMode(this.contentAssistContext.getViewer(), new char[]{')'});
                    } else {
                        ITextRegion firstRegion = (ITextRegion)parameterProposalRegions.get(0);
                        configurableResult.setCursorPosition(firstRegion.getOffset() + firstRegion.getLength() - replacementOffset);
                        configurableResult.setSelectionStart(firstRegion.getOffset());
                        configurableResult.setSelectionLength(firstRegion.getLength());
                        configurableResult.setCustomLinkedMode(this.contentAssistContext.getViewer(), parameterProposalRegions, replacementOffset + proposal.length(), ')');
                    }
                }
            }
            return result;
        }

        protected boolean isCallableDescription(IEObjectDescription description) {
            return description != null && description.getEClass() != null && LibraryElementPackage.eINSTANCE.getICallable().isSuperTypeOf(description.getEClass());
        }

        protected boolean shouldAddParameters() {
            return STCoreProposalProvider.this.grammarAccess.getSTFeatureNameRule().getName().equals(this.ruleName);
        }
    }

    public static class STCoreReferenceProposalCreator
    extends AbstractJavaBasedContentProposalProvider.ReferenceProposalCreator {
        @Inject
        private IQualifiedNameConverter qualifiedNameConverter;
        @Inject
        private IWhitespaceInformationProvider whitespaceInformationProvider;

        public void lookupCrossReference(IScope scope, EObject model, EReference reference, ICompletionProposalAcceptor acceptor, Predicate<IEObjectDescription> filter, Function<IEObjectDescription, ICompletionProposal> proposalFactory) {
            Function wrappedFactory = this.getWrappedFactory(model, reference, proposalFactory);
            Function<IEObjectDescription, ICompletionProposal> wrappedImportingFactory = this.getWrappedImportingFactory(model, reference, proposalFactory);
            Iterable candidates = this.queryScope(scope, model, reference, filter);
            for (IEObjectDescription candidate : candidates) {
                if (!acceptor.canAcceptMoreProposals()) {
                    return;
                }
                if (!filter.apply((Object)candidate)) continue;
                if (this.shouldImport(scope, model, reference, candidate)) {
                    acceptor.accept((ICompletionProposal)wrappedImportingFactory.apply((Object)candidate));
                    continue;
                }
                acceptor.accept((ICompletionProposal)wrappedFactory.apply((Object)candidate));
            }
        }

        protected boolean shouldImport(IScope scope, EObject model, EReference reference, IEObjectDescription candidate) {
            return this.isImportableDescription(candidate) && !this.hasConflictingName(scope, candidate) && !this.isImport(model, reference);
        }

        protected boolean isImportableDescription(IEObjectDescription description) {
            return description != null && description.getEClass() != null && (LibraryElementPackage.eINSTANCE.getLibraryElement().isSuperTypeOf(description.getEClass()) && description.getName().getSegmentCount() > 1 && STCoreProposalProvider.isGlobalLibraryElement(description) || STCoreProposalProvider.isGlobalVariable(description) && description.getName().getSegmentCount() > 2);
        }

        protected boolean hasConflictingName(IScope scope, IEObjectDescription description) {
            return scope.getSingleElement(STCoreReferenceProposalCreator.getAlias(description)) != null;
        }

        protected boolean isImport(EObject model, EReference reference) {
            return model instanceof STImport;
        }

        protected Function<IEObjectDescription, ICompletionProposal> getWrappedImportingFactory(EObject model, EReference reference, Function<IEObjectDescription, ICompletionProposal> proposalFactory) {
            return description -> {
                ICompletionProposal proposal = (ICompletionProposal)proposalFactory.apply((Object)STCoreReferenceProposalCreator.createImportedDescription(description));
                if (proposal instanceof ConfigurableCompletionProposal) {
                    ConfigurableCompletionProposal configurableProposal = (ConfigurableCompletionProposal)proposal;
                    configurableProposal.setTextApplier(this.getImportReplacementTextApplier(model, (IEObjectDescription)description));
                }
                return proposal;
            };
        }

        protected ConfigurableCompletionProposal.IReplacementTextApplier getImportReplacementTextApplier(EObject model, IEObjectDescription candidate) {
            return this.getImportReplacementTextApplier((XtextResource)model.eResource(), this.qualifiedNameConverter.toString(STCoreReferenceProposalCreator.getImportedNamespace(candidate)));
        }

        protected ConfigurableCompletionProposal.IReplacementTextApplier getImportReplacementTextApplier(XtextResource resource, String importedNamespace) {
            return new STCoreImportReplacementTextApplier(resource, importedNamespace, this.whitespaceInformationProvider);
        }

        protected static AliasedEObjectDescription createImportedDescription(IEObjectDescription description) {
            return new AliasedEObjectDescription(STCoreReferenceProposalCreator.getAlias(description), description);
        }

        protected static QualifiedName getAlias(IEObjectDescription description) {
            QualifiedName qualifiedName = description.getQualifiedName();
            if (STCoreProposalProvider.isGlobalVariable(description)) {
                return qualifiedName.skipFirst(qualifiedName.getSegmentCount() - 2);
            }
            return qualifiedName.skipFirst(qualifiedName.getSegmentCount() - 1);
        }

        private static QualifiedName getImportedNamespace(IEObjectDescription description) {
            if (STCoreProposalProvider.isGlobalVariable(description)) {
                return description.getQualifiedName().skipLast(1);
            }
            return description.getQualifiedName();
        }

        public IWhitespaceInformationProvider getWhitespaceInformationProvider() {
            return this.whitespaceInformationProvider;
        }
    }
}

