/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.dataimport;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.fordiac.ide.model.Messages;
import org.eclipse.fordiac.ide.model.dataimport.CommonElementImporter;
import org.eclipse.fordiac.ide.model.dataimport.TypeImporter;
import org.eclipse.fordiac.ide.model.dataimport.exceptions.TypeImportException;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterFB;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.InterfaceList;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementPackage;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.With;
import org.eclipse.fordiac.ide.model.typelibrary.AdapterTypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.EventTypeLibrary;

public class InterfaceListImporter
extends TypeImporter {
    private final Map<String, VarDeclaration> variables = new HashMap<String, VarDeclaration>();
    private final Map<String, Event> inputEvents = new HashMap<String, Event>();
    private final Map<String, Event> outputEvents = new HashMap<String, Event>();
    private final Map<Event, List<String>> withList = new HashMap<Event, List<String>>();

    public InterfaceListImporter(CommonElementImporter importer) {
        super(importer);
    }

    protected InterfaceList parseInterfaceList(String interfaceListName) throws TypeImportException, XMLStreamException {
        InterfaceList interfaceList = LibraryElementFactory.eINSTANCE.createInterfaceList();
        String inputEventListName = this.getEventInputElement();
        String outputEventListName = this.getEventOutputElement();
        this.processChildren(interfaceListName, name -> {
            block20: {
                block21: {
                    block19: {
                        if (!inputEventListName.equals(name)) break block19;
                        this.parseEventList(interfaceList.getEventInputs(), inputEventListName, true);
                        break block20;
                    }
                    if (!outputEventListName.equals(name)) break block21;
                    this.parseEventList(interfaceList.getEventOutputs(), outputEventListName, false);
                    break block20;
                }
                switch (name) {
                    case "InputVars": {
                        this.parseVariableList("InputVars", interfaceList.getInputVars(), true);
                        break;
                    }
                    case "OutputVars": {
                        this.parseVariableList("OutputVars", interfaceList.getOutputVars(), false);
                        break;
                    }
                    case "Sockets": {
                        this.parseAdapterList(interfaceList.getSockets(), "Sockets", true);
                        break;
                    }
                    case "Plugs": {
                        this.parseAdapterList(interfaceList.getPlugs(), "Plugs", false);
                        break;
                    }
                    case "InOutVars": {
                        this.parseVariableList("InOutVars", interfaceList.getInOutVars(), true);
                        break;
                    }
                    default: {
                        return false;
                    }
                }
            }
            return true;
        });
        this.processWiths();
        return interfaceList;
    }

    protected String getEventOutputElement() {
        return "EventOutputs";
    }

    protected String getEventInputElement() {
        return "EventInputs";
    }

    private void parseVariableList(String nodeName, EList<? super VarDeclaration> varList, boolean input) throws TypeImportException, XMLStreamException {
        this.processChildren(nodeName, name -> {
            if (name.equals("VarDeclaration")) {
                VarDeclaration v = this.parseVarDeclaration();
                varList.add((Object)v);
                this.variables.put(v.getName(), v);
                v.setIsInput(input);
                return true;
            }
            return false;
        });
    }

    private void parseAdapterList(EList<AdapterDeclaration> adpaterList, String adpaterListName, boolean isInput) throws TypeImportException, XMLStreamException {
        this.processChildren(adpaterListName, name -> {
            if ("AdapterDeclaration".equals(name)) {
                AdapterDeclaration a = this.parseAdapterDeclaration(isInput);
                adpaterList.add((Object)a);
                this.addAdapterEvents(a);
                return true;
            }
            return false;
        });
    }

    private void addAdapterEvents(AdapterDeclaration a) {
        InterfaceList adapterInterfaceList = a.getAdapterFB().getInterface();
        String prefix = a.getName() + ".";
        if (a.getType() != null && adapterInterfaceList != null) {
            adapterInterfaceList.getEventOutputs().forEach(ae -> {
                Event event = this.inputEvents.put(prefix + ae.getName(), (Event)ae);
            });
            adapterInterfaceList.getEventInputs().forEach(ae -> {
                Event event = this.outputEvents.put(prefix + ae.getName(), (Event)ae);
            });
        }
    }

    private AdapterDeclaration parseAdapterDeclaration(boolean input) throws TypeImportException, XMLStreamException {
        AdapterDeclaration a = LibraryElementFactory.eINSTANCE.createAdapterDeclaration();
        this.readNameCommentAttributes(a);
        a.setIsInput(input);
        String typeName = this.getAttributeValue("Type");
        if (typeName == null) {
            throw new TypeImportException(Messages.FBTImporter_ADAPTER_DECLARATION_TYPE_EXCEPTION);
        }
        AdapterTypeEntry entry = this.getTypeEntry(typeName, this.getTypeLibrary()::getAdapterTypeEntry);
        if (entry == null) {
            entry = (AdapterTypeEntry)this.addDependency(this.getTypeLibrary().createErrorTypeEntry(typeName, LibraryElementPackage.Literals.ADAPTER_TYPE));
        }
        a.setType(entry.getType());
        InterfaceListImporter.createAdapterFB(a);
        this.getXandY(a.getAdapterFB());
        this.processChildren("AdapterDeclaration", name -> {
            if ("Attribute".equals(name)) {
                this.parseGenericAttributeNode(a);
                this.proceedToEndElementNamed("Attribute");
                return true;
            }
            return false;
        });
        this.proceedToEndElementNamed("AdapterDeclaration");
        return a;
    }

    private static void createAdapterFB(AdapterDeclaration adapter) {
        AdapterFB aFB = LibraryElementFactory.eINSTANCE.createAdapterFB();
        aFB.setTypeEntry(adapter.getType().getTypeEntry());
        aFB.setAdapterDecl(adapter);
        adapter.setAdapterFB(aFB);
        adapter.setInterfaceOnlyAdapterFB(aFB);
        aFB.setName(adapter.getName());
        if (aFB.getType() != null && aFB.getType().getInterfaceList() != null) {
            aFB.setInterface(aFB.getType().getInterfaceList().copy());
        } else {
            aFB.setInterface(LibraryElementFactory.eINSTANCE.createInterfaceList());
        }
    }

    protected void processWiths() {
        this.withList.entrySet().forEach(entry -> {
            Event e = (Event)entry.getKey();
            ((List)entry.getValue()).forEach(varName -> {
                VarDeclaration v = this.getWithedVar((String)varName, e);
                if (v != null) {
                    e.getWith().add((Object)InterfaceListImporter.createWith(v));
                }
            });
        });
    }

    private VarDeclaration getWithedVar(String varName, Event ev) {
        VarDeclaration varDecl = this.variables.get(varName);
        if (varDecl != null && varDecl.isInOutVar() && !ev.isIsInput()) {
            return varDecl.getInOutVarOpposite();
        }
        return varDecl;
    }

    private static With createWith(VarDeclaration v) {
        With withConstruct = LibraryElementFactory.eINSTANCE.createWith();
        withConstruct.setVariables(v);
        return withConstruct;
    }

    private void parseEventList(EList<Event> eventList, String eventListName, boolean isInput) throws TypeImportException, XMLStreamException {
        String eventName = this.getEventElement();
        this.processChildren(eventListName, name -> {
            if (eventName.equals(name)) {
                Event e = this.parseEvent(eventName);
                e.setIsInput(isInput);
                if (isInput) {
                    this.inputEvents.put(e.getName(), e);
                } else {
                    this.outputEvents.put(e.getName(), e);
                }
                eventList.add((Object)e);
                return true;
            }
            return false;
        });
    }

    protected String getEventElement() {
        return "Event";
    }

    private Event parseEvent(String eventName) throws TypeImportException, XMLStreamException {
        Event e = LibraryElementFactory.eINSTANCE.createEvent();
        String type = this.getAttributeValue("Type");
        e.setType(EventTypeLibrary.getInstance().getType(type));
        this.readNameCommentAttributes(e);
        ArrayList withVars = new ArrayList();
        this.processChildren(eventName, name -> {
            switch (name) {
                case "With": {
                    String val = this.getAttributeValue("Var");
                    if (val != null) {
                        withVars.add(val);
                    }
                    this.proceedToEndElementNamed("With");
                    return true;
                }
                case "Attribute": {
                    this.parseGenericAttributeNode(e);
                    this.proceedToEndElementNamed("Attribute");
                    return true;
                }
            }
            return false;
        });
        if (!withVars.isEmpty()) {
            this.withList.put(e, withVars);
        }
        return e;
    }

    public Map<String, Event> getInputEvents() {
        return this.inputEvents;
    }

    public Map<String, Event> getOutputEvents() {
        return this.outputEvents;
    }

    @Override
    protected LibraryElement createRootModelElement() {
        throw new UnsupportedOperationException("Cannot parse only interface");
    }

    @Override
    protected String getStartElementName() {
        throw new UnsupportedOperationException("Cannot parse only interface");
    }

    @Override
    protected CommonElementImporter.IChildHandler getBaseChildrenHandler() {
        throw new UnsupportedOperationException("Cannot parse only interface");
    }
}

