/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.properties;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.gef.Messages;
import org.eclipse.fordiac.ide.gef.filters.AttributeFilter;
import org.eclipse.fordiac.ide.gef.nat.AttributeColumnAccessor;
import org.eclipse.fordiac.ide.gef.nat.AttributeConfigLabelAccumulator;
import org.eclipse.fordiac.ide.gef.nat.AttributeEditableRule;
import org.eclipse.fordiac.ide.gef.nat.AttributeTableColumn;
import org.eclipse.fordiac.ide.gef.nat.DefaultImportCopyPasteLayerConfiguration;
import org.eclipse.fordiac.ide.gef.nat.InitialValueEditorConfiguration;
import org.eclipse.fordiac.ide.gef.properties.AbstractSection;
import org.eclipse.fordiac.ide.model.AttributeInheritMode;
import org.eclipse.fordiac.ide.model.commands.change.ChangeAttributeOrderCommand;
import org.eclipse.fordiac.ide.model.commands.create.AddNewImportCommand;
import org.eclipse.fordiac.ide.model.commands.create.CreateAttributeCommand;
import org.eclipse.fordiac.ide.model.commands.delete.DeleteAttributeCommand;
import org.eclipse.fordiac.ide.model.data.InternalDataType;
import org.eclipse.fordiac.ide.model.datatype.helper.InternalAttributeDeclarations;
import org.eclipse.fordiac.ide.model.helpers.FBNetworkElementHelper;
import org.eclipse.fordiac.ide.model.helpers.ImportHelper;
import org.eclipse.fordiac.ide.model.helpers.ModelHelper;
import org.eclipse.fordiac.ide.model.libraryElement.Attribute;
import org.eclipse.fordiac.ide.model.libraryElement.AttributeDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.ConfigurableObject;
import org.eclipse.fordiac.ide.model.libraryElement.Connection;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.ITypedElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.libraryElement.TypedConfigureableObject;
import org.eclipse.fordiac.ide.model.typelibrary.TypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibrary;
import org.eclipse.fordiac.ide.model.ui.nat.DataTypeSelectionTreeContentProvider;
import org.eclipse.fordiac.ide.model.ui.nat.TypeSelectionTreeContentProvider;
import org.eclipse.fordiac.ide.model.ui.widgets.AttributeSelectionContentProvider;
import org.eclipse.fordiac.ide.model.ui.widgets.DataTypeSelectionContentProvider;
import org.eclipse.fordiac.ide.model.ui.widgets.ITypeSelectionContentProvider;
import org.eclipse.fordiac.ide.model.ui.widgets.ImportContentProposal;
import org.eclipse.fordiac.ide.model.ui.widgets.ImportTypeSelectionProposalProvider;
import org.eclipse.fordiac.ide.model.ui.widgets.TypeSelectionButton;
import org.eclipse.fordiac.ide.ui.FordiacLogHelper;
import org.eclipse.fordiac.ide.ui.errormessages.ErrorMessenger;
import org.eclipse.fordiac.ide.ui.widget.AddDeleteReorderListWidget;
import org.eclipse.fordiac.ide.ui.widget.ChangeableListDataProvider;
import org.eclipse.fordiac.ide.ui.widget.CommandExecutor;
import org.eclipse.fordiac.ide.ui.widget.I4diacNatTableUtil;
import org.eclipse.fordiac.ide.ui.widget.IChangeableRowDataProvider;
import org.eclipse.fordiac.ide.ui.widget.NatTableColumn;
import org.eclipse.fordiac.ide.ui.widget.NatTableColumnProvider;
import org.eclipse.fordiac.ide.ui.widget.NatTableWidgetFactory;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommandHandler;
import org.eclipse.nebula.widgets.nattable.config.AbstractRegistryConfiguration;
import org.eclipse.nebula.widgets.nattable.config.EditableRule;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.IConfiguration;
import org.eclipse.nebula.widgets.nattable.config.IEditableRule;
import org.eclipse.nebula.widgets.nattable.data.IColumnAccessor;
import org.eclipse.nebula.widgets.nattable.data.IDataProvider;
import org.eclipse.nebula.widgets.nattable.data.IRowDataProvider;
import org.eclipse.nebula.widgets.nattable.data.validate.IDataValidator;
import org.eclipse.nebula.widgets.nattable.edit.EditConfigAttributes;
import org.eclipse.nebula.widgets.nattable.edit.command.UpdateDataCommand;
import org.eclipse.nebula.widgets.nattable.edit.command.UpdateDataCommandHandler;
import org.eclipse.nebula.widgets.nattable.edit.editor.ICellEditor;
import org.eclipse.nebula.widgets.nattable.edit.editor.TextCellEditor;
import org.eclipse.nebula.widgets.nattable.edit.event.DataUpdateEvent;
import org.eclipse.nebula.widgets.nattable.layer.DataLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.cell.IConfigLabelAccumulator;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.layer.event.ILayerEvent;
import org.eclipse.nebula.widgets.nattable.style.DisplayMode;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class AttributeSection
extends AbstractSection
implements I4diacNatTableUtil {
    protected IChangeableRowDataProvider<Attribute> provider;
    protected NatTable table;
    protected AddDeleteReorderListWidget buttons;
    private final IDataValidator attributeNameValidator = new IDataValidator(){

        /*
         * WARNING - void declaration
         */
        public boolean validate(int columnIndex, int rowIndex, Object newValue) {
            void name;
            if (!(newValue instanceof String)) {
                return true;
            }
            String string = (String)newValue;
            if (AttributeSection.isInternalAttribute((String)name)) {
                ErrorMessenger.popUpErrorMessage((String)MessageFormat.format(Messages.AttributeSection_NameReservedKeyWord, name));
                return false;
            }
            return true;
        }

        public boolean validate(ILayerCell cell, IConfigRegistry configRegistry, Object newValue) {
            return this.validate(cell.getColumnIndex(), cell.getRowIndex(), newValue);
        }
    };

    @Override
    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        super.createControls(parent, tabbedPropertySheetPage);
        this.createAttributesControls(parent);
    }

    public void createAttributesControls(Composite parent) {
        Composite composite = this.getWidgetFactory().createComposite(parent);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.buttons = new AddDeleteReorderListWidget();
        this.buttons.createControls(composite, (FormToolkit)this.getWidgetFactory());
        this.provider = new ChangeableListDataProvider((IColumnAccessor)new AttributeColumnAccessor(this));
        DataLayer dataLayer = new DataLayer(this.provider);
        dataLayer.unregisterCommandHandler(UpdateDataCommand.class);
        dataLayer.registerCommandHandler((ILayerCommandHandler)new AttributeUpdateDataCommandHandler(dataLayer));
        dataLayer.setConfigLabelAccumulator((IConfigLabelAccumulator)new AttributeConfigLabelAccumulator((IRowDataProvider<Attribute>)this.provider, this::getAnnotationModel));
        NatTableColumnProvider columnProvider = new NatTableColumnProvider(AttributeTableColumn.DEFAULT_COLUMNS);
        this.table = NatTableWidgetFactory.createRowNatTable((Composite)composite, (DataLayer)dataLayer, (IDataProvider)columnProvider, (IEditableRule)new AttributeEditableRule((IEditableRule)new EditableRule(){

            public boolean isEditable(int columnIndex, int rowIndex) {
                return AttributeSection.this.isTypeEditable();
            }
        }, AttributeTableColumn.DEFAULT_COLUMNS, (IRowDataProvider<Attribute>)this.provider), (ICellEditor)new TypeSelectionButton(this::getTypeLibrary, (ITypeSelectionContentProvider)DataTypeSelectionContentProvider.INSTANCE, (TypeSelectionTreeContentProvider)DataTypeSelectionTreeContentProvider.INSTANCE), (I4diacNatTableUtil)this, (boolean)false);
        this.table.addConfiguration((IConfiguration)new InitialValueEditorConfiguration((IRowDataProvider<? extends ITypedElement>)this.provider));
        Predicate<TypeEntry> targetFilter = entry -> {
            LibraryElement libraryElement = entry.getType();
            if (libraryElement instanceof AttributeDeclaration) {
                AttributeDeclaration decl = (AttributeDeclaration)libraryElement;
                return decl.isValidObject(this.getType());
            }
            return true;
        };
        final AttributeNameCellEditor attributeNameCellEditor = new AttributeNameCellEditor();
        attributeNameCellEditor.enableContentProposal((IControlContentAdapter)new TextContentAdapter(), (IContentProposalProvider)new ImportTypeSelectionProposalProvider(this::getType, TypeLibrary::getAttributeTypeEntry, (ITypeSelectionContentProvider)AttributeSelectionContentProvider.INSTANCE, targetFilter), KeyStroke.getInstance((int)262144, (int)32), null);
        this.table.addConfiguration((IConfiguration)new AbstractRegistryConfiguration(){

            public void configureRegistry(IConfigRegistry configRegistry) {
                configRegistry.registerConfigAttribute(EditConfigAttributes.CELL_EDITOR, (Object)attributeNameCellEditor, DisplayMode.EDIT, "ATTRIBUTE_PROPOSAL_CELL");
                configRegistry.registerConfigAttribute(EditConfigAttributes.DATA_VALIDATOR, (Object)AttributeSection.this.attributeNameValidator, DisplayMode.EDIT, "ATTRIBUTE_PROPOSAL_CELL");
            }
        });
        this.table.addConfiguration((IConfiguration)new DefaultImportCopyPasteLayerConfiguration((NatTableColumnProvider<? extends NatTableColumn>)columnProvider, this));
        this.table.configure();
        this.buttons.bindToTableViewer(this.table, (CommandExecutor)this, ref -> CreateAttributeCommand.forTemplate((ConfigurableObject)this.getType(), (Attribute)this.getLastSelectedAttribute(), (int)this.getInsertionIndex()), ref -> new DeleteAttributeCommand(this.getType(), this.getLastSelectedAttribute()), ref -> new ChangeAttributeOrderCommand(this.getType(), (Attribute)ref, this.getNeighbourListItem((Attribute)ref, true)), ref -> new ChangeAttributeOrderCommand(this.getType(), (Attribute)ref, this.getNeighbourListItem((Attribute)ref, false)));
    }

    private boolean isTypeEditable() {
        Connection conn;
        IInterfaceElement ie;
        FBNetworkElement fbne;
        ConfigurableObject type = this.getType();
        return !(type instanceof FBNetworkElement && (fbne = (FBNetworkElement)type).isContainedInTypedInstance() || type instanceof IInterfaceElement && (ie = (IInterfaceElement)type).getBlockFBNetworkElement() != null && ie.getBlockFBNetworkElement().isContainedInTypedInstance() || type instanceof Connection && FBNetworkElementHelper.isContainedInTypedInstance((EObject)(conn = (Connection)type)));
    }

    private Attribute getNeighbourListItem(Attribute ref, boolean above) {
        List<Attribute> filtered = this.getType().getAttributes().stream().filter(att -> !(att.getType() instanceof InternalDataType)).toList();
        int idx = filtered.indexOf(ref);
        idx = above ? (idx > 0 ? idx - 1 : 0) : (idx < filtered.size() - 1 ? idx + 1 : filtered.size() - 1);
        return filtered.get(idx);
    }

    private int getInsertionIndex() {
        Attribute attribute = this.getLastSelectedAttribute();
        if (attribute == null) {
            return this.getType().getAttributes().size();
        }
        return this.getType().getAttributes().indexOf((Object)attribute) + 1;
    }

    private Attribute getLastSelectedAttribute() {
        return (Attribute)NatTableWidgetFactory.getLastSelectedVariable((NatTable)this.table);
    }

    private List<Attribute> getFilteredAttributeList() {
        Collection copiedInheritAttributes;
        ConfigurableObject confObject = this.getType();
        List<Attribute> filteredList = confObject != null ? confObject.getAttributes().stream().filter(att -> !(att.getType() instanceof InternalDataType) && !InternalAttributeDeclarations.isInternalAttribute((AttributeDeclaration)att.getAttributeDeclaration())).toList() : Collections.emptyList();
        ConfigurableObject original = this.getTypeElement(confObject);
        if (original != null && !(copiedInheritAttributes = EcoreUtil.copyAll((Collection)AttributeInheritMode.getInheritAttributes((ConfigurableObject)confObject, (List)original.getAttributes()))).isEmpty()) {
            filteredList = new ArrayList<Attribute>(filteredList);
            filteredList.addAll(copiedInheritAttributes);
        }
        return filteredList;
    }

    private ConfigurableObject getTypeElement(ConfigurableObject copy) {
        IInterfaceElement interfaceElement;
        ConfigurableObject configurableObject;
        TypedConfigureableObject typedConfigObject;
        if (copy instanceof TypedConfigureableObject && (typedConfigObject = (TypedConfigureableObject)copy).getTypeEntry() != null) {
            return typedConfigObject.getTypeEntry().getType();
        }
        if (copy instanceof IInterfaceElement && (configurableObject = this.getTypeElement((ConfigurableObject)(interfaceElement = (IInterfaceElement)copy).getBlockFBNetworkElement())) instanceof FBType) {
            FBType fbType = (FBType)configurableObject;
            return fbType.getInterfaceList().getInterfaceElement(interfaceElement.getName());
        }
        return null;
    }

    public void addEntry(Object entry, boolean isInput, int index, CompoundCommand cmd) {
        if (entry instanceof Attribute) {
            Attribute attribute = (Attribute)entry;
            cmd.add((Command)CreateAttributeCommand.forTemplate((ConfigurableObject)this.getType(), (Attribute)attribute, (int)index));
        }
    }

    @Override
    protected void performRefresh() {
        this.provider.setInput(this.getFilteredAttributeList());
        this.table.refresh();
    }

    @Override
    protected void performRefreshAnnotations() {
        this.table.refresh(false);
    }

    @Override
    public void executeCommand(Command cmd) {
        super.executeCommand(cmd);
        this.provider.setInput(this.getFilteredAttributeList());
    }

    public void executeCompoundCommand(CompoundCommand cmd) {
        this.executeCommand((Command)cmd);
        this.table.refresh();
    }

    public boolean isEditable() {
        return this.isTypeEditable();
    }

    protected ConfigurableObject getInputType(Object input) {
        ConfigurableObject configurableObject;
        Object object = AttributeFilter.parseObject(input);
        return object instanceof ConfigurableObject ? (configurableObject = (ConfigurableObject)object) : null;
    }

    @Override
    protected void setInputCode() {
    }

    @Override
    protected void setInputInit() {
        this.provider.setInput(this.getFilteredAttributeList());
        this.buttons.setEnabled(this.isTypeEditable());
        this.table.refresh();
    }

    public void removeEntry(Object entry, CompoundCommand cmd) {
        if (entry instanceof Attribute) {
            Attribute attribute = (Attribute)entry;
            cmd.add((Command)new DeleteAttributeCommand(this.getType(), attribute));
        }
    }

    public static boolean isInternalAttribute(String name) {
        return InternalAttributeDeclarations.getInternalAttributeByName((String)name) != null;
    }

    protected ConfigurableObject getType() {
        ConfigurableObject configurableObject;
        Object object = this.type;
        return object instanceof ConfigurableObject ? (configurableObject = (ConfigurableObject)object) : null;
    }

    protected class AttributeNameCellEditor
    extends TextCellEditor {
        protected AttributeNameCellEditor() {
        }

        protected void configureContentProposalAdapter(ContentProposalAdapter contentProposalAdapter) {
            contentProposalAdapter.addContentProposalListener(this::proposalAccepted);
            super.configureContentProposalAdapter(contentProposalAdapter);
        }

        protected void proposalAccepted(IContentProposal proposal) {
            ImportContentProposal importProposal;
            LibraryElement libraryElement = ModelHelper.getLibraryElementFromContextChecked((EObject)AttributeSection.this.getType());
            if (proposal instanceof ImportContentProposal && !ImportHelper.matchesImports((String)(importProposal = (ImportContentProposal)proposal).getImportedNamespace(), (LibraryElement)libraryElement)) {
                AttributeSection.this.executeCommand((Command)new AddNewImportCommand(libraryElement, importProposal.getImportedNamespace()));
            }
        }
    }

    protected class AttributeUpdateDataCommandHandler
    extends UpdateDataCommandHandler {
        private final DataLayer dataLayer;

        public AttributeUpdateDataCommandHandler(DataLayer dataLayer) {
            super(dataLayer);
            this.dataLayer = dataLayer;
        }

        protected boolean doCommand(UpdateDataCommand command) {
            try {
                int columnPosition = command.getColumnPosition();
                int rowPosition = command.getRowPosition();
                Object currentValue = this.dataLayer.getDataValueByPosition(columnPosition, rowPosition);
                Object newValue = command.getNewValue();
                if (currentValue == null && newValue != null || newValue == null && currentValue != null || currentValue != null && !currentValue.equals(newValue)) {
                    Attribute attribute = (Attribute)AttributeSection.this.provider.getRowObject(rowPosition);
                    if (attribute.eContainer() == null) {
                        AttributeSection.this.getType().getAttributes().add((Object)attribute);
                    }
                    this.dataLayer.setDataValueByPosition(columnPosition, rowPosition, newValue);
                    this.dataLayer.fireLayerEvent((ILayerEvent)new DataUpdateEvent((ILayer)this.dataLayer, columnPosition, rowPosition, currentValue, newValue));
                }
                return true;
            }
            catch (Exception e) {
                FordiacLogHelper.logError((String)MessageFormat.format(Messages.NatTable_Update_Failed, command.getNewValue()), (Throwable)e);
                return false;
            }
        }
    }
}

