/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.export.utils;

import java.util.Optional;
import java.util.stream.Stream;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.fordiac.ide.export.IExportFilter;
import org.eclipse.fordiac.ide.export.Messages;
import org.eclipse.fordiac.ide.ui.FordiacLogHelper;

public class ExportFilterUtil {
    public static final String FILTER_ID = "id";
    private static final String SORT_INDEX = "sortIndex";
    private static final IConfigurationElement[] filters = ExportFilterUtil.getAvailableExportFilters();

    public static Optional<IConfigurationElement> getExportFilter(String id) {
        return Stream.of(filters).filter(expf -> expf.getAttribute(FILTER_ID).equals(id)).findFirst();
    }

    public static IConfigurationElement[] getExportFilters() {
        return filters;
    }

    public static IExportFilter createExportFilter(Optional<IConfigurationElement> filterConfig) {
        try {
            if (filterConfig.isPresent()) {
                return (IExportFilter)filterConfig.get().createExecutableExtension("class");
            }
        }
        catch (CoreException e) {
            FordiacLogHelper.logError((String)Messages.FordiacExporter_ERROR, (Throwable)e);
        }
        return null;
    }

    public static boolean validateExportPath(String directoy, IProject project) {
        if (!directoy.isEmpty()) {
            Path path = new Path(directoy);
            if (path.isAbsolute() || path.getDevice() != null) {
                return false;
            }
            Path resolved = new Path(project.getFullPath().append((IPath)path).toPath().normalize().toString());
            return project.getFullPath().isPrefixOf((IPath)resolved);
        }
        return false;
    }

    private static IConfigurationElement[] getAvailableExportFilters() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] elems = registry.getConfigurationElementsFor("org.eclipse.fordiac.ide.export.exportFilter");
        return (IConfigurationElement[])Stream.of(elems).sorted((o1, o2) -> {
            try {
                int sortIndex1 = Integer.parseInt(o1.getAttribute(SORT_INDEX));
                int sortIndex2 = Integer.parseInt(o2.getAttribute(SORT_INDEX));
                return sortIndex1 - sortIndex2;
            }
            catch (NumberFormatException e2) {
                FordiacLogHelper.logError((String)e2.getMessage(), (Throwable)e2);
                return 0;
            }
        }).toArray(IConfigurationElement[]::new);
    }

    private ExportFilterUtil() {
        throw new UnsupportedOperationException();
    }
}

