/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.datatype.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.fordiac.ide.model.data.ArrayType;
import org.eclipse.fordiac.ide.model.data.DataFactory;
import org.eclipse.fordiac.ide.model.data.DataType;
import org.eclipse.fordiac.ide.model.data.Subrange;

public final class TypeDeclarationParser {
    private static final Pattern SIMPLE_SUBRANGE_PATTERN = Pattern.compile("([\\+\\-]?+\\d++)\\s*+\\.\\.\\s*+([\\+\\-]?+\\d++)");
    private static final Pattern SIMPLE_ARRAY_SIZE_PATTERN = Pattern.compile(String.valueOf(SIMPLE_SUBRANGE_PATTERN) + "(?:\\s*+,\\s*+" + String.valueOf(SIMPLE_SUBRANGE_PATTERN) + ")*+");

    public static DataType parseTypeDeclaration(DataType baseType, String arraySize) {
        DataType result = TypeDeclarationParser.parseLegacyTypeDeclaration(baseType, arraySize);
        if (result != null) {
            return result;
        }
        return TypeDeclarationParser.parseSimpleTypeDeclaration(baseType, arraySize);
    }

    public static DataType parseLegacyTypeDeclaration(DataType baseType, String arraySize) {
        int length;
        block3: {
            try {
                length = Integer.parseInt(arraySize.trim());
                if (length > 0) break block3;
                return null;
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return TypeDeclarationParser.newArrayType(baseType, TypeDeclarationParser.newSubrange(0, length - 1));
    }

    public static DataType parseSimpleTypeDeclaration(DataType baseType, String arraySize) {
        List<String> subrangeStrings = TypeDeclarationParser.splitString(arraySize);
        if (subrangeStrings.isEmpty()) {
            return null;
        }
        List<Subrange> subranges = subrangeStrings.stream().map(TypeDeclarationParser::parseSimpleSubrange).toList();
        return TypeDeclarationParser.newArrayType(baseType, subranges);
    }

    public static boolean isSimpleTypeDeclaration(String arraySize) {
        return arraySize == null || arraySize.isEmpty() || SIMPLE_ARRAY_SIZE_PATTERN.matcher(arraySize.trim()).matches();
    }

    public static boolean isVariableArrayBounds(String arraySize) {
        if (arraySize != null && !arraySize.isBlank()) {
            if (TypeDeclarationParser.splitString(arraySize).stream().map(String::strip).anyMatch("*"::equals)) {
                return true;
            }
        }
        return false;
    }

    private static Subrange parseSimpleSubrange(String text) {
        Matcher matcher = SIMPLE_SUBRANGE_PATTERN.matcher(text);
        if (matcher.matches()) {
            String lowerBoundString = matcher.group(1);
            String upperBoundString = matcher.group(2);
            try {
                return TypeDeclarationParser.newSubrange(Integer.parseInt(lowerBoundString), Integer.parseInt(upperBoundString));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return DataFactory.eINSTANCE.createSubrange();
    }

    private static List<String> splitString(String text) {
        ArrayList<String> result = new ArrayList<String>();
        int depth = 0;
        boolean string = false;
        int lastSplitIndex = -1;
        int i = 0;
        int end = text.length();
        while (i < end) {
            switch (text.charAt(i)) {
                case '\"': {
                    string = !string;
                    break;
                }
                case '$': {
                    if (!string) break;
                    ++i;
                    break;
                }
                case '(': 
                case '[': 
                case '{': {
                    if (string) break;
                    ++depth;
                    break;
                }
                case ')': 
                case ']': 
                case '}': {
                    if (string) break;
                    if (depth == 0) {
                        return Collections.emptyList();
                    }
                    --depth;
                    break;
                }
                case ',': {
                    if (string || depth != 0) break;
                    result.add(text.substring(lastSplitIndex + 1, i).trim());
                    lastSplitIndex = i;
                    break;
                }
            }
            ++i;
        }
        if (depth != 0) {
            return Collections.emptyList();
        }
        result.add(text.substring(lastSplitIndex + 1).trim());
        return result;
    }

    private static ArrayType newArrayType(DataType arrayBaseType, Subrange ... arraySubranges) {
        return TypeDeclarationParser.newArrayType(arrayBaseType, Arrays.asList(arraySubranges));
    }

    private static ArrayType newArrayType(DataType arrayBaseType, List<Subrange> arraySubranges) {
        if (arrayBaseType == null) {
            return null;
        }
        ArrayType result = DataFactory.eINSTANCE.createArrayType();
        result.setName("ARRAY [" + arraySubranges.stream().map(TypeDeclarationParser::getSubrangeString).collect(Collectors.joining(", ")) + "] OF " + arrayBaseType.getName());
        result.setBaseType(arrayBaseType);
        result.getSubranges().addAll(arraySubranges);
        return result;
    }

    private static Subrange newSubrange(int lower, int upper) {
        Subrange result = DataFactory.eINSTANCE.createSubrange();
        result.setLowerLimit(lower);
        result.setUpperLimit(upper);
        return result;
    }

    private static String getSubrangeString(Subrange subrange) {
        if (subrange.isSetLowerLimit() && subrange.isSetUpperLimit()) {
            return subrange.getLowerLimit() + ".." + subrange.getUpperLimit();
        }
        return "*";
    }

    private TypeDeclarationParser() {
        throw new UnsupportedOperationException();
    }
}

