/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.hierarchymanager.ui.properties;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.fordiac.ide.hierarchymanager.model.hierarchy.Level;
import org.eclipse.fordiac.ide.hierarchymanager.ui.handlers.AbstractHierarchyHandler;
import org.eclipse.fordiac.ide.hierarchymanager.ui.operations.ChangeLevelCommentOperation;
import org.eclipse.fordiac.ide.hierarchymanager.ui.operations.RenameLevelOperation;
import org.eclipse.fordiac.ide.hierarchymanager.ui.properties.LevelSectionFilter;
import org.eclipse.fordiac.ide.model.emf.SingleRecursiveContentAdapter;
import org.eclipse.fordiac.ide.ui.FordiacMessages;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class LevelSection
extends AbstractPropertySection {
    private Text commentText;
    private Text nameText;
    private Level type;
    private Composite parent;
    private boolean blockListeners;
    private final Adapter contentAdapter = new SingleRecursiveContentAdapter(){

        public void notifyChanged(Notification notification) {
            super.notifyChanged(notification);
            LevelSection.this.notifiyRefresh();
        }
    };

    protected void notifiyRefresh() {
        if (this.type != null && this.type.eAdapters().contains((Object)this.contentAdapter)) {
            this.parent.getDisplay().asyncExec(() -> {
                if (!this.parent.isDisposed()) {
                    this.refresh();
                }
            });
        }
    }

    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        super.createControls(parent, tabbedPropertySheetPage);
        this.parent = parent;
        Composite fbInfoContainer = this.createFBInfoContainer(parent);
        this.createNameEntry(fbInfoContainer);
        this.createCommentEntry(fbInfoContainer);
    }

    public void refresh() {
        if (this.type != null) {
            this.blockListeners = true;
            this.commentText.setText(this.type.getComment() != null ? this.type.getComment() : "");
            this.nameText.setText(this.type.getName() != null ? this.type.getName() : "N/A");
            this.blockListeners = false;
        }
    }

    protected Composite createFBInfoContainer(Composite parent) {
        Composite fbInfoContainer = this.getWidgetFactory().createComposite(parent);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(fbInfoContainer);
        GridDataFactory.fillDefaults().align(4, 128).grab(true, true).applyTo((Control)fbInfoContainer);
        return fbInfoContainer;
    }

    private void createNameEntry(Composite parent) {
        CLabel nameLabel = this.getWidgetFactory().createCLabel(parent, FordiacMessages.Name + ":");
        GridDataFactory.fillDefaults().align(16384, 128).grab(false, false).applyTo((Control)nameLabel);
        this.nameText = this.createGroupText(parent, true, 2052);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, false).applyTo((Control)this.nameText);
        this.nameText.addModifyListener(e -> {
            if (!this.blockListeners) {
                this.removeContentAdapter();
                AbstractHierarchyHandler.executeOperation(new RenameLevelOperation(this.type, this.nameText.getText()));
                this.addContentAdapter();
            }
        });
    }

    private void createCommentEntry(Composite parent) {
        CLabel commentLabel = this.getWidgetFactory().createCLabel(parent, FordiacMessages.Comment + ":");
        GridDataFactory.fillDefaults().align(16384, 128).grab(false, false).applyTo((Control)commentLabel);
        this.commentText = this.createGroupText(parent, true, 2562);
        GridDataFactory.fillDefaults().align(4, 128).hint(-1, 6 * this.commentText.getLineHeight()).grab(true, false).applyTo((Control)this.commentText);
        this.commentText.addModifyListener(e -> {
            if (!this.blockListeners) {
                this.removeContentAdapter();
                AbstractHierarchyHandler.executeOperation(new ChangeLevelCommentOperation(this.type, this.commentText.getText()));
                this.addContentAdapter();
            }
        });
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        Object input = selection;
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection sel = (IStructuredSelection)selection;
            input = sel.getFirstElement();
        }
        this.removeContentAdapter();
        this.type = LevelSectionFilter.levelFromSelectedObject(input);
        this.addContentAdapter();
    }

    protected Text createGroupText(Composite group, boolean editable, int style) {
        Text text = this.getWidgetFactory().createText(group, "", style);
        text.setLayoutData((Object)new GridData(4, 0, true, false));
        text.setEditable(editable);
        text.setEnabled(editable);
        return text;
    }

    protected void removeContentAdapter() {
        if (this.type != null && this.type.eAdapters().contains((Object)this.contentAdapter)) {
            this.type.eAdapters().remove((Object)this.contentAdapter);
        }
    }

    protected void addContentAdapter() {
        if (this.type != null && !this.type.eAdapters().contains((Object)this.contentAdapter)) {
            this.type.eAdapters().add((Object)this.contentAdapter);
        }
    }
}

