/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.commands;

import org.eclipse.fordiac.ide.application.commands.ConvertToFiveSegmentsConnectionCommand;
import org.eclipse.fordiac.ide.application.commands.ConvertToThreeSegmentsConnectionCommand;
import org.eclipse.fordiac.ide.model.libraryElement.Connection;
import org.eclipse.fordiac.ide.model.libraryElement.ConnectionRoutingData;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.gef.commands.Command;

public abstract class ToggleConnectionBendpointCommand
extends Command {
    private final Connection connection;
    private final ConnectionRoutingData oldRoutingData;
    private ConnectionRoutingData newRoutingData;

    public static ToggleConnectionBendpointCommand createCommand(Connection connection) {
        if (connection.getRoutingData().is5SegementData()) {
            return new ConvertToThreeSegmentsConnectionCommand(connection);
        }
        return new ConvertToFiveSegmentsConnectionCommand(connection);
    }

    protected ToggleConnectionBendpointCommand(Connection connection) {
        this.connection = connection;
        this.oldRoutingData = connection.getRoutingData();
    }

    protected abstract void manipulateNewRoutingData(ConnectionRoutingData var1);

    public void execute() {
        this.createInitalNewRoutingData();
        this.manipulateNewRoutingData(this.newRoutingData);
        this.connection.setRoutingData(this.newRoutingData);
    }

    public void redo() {
        this.connection.setRoutingData(this.newRoutingData);
    }

    public void undo() {
        this.connection.setRoutingData(this.oldRoutingData);
    }

    protected void createInitalNewRoutingData() {
        this.newRoutingData = LibraryElementFactory.eINSTANCE.createConnectionRoutingData();
        this.newRoutingData.setDx1(this.oldRoutingData.getDx1());
        this.newRoutingData.setDx2(this.oldRoutingData.getDx2());
        this.newRoutingData.setDy(this.oldRoutingData.getDy());
    }
}

