/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.api.list;

import java.util.Comparator;
import java.util.Random;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.function.primitive.BooleanFunction;
import org.eclipse.collections.api.block.function.primitive.ByteFunction;
import org.eclipse.collections.api.block.function.primitive.CharFunction;
import org.eclipse.collections.api.block.function.primitive.DoubleFunction;
import org.eclipse.collections.api.block.function.primitive.FloatFunction;
import org.eclipse.collections.api.block.function.primitive.IntFunction;
import org.eclipse.collections.api.block.function.primitive.LongFunction;
import org.eclipse.collections.api.block.function.primitive.ShortFunction;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.list.MutableList;

public interface MultiReaderList<T>
extends MutableList<T> {
    public void withReadLockAndDelegate(Procedure<? super MutableList<T>> var1);

    public void withWriteLockAndDelegate(Procedure<? super MutableList<T>> var1);

    @Override
    public MultiReaderList<T> newEmpty();

    @Override
    public MultiReaderList<T> clone();

    @Override
    public MultiReaderList<T> subList(int var1, int var2);

    @Override
    default public MultiReaderList<T> with(T element) {
        this.add(element);
        return this;
    }

    @Override
    default public MultiReaderList<T> without(T element) {
        this.remove(element);
        return this;
    }

    @Override
    default public MultiReaderList<T> withAll(Iterable<? extends T> elements) {
        this.addAllIterable(elements);
        return this;
    }

    @Override
    default public MultiReaderList<T> withoutAll(Iterable<? extends T> elements) {
        this.removeAllIterable(elements);
        return this;
    }

    @Override
    default public MultiReaderList<T> tap(Procedure<? super T> procedure) {
        this.forEach(procedure);
        return this;
    }

    @Override
    default public MultiReaderList<T> sortThis(Comparator<? super T> comparator) {
        this.sort(comparator);
        return this;
    }

    @Override
    default public MultiReaderList<T> sortThis() {
        return this.sortThis((Comparator)null);
    }

    @Override
    public <V extends Comparable<? super V>> MultiReaderList<T> sortThisBy(Function<? super T, ? extends V> var1);

    @Override
    public MultiReaderList<T> sortThisByInt(IntFunction<? super T> var1);

    @Override
    public MultiReaderList<T> sortThisByBoolean(BooleanFunction<? super T> var1);

    @Override
    public MultiReaderList<T> sortThisByChar(CharFunction<? super T> var1);

    @Override
    public MultiReaderList<T> sortThisByByte(ByteFunction<? super T> var1);

    @Override
    public MultiReaderList<T> sortThisByShort(ShortFunction<? super T> var1);

    @Override
    public MultiReaderList<T> sortThisByFloat(FloatFunction<? super T> var1);

    @Override
    public MultiReaderList<T> sortThisByLong(LongFunction<? super T> var1);

    @Override
    public MultiReaderList<T> sortThisByDouble(DoubleFunction<? super T> var1);

    @Override
    public MultiReaderList<T> reverseThis();

    @Override
    public MultiReaderList<T> shuffleThis();

    @Override
    public MultiReaderList<T> shuffleThis(Random var1);
}

