/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.systemmanagement.ui.wizard;

import java.util.Optional;
import org.eclipse.fordiac.ide.model.IdentifierVerifier;
import org.eclipse.fordiac.ide.systemmanagement.ui.Messages;
import org.eclipse.fordiac.ide.systemmanagement.ui.wizard.InitialNameGroup;
import org.eclipse.fordiac.ide.ui.FordiacMessages;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;

public class NewSystemWizardPage
extends WizardNewFileCreationPage {
    private Button openApplicationCheckbox;
    private int openApplicationParentHeight = -1;
    private boolean openApplication = true;
    private InitialNameGroup applicationName;
    private boolean blockListeners = false;
    private final Listener nameModifyListener = e -> {
        if (!this.blockListeners) {
            this.setPageComplete(this.validatePage());
        }
    };

    public String getInitialApplicationName() {
        return this.applicationName.getInitialName();
    }

    public boolean getOpenApplication() {
        return this.openApplication;
    }

    public NewSystemWizardPage(IStructuredSelection selection) {
        super(Messages.NewSystemWizardPage_NewSystemTitle, selection);
        this.setTitle(Messages.NewSystemWizardPage_NewSystemTitle);
        this.setDescription(Messages.NewSystemWizardPage_CreateNewSystem);
        this.setAllowExistingResources(true);
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        Composite composite = (Composite)this.getControl();
        this.setErrorMessage(null);
        this.setMessage(null);
        this.setControl((Control)composite);
    }

    protected boolean validatePage() {
        this.blockListeners = true;
        try {
            Optional errorMessage = IdentifierVerifier.verifyIdentifier((String)super.getFileName());
            if (errorMessage.isPresent()) {
                this.setErrorMessage((String)errorMessage.get());
                return false;
            }
            if (!this.applicationName.validateName(super.getFileName() + "App")) {
                return false;
            }
            this.setErrorMessage(null);
            boolean bl = super.validatePage();
            return bl;
        }
        finally {
            this.blockListeners = false;
        }
    }

    protected String getNewFileLabel() {
        return FordiacMessages.SystemName + ":";
    }

    public String getSystemName() {
        return super.getFileName();
    }

    public String getFileName() {
        return super.getFileName() + ".sys";
    }

    protected void createAdvancedControls(Composite parent) {
        this.applicationName = new InitialNameGroup(parent, Messages.New4diacProjectWizard_InitialApplicationName);
        this.applicationName.addNameModifyListener(this.nameModifyListener);
        super.createAdvancedControls(parent);
    }

    protected void handleAdvancedButtonSelect() {
        Shell shell = this.getShell();
        Point shellSize = shell.getSize();
        Composite composite = (Composite)this.getControl();
        if (this.openApplicationCheckbox != null) {
            this.openApplicationCheckbox.dispose();
            this.openApplicationCheckbox = null;
            shell.setSize(shellSize.x, shellSize.y - this.openApplicationParentHeight);
        } else {
            this.openApplicationCheckbox = this.createOpenApplicationGroup(composite);
            if (-1 == this.openApplicationParentHeight) {
                Point groupSize = this.openApplicationCheckbox.computeSize(-1, -1, true);
                this.openApplicationParentHeight = groupSize.y;
            }
            shell.setSize(shellSize.x, shellSize.y + this.openApplicationParentHeight);
        }
        super.handleAdvancedButtonSelect();
    }

    private Button createOpenApplicationGroup(Composite parent) {
        this.openApplicationCheckbox = new Button(parent, 32);
        this.openApplicationCheckbox.setText(Messages.OpenApplicationForEditing);
        this.openApplicationCheckbox.setSelection(true);
        this.setPageComplete(this.validatePage());
        this.openApplicationCheckbox.addListener(13, ev -> {
            boolean bl = this.openApplication = this.openApplicationCheckbox.getSelection();
        });
        return this.openApplicationCheckbox;
    }
}

